/***************************************************************
 * MPFSImg2.c
 * Defines an MPFS2 image to be stored in program memory.
 *
 * NOT FOR HAND MODIFICATION
 * This file is automatically generated by the MPFS2 Utility
 * ALL MODIFICATIONS WILL BE OVERWRITTEN BY THE MPFS2 GENERATOR
 * Generated Monday, April 27, 2009 4:14:57 PM
 ***************************************************************/

#define __MPFSIMG2_C

#include "h/TCPIPConfig.h"
#if !defined(MPFS_USE_EEPROM) && !defined(MPFS_USE_SPI_FLASH)

#include "h/TCPIP.h"
#if defined(STACK_USE_MPFS2)


/**************************************
 * MPFS2 Image Data
 **************************************/
#define DATACHUNK000000 \
	0x4d,0x50,0x46,0x53,0x02,0x01,0x24,0x00,0x4a,0xce,0xff,0xff,0xea,0x81,0xff,0xff, /* MPFS..$.J....... */ \
	0x2a,0xba,0xff,0xff,0x26,0x4f,0x6a,0xa6,0xff,0xff,0x26,0x2d,0x0a,0xa3,0xff,0xff, /* ....&Oj...&-.... */ \
	0x46,0xce,0xff,0xff,0x2a,0xcf,0x08,0xcf,0x3e,0x67,0x98,0xdb,0xcc,0x83,0xff,0xff, /* F.......>g...... */ \
	0x0a,0x85,0xff,0xff,0x0a,0x57,0xff,0xff,0x0a,0x2f,0xff,0xff,0xea,0x92,0xff,0xff, /* .....W.../...... */ \
	0x0a,0x4f,0xff,0xff,0x26,0xb6,0xff,0xff,0x8a,0xb6,0xff,0xff,0xea,0x8a,0xff,0xff, /* .O..&........... */ \
	0x68,0x03,0x00,0x00,0x84,0x04,0x00,0x00,0x40,0x05,0x00,0x00,0x1e,0x08,0xe4,0x49, /* h.......@......I */ \
	0x00,0x00,0x00,0x00,0x02,0x00,0x71,0x03,0x00,0x00,0xc4,0x09,0x00,0x00,0x18,0x00, /* ......q......... */ \
	0x00,0x00,0x1e,0x08,0xe4,0x49,0x00,0x00,0x00,0x00,0x00,0x00,0x72,0x03,0x00,0x00, /* .....I......r... */ \
	0xdc,0x09,0x00,0x00,0x98,0x08,0x00,0x00,0x27,0x08,0xe4,0x49,0x00,0x00,0x00,0x00, /* ........'..I.... */ \
	0x02,0x00,0x7e,0x03,0x00,0x00,0x74,0x12,0x00,0x00,0x20,0x00,0x00,0x00,0x27,0x08, /* ..~...t... ...'. */ \
	0xe4,0x49,0x00,0x00,0x00,0x00,0x00,0x00,0x7f,0x03,0x00,0x00,0x94,0x12,0x00,0x00, /* .I.............. */ \
	0xf0,0x0a,0x00,0x00,0x30,0x08,0xe4,0x49,0x00,0x00,0x00,0x00,0x02,0x00,0x8b,0x03, /* ....0..I........ */ \
	0x00,0x00,0x84,0x1d,0x00,0x00,0x98,0x00,0x00,0x00,0x30,0x08,0xe4,0x49,0x00,0x00, /* ..........0..I.. */ \
	0x00,0x00,0x00,0x00,0x8c,0x03,0x00,0x00,0x1c,0x1e,0x00,0x00,0x9f,0x00,0x00,0x00, /* ................ */ \
	0x0e,0xe1,0x67,0x49,0x00,0x00,0x00,0x00,0x00,0x00,0x97,0x03,0x00,0x00,0xbb,0x1e, /* ..gI............ */ \
	0x00,0x00,0x08,0x0a,0x00,0x00,0x38,0x08,0xe4,0x49,0x00,0x00,0x00,0x00,0x02,0x00, /* ......8..I...... */ \
	0xa1,0x03,0x00,0x00,0xc3,0x28,0x00,0x00,0x58,0x00,0x00,0x00,0x38,0x08,0xe4,0x49, /* .....(..X...8..I */ \
	0x00,0x00,0x00,0x00,0x00,0x00,0xa2,0x03,0x00,0x00,0x1b,0x29,0x00,0x00,0x5e,0x04, /* ...........)..^. */ \
	0x00,0x00,0x1d,0x67,0xdd,0x49,0x00,0x00,0x00,0x00,0x00,0x00,0xad,0x03,0x00,0x00, /* ...g.I.......... */ \
	0x79,0x2d,0x00,0x00,0x4c,0x10,0x00,0x00,0x77,0x01,0x00,0x48,0x00,0x00,0x00,0x00, /* y-..L...w..H.... */ \
	0x02,0x00,0xb7,0x03,0x00,0x00,0xc5,0x3d,0x00,0x00,0x28,0x00,0x00,0x00,0x77,0x01, /* .......=..(...w. */ \
	0x00,0x48,0x00,0x00,0x00,0x00,0x00,0x00,0xb8,0x03,0x00,0x00,0xed,0x3d,0x00,0x00, /* .H...........=.. */ \
	0x11,0x00,0x00,0x00,0xcc,0x1c,0xd7,0x47,0x00,0x00,0x00,0x00,0x02,0x00,0xc1,0x03, /* .......G........ */ \
	0x00,0x00,0xfe,0x3d,0x00,0x00,0x08,0x00,0x00,0x00,0xcc,0x1c,0xd7,0x47,0x00,0x00, /* ...=.........G.. */ \
	0x00,0x00,0x00,0x00,0xc2,0x03,0x00,0x00,0x06,0x3e,0x00,0x00,0x23,0x04,0x00,0x00, /* .........>..#... */ \
	0x41,0x08,0xe4,0x49,0x00,0x00,0x00,0x00,0x01,0x00,0xcb,0x03,0x00,0x00,0x29,0x42, /* A..I..........)B */ \
	0x00,0x00,0xef,0x04,0x00,0x00,0x3c,0x71,0x81,0x46,0x00,0x00,0x00,0x00,0x00,0x00, /* ......<q.F...... */ \
	0xd4,0x03,0x00,0x00,0x18,0x47,0x00,0x00,0x12,0x0a,0x00,0x00,0x69,0x3b,0x7d,0x47, /* .....G......i;}G */ \
	0x00,0x00,0x00,0x00,0x01,0x00,0xdc,0x03,0x00,0x00,0x2a,0x51,0x00,0x00,0xe0,0x00, /* ...........Q.... */ \
	0x00,0x00,0x9c,0x7b,0xe3,0x49,0x00,0x00,0x00,0x00,0x00,0x00,0xe5,0x03,0x00,0x00, /* ...{.I.......... */ \
	0x0a,0x52,0x00,0x00,0x41,0x01,0x00,0x00,0x67,0xb0,0x59,0x47,0x00,0x00,0x00,0x00, /* .R..A...g.YG.... */ \
	0x02,0x00,0xf0,0x03,0x00,0x00,0x4b,0x53,0x00,0x00,0x68,0x00,0x00,0x00,0x67,0xb0, /* ......KS..h...g. */ \
	0x59,0x47,0x00,0x00,0x00,0x00,0x00,0x00,0xf1,0x03,0x00,0x00,0xb3,0x53,0x00,0x00, /* YG...........S.. */ \
	0xa0,0x03,0x00,0x00,0x49,0x08,0xe4,0x49,0x00,0x00,0x00,0x00,0x02,0x00,0xfc,0x03, /* ....I..I........ */ \
	0x00,0x00,0x53,0x57,0x00,0x00,0x20,0x00,0x00,0x00,0x49,0x08,0xe4,0x49,0x00,0x00, /* ..SW.. ...I..I.. */ \
	0x00,0x00,0x00,0x00,0xfd,0x03,0x00,0x00,0x73,0x57,0x00,0x00,0xb5,0x05,0x00,0x00, /* ........sW...... */ \
	0x80,0x09,0xe4,0x49,0x00,0x00,0x00,0x00,0x02,0x00,0x0e,0x04,0x00,0x00,0x28,0x5d, /* ...I..........(] */ \
	0x00,0x00,0x60,0x00,0x00,0x00,0x80,0x09,0xe4,0x49,0x00,0x00,0x00,0x00,0x00,0x00, /* ..`......I...... */ \
	0x0f,0x04,0x00,0x00,0x88,0x5d,0x00,0x00,0x54,0x07,0x00,0x00,0x85,0x93,0xe6,0x49, /* .....]..T......I */ \
	0x00,0x00,0x00,0x00,0x02,0x00,0x1f,0x04,0x00,0x00,0xdc,0x64,0x00,0x00,0x30,0x00, /* ...........d..0. */ \
	0x00,0x00,0x85,0x93,0xe6,0x49,0x00,0x00,0x00,0x00,0x00,0x00,0x20,0x04,0x00,0x00, /* .....I...... ... */ \
	0x0c,0x65,0x00,0x00,0x49,0x07,0x00,0x00,0xb6,0x06,0xe9,0x49,0x00,0x00,0x00,0x00, /* .e..I......I.... */ \
	0x02,0x00,0x33,0x04,0x00,0x00,0x55,0x6c,0x00,0x00,0x60,0x00,0x00,0x00,0xb6,0x06, /* ..3...Ul..`..... */ \
	0xe9,0x49,0x00,0x00,0x00,0x00,0x00,0x00,0x34,0x04,0x00,0x00,0xb5,0x6c,0x00,0x00, /* .I......4....l.. */ \
	0xc6,0x03,0x00,0x00,0x53,0x08,0xe4,0x49,0x00,0x00,0x00,0x00,0x02,0x00,0x46,0x04, /* ....S..I......F. */ \
	0x00,0x00,0x7b,0x70,0x00,0x00,0x18,0x00,0x00,0x00,0x53,0x08,0xe4,0x49,0x00,0x00, /* ..{p......S..I.. */ \
	0x00,0x00,0x00,0x00,0x47,0x04,0x00,0x00,0x93,0x70,0x00,0x00,0x08,0x00,0x00,0x00, /* ....G....p...... */ \
	0x41,0xf9,0x9f,0x46,0x00,0x00,0x00,0x00,0x02,0x00,0x5a,0x04,0x00,0x00,0x9b,0x70, /* A..F......Z....p */ \
	0x00,0x00,0x08,0x00,0x00,0x00,0x41,0xf9,0x9f,0x46,0x00,0x00,0x00,0x00,0x00,0x00, /* ......A..F...... */ \
	0x5b,0x04,0x00,0x00,0xa3,0x70,0x00,0x00,0x85,0x07,0x00,0x00,0x6d,0x98,0xe6,0x49, /* [....p......m..I */ \
	0x00,0x00,0x00,0x00,0x02,0x00,0x6e,0x04,0x00,0x00,0x28,0x78,0x00,0x00,0x20,0x00, /* ......n...(x.. . */ \
	0x00,0x00,0x6d,0x98,0xe6,0x49,0x00,0x00,0x00,0x00,0x00,0x00,0x6f,0x04,0x00,0x00, /* ..m..I......o... */ \
	0x48,0x78,0x00,0x00,0x3d,0x05,0x00,0x00,0x58,0x1a,0xe9,0x49,0x00,0x00,0x00,0x00, /* Hx..=...X..I.... */ \
	0x02,0x00,0x83,0x04,0x00,0x00,0x85,0x7d,0x00,0x00,0x48,0x00,0x00,0x00,0x58,0x1a, /* .......}..H...X. */ \
	0xe9,0x49,0x00,0x00,0x00,0x00,0x00,0x00,0x61,0x75,0x74,0x68,0x2e,0x68,0x74,0x6d, /* .I......auth.htm */ \
	0x00,0x00,0x63,0x6f,0x6f,0x6b,0x69,0x65,0x73,0x2e,0x68,0x74,0x6d,0x00,0x00,0x64, /* ..cookies.htm..d */ \
	0x79,0x6e,0x76,0x61,0x72,0x73,0x2e,0x68,0x74,0x6d,0x00,0x00,0x66,0x6f,0x6f,0x74, /* ynvars.htm..foot */ \
	0x65,0x72,0x2e,0x69,0x6e,0x63,0x00,0x66,0x6f,0x72,0x6d,0x73,0x2e,0x68,0x74,0x6d, /* er.inc.forms.htm */ \
	0x00,0x00,0x68,0x65,0x61,0x64,0x65,0x72,0x2e,0x69,0x6e,0x63,0x00,0x69,0x6e,0x64, /* ..header.inc.ind */ \
	0x65,0x78,0x2e,0x68,0x74,0x6d,0x00,0x00,0x6c,0x65,0x64,0x73,0x2e,0x63,0x67,0x69, /* ex.htm..leds.cgi */ \
	0x00,0x00,0x6d,0x63,0x68,0x70,0x2e,0x63,0x73,0x73,0x00,0x6d,0x63,0x68,0x70,0x2e, /* ..mchp.css.mchp. */ \
	0x67,0x69,0x66,0x00,0x6d,0x63,0x68,0x70,0x2e,0x6a,0x73,0x00,0x73,0x6e,0x6d,0x70, /* gif.mchp.js.snmp */ \
	0x2e,0x62,0x69,0x62,0x00,0x73,0x74,0x61,0x74,0x75,0x73,0x2e,0x78,0x6d,0x6c,0x00, /* .bib.status.xml. */ \
	0x00,0x75,0x70,0x6c,0x6f,0x61,0x64,0x2e,0x68,0x74,0x6d,0x00,0x00,0x64,0x79,0x6e  /* .upload.htm..dyn */
#define DATACHUNK000001 \
	0x64,0x6e,0x73,0x2f,0x69,0x6e,0x64,0x65,0x78,0x2e,0x68,0x74,0x6d,0x00,0x00,0x65, /* dns/index.htm..e */ \
	0x6d,0x61,0x69,0x6c,0x2f,0x69,0x6e,0x64,0x65,0x78,0x2e,0x68,0x74,0x6d,0x00,0x00, /* mail/index.htm.. */ \
	0x70,0x72,0x6f,0x74,0x65,0x63,0x74,0x2f,0x63,0x6f,0x6e,0x66,0x69,0x67,0x2e,0x68, /* protect/config.h */ \
	0x74,0x6d,0x00,0x00,0x70,0x72,0x6f,0x74,0x65,0x63,0x74,0x2f,0x69,0x6e,0x64,0x65, /* tm..protect/inde */ \
	0x78,0x2e,0x68,0x74,0x6d,0x00,0x00,0x70,0x72,0x6f,0x74,0x65,0x63,0x74,0x2f,0x72, /* x.htm..protect/r */ \
	0x65,0x62,0x6f,0x6f,0x74,0x2e,0x63,0x67,0x69,0x00,0x00,0x70,0x72,0x6f,0x74,0x65, /* eboot.cgi..prote */ \
	0x63,0x74,0x2f,0x72,0x65,0x62,0x6f,0x6f,0x74,0x2e,0x68,0x74,0x6d,0x00,0x00,0x73, /* ct/reboot.htm..s */ \
	0x6e,0x6d,0x70,0x2f,0x73,0x6e,0x6d,0x70,0x63,0x6f,0x6e,0x66,0x69,0x67,0x2e,0x68, /* nmp/snmpconfig.h */ \
	0x74,0x6d,0x00,0x00,0x7e,0x69,0x6e,0x63,0x3a,0x68,0x65,0x61,0x64,0x65,0x72,0x2e, /* tm..~inc:header. */ \
	0x69,0x6e,0x63,0x7e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x20,0x69,0x64,0x3d,0x22,0x63, /* inc~..<div id="c */ \
	0x6f,0x6e,0x74,0x65,0x6e,0x74,0x22,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x68,0x31,0x3e, /* ontent">....<h1> */ \
	0x41,0x75,0x74,0x68,0x65,0x6e,0x74,0x69,0x63,0x61,0x74,0x69,0x6f,0x6e,0x3c,0x2f, /* Authentication</ */ \
	0x68,0x31,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x70,0x3e,0x4d,0x61,0x6e,0x79,0x20,0x61, /* h1>....<p>Many a */ \
	0x70,0x70,0x6c,0x69,0x63,0x61,0x74,0x69,0x6f,0x6e,0x73,0x20,0x6e,0x65,0x65,0x64, /* pplications need */ \
	0x20,0x74,0x6f,0x20,0x72,0x65,0x73,0x74,0x72,0x69,0x63,0x74,0x20,0x61,0x63,0x63, /*  to restrict acc */ \
	0x65,0x73,0x73,0x20,0x74,0x6f,0x20,0x61,0x75,0x74,0x68,0x6f,0x72,0x69,0x7a,0x65, /* ess to authorize */ \
	0x64,0x20,0x75,0x73,0x65,0x72,0x73,0x2e,0x20,0x20,0x54,0x68,0x65,0x20,0x48,0x54, /* d users.  The HT */ \
	0x54,0x50,0x20,0x0d,0x0a,0x73,0x65,0x72,0x76,0x65,0x72,0x20,0x73,0x75,0x70,0x70, /* TP ..server supp */ \
	0x6f,0x72,0x74,0x73,0x20,0x42,0x61,0x73,0x69,0x63,0x20,0x48,0x54,0x54,0x50,0x20, /* orts Basic HTTP  */ \
	0x41,0x75,0x74,0x68,0x65,0x6e,0x74,0x69,0x63,0x61,0x74,0x69,0x6f,0x6e,0x20,0x74, /* Authentication t */ \
	0x6f,0x20,0x70,0x72,0x6f,0x76,0x69,0x64,0x65,0x20,0x74,0x68,0x69,0x73,0x20,0x66, /* o provide this f */ \
	0x75,0x6e,0x63,0x74,0x69,0x6f,0x6e,0x61,0x6c,0x69,0x74,0x79,0x2e,0x3c,0x2f,0x70, /* unctionality.</p */ \
	0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x70,0x3e,0x54,0x77,0x6f,0x20,0x66,0x75,0x6e,0x63, /* >....<p>Two func */ \
	0x74,0x69,0x6f,0x6e,0x73,0x20,0x61,0x72,0x65,0x20,0x69,0x6e,0x76,0x6f,0x6c,0x76, /* tions are involv */ \
	0x65,0x64,0x20,0x77,0x69,0x74,0x68,0x20,0x61,0x75,0x74,0x68,0x65,0x6e,0x74,0x69, /* ed with authenti */ \
	0x63,0x61,0x74,0x69,0x6f,0x6e,0x2c,0x20,0x62,0x6f,0x74,0x68,0x20,0x6f,0x66,0x20, /* cation, both of  */ \
	0x77,0x68,0x69,0x63,0x68,0x20,0x73,0x74,0x6f,0x72,0x65,0x20,0x61,0x0d,0x0a,0x72, /* which store a..r */ \
	0x65,0x74,0x75,0x72,0x6e,0x20,0x76,0x61,0x6c,0x75,0x65,0x20,0x69,0x6e,0x20,0x3c, /* eturn value in < */ \
	0x63,0x6f,0x64,0x65,0x3e,0x63,0x75,0x72,0x48,0x54,0x54,0x50,0x2e,0x69,0x73,0x41, /* code>curHTTP.isA */ \
	0x75,0x74,0x68,0x6f,0x72,0x69,0x7a,0x65,0x64,0x3c,0x2f,0x63,0x6f,0x64,0x65,0x3e, /* uthorized</code> */ \
	0x2e,0x20,0x20,0x54,0x68,0x65,0x20,0x4d,0x53,0x42,0x20,0x6f,0x66,0x20,0x74,0x68, /* .  The MSB of th */ \
	0x69,0x73,0x20,0x76,0x61,0x6c,0x75,0x65,0x0d,0x0a,0x69,0x6e,0x64,0x69,0x63,0x61, /* is value..indica */ \
	0x74,0x65,0x73,0x20,0x77,0x68,0x65,0x74,0x68,0x65,0x72,0x20,0x6f,0x72,0x20,0x6e, /* tes whether or n */ \
	0x6f,0x74,0x20,0x61,0x63,0x63,0x65,0x73,0x73,0x20,0x69,0x73,0x20,0x61,0x6c,0x6c, /* ot access is all */ \
	0x6f,0x77,0x65,0x64,0x2e,0x20,0x20,0x54,0x68,0x65,0x20,0x66,0x69,0x72,0x73,0x74, /* owed.  The first */ \
	0x20,0x63,0x61,0x6c,0x6c,0x62,0x61,0x63,0x6b,0x2c,0x20,0x0d,0x0a,0x3c,0x63,0x6f, /*  callback, ..<co */ \
	0x64,0x65,0x3e,0x48,0x54,0x54,0x50,0x4e,0x65,0x65,0x64,0x73,0x41,0x75,0x74,0x68, /* de>HTTPNeedsAuth */ \
	0x3c,0x2f,0x63,0x6f,0x64,0x65,0x3e,0x2c,0x20,0x64,0x65,0x74,0x65,0x72,0x6d,0x69, /* </code>, determi */ \
	0x6e,0x65,0x73,0x20,0x69,0x66,0x20,0x74,0x68,0x65,0x20,0x72,0x65,0x71,0x75,0x65, /* nes if the reque */ \
	0x73,0x74,0x65,0x64,0x20,0x70,0x61,0x67,0x65,0x20,0x72,0x65,0x71,0x75,0x69,0x72, /* sted page requir */ \
	0x65,0x73,0x0d,0x0a,0x76,0x61,0x6c,0x69,0x64,0x20,0x63,0x72,0x65,0x64,0x65,0x6e, /* es..valid creden */ \
	0x74,0x69,0x61,0x6c,0x73,0x20,0x74,0x6f,0x20,0x70,0x72,0x6f,0x63,0x65,0x65,0x64, /* tials to proceed */ \
	0x2e,0x20,0x20,0x52,0x65,0x74,0x75,0x72,0x6e,0x20,0x61,0x20,0x76,0x61,0x6c,0x75, /* .  Return a valu */ \
	0x65,0x20,0x6f,0x66,0x20,0x3c,0x63,0x6f,0x64,0x65,0x3e,0x30,0x78,0x38,0x30,0x3c, /* e of <code>0x80< */ \
	0x2f,0x63,0x6f,0x64,0x65,0x3e,0x20,0x6f,0x72,0x20,0x67,0x72,0x65,0x61,0x74,0x65, /* /code> or greate */ \
	0x72,0x20,0x0d,0x0a,0x74,0x6f,0x20,0x61,0x6c,0x6c,0x6f,0x77,0x20,0x61,0x63,0x63, /* r ..to allow acc */ \
	0x65,0x73,0x73,0x20,0x75,0x6e,0x63,0x6f,0x6e,0x64,0x69,0x74,0x69,0x6f,0x6e,0x61, /* ess unconditiona */ \
	0x6c,0x6c,0x79,0x2e,0x20,0x20,0x52,0x65,0x74,0x75,0x72,0x6e,0x20,0x3c,0x63,0x6f, /* lly.  Return <co */ \
	0x64,0x65,0x3e,0x30,0x78,0x37,0x39,0x3c,0x2f,0x63,0x6f,0x64,0x65,0x3e,0x20,0x6f, /* de>0x79</code> o */ \
	0x72,0x20,0x6c,0x6f,0x77,0x65,0x72,0x20,0x74,0x6f,0x20,0x72,0x65,0x71,0x75,0x69, /* r lower to requi */ \
	0x72,0x65,0x20,0x0d,0x0a,0x61,0x75,0x74,0x68,0x6f,0x72,0x69,0x7a,0x61,0x74,0x69, /* re ..authorizati */ \
	0x6f,0x6e,0x2e,0x3c,0x2f,0x70,0x3e,0x0d,0x0a,0x0d,0x0a,0x54,0x68,0x65,0x20,0x73, /* on.</p>....The s */ \
	0x65,0x63,0x6f,0x6e,0x64,0x2c,0x20,0x3c,0x63,0x6f,0x64,0x65,0x3e,0x48,0x54,0x54, /* econd, <code>HTT */ \
	0x50,0x56,0x65,0x72,0x69,0x66,0x79,0x41,0x75,0x74,0x68,0x3c,0x2f,0x63,0x6f,0x64, /* PVerifyAuth</cod */ \
	0x65,0x3e,0x20,0x64,0x65,0x74,0x65,0x72,0x6d,0x69,0x6e,0x65,0x73,0x20,0x69,0x66, /* e> determines if */ \
	0x20,0x74,0x68,0x65,0x20,0x73,0x75,0x70,0x70,0x6c,0x69,0x65,0x64,0x20,0x63,0x72, /*  the supplied cr */ \
	0x65,0x64,0x65,0x6e,0x74,0x69,0x61,0x6c,0x73,0x20,0x0d,0x0a,0x61,0x72,0x65,0x20, /* edentials ..are  */ \
	0x61,0x63,0x63,0x65,0x70,0x74,0x61,0x62,0x6c,0x65,0x20,0x66,0x6f,0x72,0x20,0x74, /* acceptable for t */ \
	0x68,0x65,0x20,0x72,0x65,0x71,0x75,0x65,0x73,0x74,0x65,0x64,0x20,0x70,0x61,0x67, /* he requested pag */ \
	0x65,0x2e,0x20,0x20,0x59,0x6f,0x75,0x72,0x20,0x61,0x70,0x70,0x6c,0x69,0x63,0x61, /* e.  Your applica */ \
	0x74,0x69,0x6f,0x6e,0x20,0x73,0x68,0x6f,0x75,0x6c,0x64,0x20,0x72,0x65,0x74,0x75, /* tion should retu */ \
	0x72,0x6e,0x20,0x61,0x20,0x76,0x61,0x6c,0x75,0x65,0x20,0x0d,0x0a,0x67,0x72,0x65, /* rn a value ..gre */ \
	0x61,0x74,0x65,0x72,0x20,0x74,0x68,0x61,0x6e,0x20,0x3c,0x63,0x6f,0x64,0x65,0x3e, /* ater than <code> */ \
	0x30,0x78,0x38,0x30,0x3c,0x2f,0x63,0x6f,0x64,0x65,0x3e,0x20,0x74,0x6f,0x20,0x70  /* 0x80</code> to p */
#define DATACHUNK000002 \
	0x65,0x72,0x6d,0x69,0x74,0x20,0x61,0x63,0x63,0x65,0x73,0x73,0x2c,0x20,0x6f,0x72, /* ermit access, or */ \
	0x20,0x61,0x20,0x76,0x61,0x6c,0x75,0x65,0x20,0x6c,0x65,0x73,0x73,0x20,0x74,0x68, /*  a value less th */ \
	0x61,0x6e,0x20,0x0d,0x0a,0x3c,0x63,0x6f,0x64,0x65,0x3e,0x30,0x78,0x37,0x39,0x3c, /* an ..<code>0x79< */ \
	0x2f,0x63,0x6f,0x64,0x65,0x3e,0x20,0x74,0x6f,0x20,0x72,0x65,0x6a,0x65,0x63,0x74, /* /code> to reject */ \
	0x20,0x74,0x68,0x65,0x20,0x70,0x61,0x73,0x73,0x77,0x6f,0x72,0x64,0x20,0x73,0x75, /*  the password su */ \
	0x70,0x70,0x6c,0x69,0x65,0x64,0x2e,0x3c,0x2f,0x70,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c, /* pplied.</p>....< */ \
	0x70,0x3e,0x41,0x73,0x20,0x61,0x6e,0x20,0x65,0x78,0x61,0x6d,0x70,0x6c,0x65,0x2c, /* p>As an example, */ \
	0x20,0x61,0x63,0x63,0x65,0x73,0x73,0x20,0x74,0x68,0x69,0x73,0x20,0x72,0x65,0x73, /*  access this res */ \
	0x74,0x72,0x69,0x63,0x74,0x65,0x64,0x20,0x70,0x61,0x67,0x65,0x3a,0x3c,0x2f,0x70, /* tricted page:</p */ \
	0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d, /* >....<div class= */ \
	0x22,0x65,0x78,0x61,0x6d,0x70,0x6c,0x65,0x62,0x6f,0x78,0x22,0x3e,0x0d,0x0a,0x3c, /* "examplebox">..< */ \
	0x62,0x3e,0x55,0x73,0x65,0x72,0x20,0x4e,0x61,0x6d,0x65,0x3a,0x3c,0x2f,0x62,0x3e, /* b>User Name:</b> */ \
	0x20,0x61,0x64,0x6d,0x69,0x6e,0x20,0x26,0x6e,0x62,0x73,0x70,0x3b,0x20,0x26,0x6e, /*  admin &nbsp; &n */ \
	0x62,0x73,0x70,0x3b,0x20,0x26,0x6e,0x62,0x73,0x70,0x3b,0x20,0x3c,0x62,0x3e,0x50, /* bsp; &nbsp; <b>P */ \
	0x61,0x73,0x73,0x77,0x6f,0x72,0x64,0x3a,0x3c,0x2f,0x62,0x3e,0x20,0x6d,0x69,0x63, /* assword:</b> mic */ \
	0x72,0x6f,0x63,0x68,0x69,0x70,0x3c,0x62,0x72,0x20,0x2f,0x3e,0x0d,0x0a,0x3c,0x61, /* rochip<br />..<a */ \
	0x20,0x68,0x72,0x65,0x66,0x3d,0x22,0x2f,0x70,0x72,0x6f,0x74,0x65,0x63,0x74,0x22, /*  href="/protect" */ \
	0x3e,0x41,0x63,0x63,0x65,0x73,0x73,0x20,0x52,0x65,0x73,0x74,0x72,0x69,0x63,0x74, /* >Access Restrict */ \
	0x65,0x64,0x20,0x50,0x61,0x67,0x65,0x3c,0x2f,0x61,0x3e,0x0d,0x0a,0x3c,0x2f,0x64, /* ed Page</a>..</d */ \
	0x69,0x76,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x0d, /* iv>....</div>... */ \
	0x0a,0x3c,0x73,0x63,0x72,0x69,0x70,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74, /* .<script type="t */ \
	0x65,0x78,0x74,0x2f,0x6a,0x61,0x76,0x61,0x73,0x63,0x72,0x69,0x70,0x74,0x22,0x3e, /* ext/javascript"> */ \
	0x0d,0x0a,0x3c,0x21,0x2d,0x2d,0x0d,0x0a,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74, /* ..<!--..document */ \
	0x2e,0x67,0x65,0x74,0x45,0x6c,0x65,0x6d,0x65,0x6e,0x74,0x42,0x79,0x49,0x64,0x28, /* .getElementById( */ \
	0x27,0x68,0x65,0x6c,0x6c,0x6f,0x27,0x29,0x2e,0x69,0x6e,0x6e,0x65,0x72,0x48,0x54, /* 'hello').innerHT */ \
	0x4d,0x4c,0x20,0x3d,0x20,0x22,0x7e,0x68,0x65,0x6c,0x6c,0x6f,0x6d,0x73,0x67,0x7e, /* ML = "~hellomsg~ */ \
	0x22,0x3b,0x0d,0x0a,0x2d,0x2d,0x3e,0x0d,0x0a,0x3c,0x2f,0x73,0x63,0x72,0x69,0x70, /* ";..-->..</scrip */ \
	0x74,0x3e,0x0d,0x0a,0x7e,0x69,0x6e,0x63,0x3a,0x66,0x6f,0x6f,0x74,0x65,0x72,0x2e, /* t>..~inc:footer. */ \
	0x69,0x6e,0x63,0x7e,0x00,0x00,0x00,0x00,0x33,0x00,0x00,0x00,0x12,0x05,0x00,0x00, /* inc~....3....... */ \
	0x01,0x00,0x00,0x00,0x30,0x05,0x00,0x00,0x02,0x00,0x00,0x00,0x7e,0x69,0x6e,0x63, /* ....0.......~inc */ \
	0x3a,0x68,0x65,0x61,0x64,0x65,0x72,0x2e,0x69,0x6e,0x63,0x7e,0x0d,0x0a,0x3c,0x64, /* :header.inc~..<d */ \
	0x69,0x76,0x20,0x69,0x64,0x3d,0x22,0x63,0x6f,0x6e,0x74,0x65,0x6e,0x74,0x22,0x3e, /* iv id="content"> */ \
	0x0d,0x0a,0x0d,0x0a,0x3c,0x68,0x31,0x3e,0x43,0x6f,0x6f,0x6b,0x69,0x65,0x73,0x3c, /* ....<h1>Cookies< */ \
	0x2f,0x68,0x31,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x70,0x3e,0x43,0x6f,0x6f,0x6b,0x69, /* /h1>....<p>Cooki */ \
	0x65,0x73,0x20,0x61,0x72,0x65,0x20,0x73,0x6d,0x61,0x6c,0x6c,0x20,0x74,0x65,0x78, /* es are small tex */ \
	0x74,0x20,0x73,0x74,0x72,0x69,0x6e,0x67,0x73,0x20,0x74,0x68,0x61,0x74,0x20,0x61, /* t strings that a */ \
	0x72,0x65,0x20,0x73,0x74,0x6f,0x72,0x65,0x64,0x20,0x69,0x6e,0x20,0x74,0x68,0x65, /* re stored in the */ \
	0x20,0x62,0x72,0x6f,0x77,0x73,0x65,0x72,0x2e,0x20,0x20,0x54,0x68,0x65,0x73,0x65, /*  browser.  These */ \
	0x20,0x73,0x74,0x72,0x69,0x6e,0x67,0x73,0x20,0x0d,0x0a,0x61,0x72,0x65,0x20,0x73, /*  strings ..are s */ \
	0x65,0x74,0x20,0x62,0x79,0x20,0x74,0x68,0x65,0x20,0x73,0x65,0x72,0x76,0x65,0x72, /* et by the server */ \
	0x2c,0x20,0x61,0x6e,0x64,0x20,0x72,0x65,0x74,0x75,0x72,0x6e,0x65,0x64,0x20,0x61, /* , and returned a */ \
	0x73,0x20,0x70,0x61,0x72,0x61,0x6d,0x65,0x74,0x65,0x72,0x73,0x20,0x66,0x6f,0x72, /* s parameters for */ \
	0x20,0x61,0x6c,0x6c,0x20,0x66,0x75,0x74,0x75,0x72,0x65,0x20,0x72,0x65,0x71,0x75, /*  all future requ */ \
	0x65,0x73,0x74,0x73,0x20,0x75,0x6e,0x74,0x69,0x6c,0x20,0x0d,0x0a,0x74,0x68,0x65, /* ests until ..the */ \
	0x20,0x73,0x65,0x73,0x73,0x69,0x6f,0x6e,0x20,0x65,0x6e,0x64,0x73,0x2e,0x20,0x20, /*  session ends.   */ \
	0x54,0x68,0x65,0x79,0x20,0x63,0x61,0x6e,0x20,0x62,0x65,0x20,0x75,0x73,0x65,0x64, /* They can be used */ \
	0x20,0x74,0x6f,0x20,0x73,0x74,0x6f,0x72,0x65,0x20,0x73,0x65,0x73,0x73,0x69,0x6f, /*  to store sessio */ \
	0x6e,0x20,0x73,0x74,0x61,0x74,0x65,0x20,0x69,0x6e,0x66,0x6f,0x72,0x6d,0x61,0x74, /* n state informat */ \
	0x69,0x6f,0x6e,0x2c,0x20,0x61,0x6e,0x64,0x20,0x61,0x72,0x65,0x20,0x0d,0x0a,0x76, /* ion, and are ..v */ \
	0x61,0x6c,0x69,0x64,0x20,0x75,0x6e,0x74,0x69,0x6c,0x20,0x74,0x68,0x65,0x20,0x62, /* alid until the b */ \
	0x72,0x6f,0x77,0x73,0x65,0x72,0x20,0x69,0x73,0x20,0x63,0x6c,0x6f,0x73,0x65,0x64, /* rowser is closed */ \
	0x2e,0x3c,0x2f,0x70,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x20,0x63,0x6c, /* .</p>....<div cl */ \
	0x61,0x73,0x73,0x3d,0x22,0x65,0x78,0x61,0x6d,0x70,0x6c,0x65,0x62,0x6f,0x78,0x22, /* ass="examplebox" */ \
	0x3e,0x0d,0x0a,0x3c,0x74,0x61,0x62,0x6c,0x65,0x20,0x61,0x6c,0x69,0x67,0x6e,0x3d, /* >..<table align= */ \
	0x22,0x63,0x65,0x6e,0x74,0x65,0x72,0x22,0x3e,0x0d,0x0a,0x3c,0x74,0x72,0x3e,0x3c, /* "center">..<tr>< */ \
	0x74,0x64,0x3e,0x3c,0x62,0x3e,0x4e,0x61,0x6d,0x65,0x3a,0x3c,0x2f,0x62,0x3e,0x3c, /* td><b>Name:</b>< */ \
	0x2f,0x74,0x64,0x3e,0x3c,0x74,0x64,0x3e,0x7e,0x63,0x6f,0x6f,0x6b,0x69,0x65,0x6e, /* /td><td>~cookien */ \
	0x61,0x6d,0x65,0x7e,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x2f,0x74,0x72,0x3e,0x0d,0x0a, /* ame~</td></tr>.. */ \
	0x3c,0x74,0x72,0x3e,0x3c,0x74,0x64,0x3e,0x3c,0x62,0x3e,0x46,0x61,0x76,0x6f,0x72, /* <tr><td><b>Favor */ \
	0x69,0x74,0x65,0x3a,0x3c,0x2f,0x62,0x3e,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x74,0x64, /* ite:</b></td><td */ \
	0x3e,0x6e,0x6f,0x74,0x20,0x69,0x6d,0x70,0x6c,0x65,0x6d,0x65,0x6e,0x74,0x65,0x64, /* >not implemented */ \
	0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x2f,0x74,0x72,0x3e,0x0d,0x0a,0x3c,0x2f,0x74,0x61, /* </td></tr>..</ta */ \
	0x62,0x6c,0x65,0x3e,0x0d,0x0a,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x0d,0x0a, /* ble>..</div>.... */ \
	0x3c,0x70,0x3e,0x54,0x68,0x65,0x72,0x65,0x20,0x61,0x72,0x65,0x20,0x6e,0x75,0x6d  /* <p>There are num */
#define DATACHUNK000003 \
	0x65,0x72,0x6f,0x75,0x73,0x20,0x75,0x73,0x65,0x73,0x20,0x66,0x6f,0x72,0x20,0x63, /* erous uses for c */ \
	0x6f,0x6f,0x6b,0x69,0x65,0x73,0x2e,0x20,0x20,0x49,0x6e,0x20,0x74,0x68,0x69,0x73, /* ookies.  In this */ \
	0x20,0x65,0x78,0x61,0x6d,0x70,0x6c,0x65,0x2c,0x20,0x74,0x68,0x65,0x20,0x75,0x73, /*  example, the us */ \
	0x65,0x72,0x27,0x73,0x20,0x6e,0x61,0x6d,0x65,0x20,0x69,0x73,0x20,0x0d,0x0a,0x73, /* er's name is ..s */ \
	0x74,0x6f,0x72,0x65,0x64,0x20,0x61,0x73,0x20,0x61,0x20,0x63,0x6f,0x6f,0x6b,0x69, /* tored as a cooki */ \
	0x65,0x2e,0x20,0x20,0x41,0x6c,0x6c,0x20,0x66,0x75,0x74,0x75,0x72,0x65,0x20,0x70, /* e.  All future p */ \
	0x61,0x67,0x65,0x20,0x6c,0x6f,0x61,0x64,0x73,0x20,0x77,0x69,0x6c,0x6c,0x20,0x73, /* age loads will s */ \
	0x68,0x6f,0x77,0x20,0x74,0x68,0x69,0x73,0x20,0x6e,0x61,0x6d,0x65,0x20,0x69,0x6e, /* how this name in */ \
	0x20,0x74,0x68,0x65,0x20,0x74,0x6f,0x70,0x20,0x6c,0x65,0x66,0x74,0x20,0x0d,0x0a, /*  the top left .. */ \
	0x63,0x6f,0x72,0x6e,0x65,0x72,0x2c,0x20,0x61,0x73,0x20,0x77,0x65,0x6c,0x6c,0x20, /* corner, as well  */ \
	0x61,0x73,0x20,0x69,0x6e,0x20,0x74,0x68,0x65,0x20,0x62,0x6f,0x78,0x20,0x61,0x62, /* as in the box ab */ \
	0x6f,0x76,0x65,0x2e,0x3c,0x2f,0x70,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x66,0x6f,0x72, /* ove.</p>....<for */ \
	0x6d,0x20,0x61,0x63,0x74,0x69,0x6f,0x6e,0x3d,0x22,0x63,0x6f,0x6f,0x6b,0x69,0x65, /* m action="cookie */ \
	0x73,0x2e,0x68,0x74,0x6d,0x22,0x20,0x6d,0x65,0x74,0x68,0x6f,0x64,0x3d,0x22,0x67, /* s.htm" method="g */ \
	0x65,0x74,0x22,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x20,0x63,0x6c,0x61,0x73,0x73, /* et">..<div class */ \
	0x3d,0x22,0x65,0x78,0x61,0x6d,0x70,0x6c,0x65,0x62,0x6f,0x78,0x22,0x3e,0x0d,0x0a, /* ="examplebox">.. */ \
	0x3c,0x74,0x61,0x62,0x6c,0x65,0x20,0x61,0x6c,0x69,0x67,0x6e,0x3d,0x22,0x63,0x65, /* <table align="ce */ \
	0x6e,0x74,0x65,0x72,0x22,0x3e,0x0d,0x0a,0x3c,0x74,0x72,0x3e,0x3c,0x74,0x64,0x3e, /* nter">..<tr><td> */ \
	0x3c,0x62,0x3e,0x46,0x69,0x72,0x73,0x74,0x20,0x4e,0x61,0x6d,0x65,0x3a,0x3c,0x2f, /* <b>First Name:</ */ \
	0x62,0x3e,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x74,0x64,0x3e,0x3c,0x69,0x6e,0x70,0x75, /* b></td><td><inpu */ \
	0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x22,0x20,0x6e,0x61, /* t type="text" na */ \
	0x6d,0x65,0x3d,0x22,0x6e,0x61,0x6d,0x65,0x22,0x20,0x73,0x69,0x7a,0x65,0x3d,0x22, /* me="name" size=" */ \
	0x32,0x30,0x22,0x20,0x6d,0x61,0x78,0x6c,0x65,0x6e,0x67,0x74,0x68,0x3d,0x22,0x31, /* 20" maxlength="1 */ \
	0x36,0x22,0x20,0x2f,0x3e,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x2f,0x74,0x72,0x3e,0x0d, /* 6" /></td></tr>. */ \
	0x0a,0x3c,0x74,0x72,0x3e,0x3c,0x74,0x64,0x3e,0x3c,0x62,0x3e,0x46,0x61,0x76,0x6f, /* .<tr><td><b>Favo */ \
	0x72,0x69,0x74,0x65,0x3a,0x3c,0x2f,0x62,0x3e,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x74, /* rite:</b></td><t */ \
	0x64,0x3e,0x0d,0x0a,0x3c,0x73,0x65,0x6c,0x65,0x63,0x74,0x20,0x6e,0x61,0x6d,0x65, /* d>..<select name */ \
	0x3d,0x22,0x66,0x61,0x76,0x22,0x3e,0x0d,0x0a,0x3c,0x6f,0x70,0x74,0x69,0x6f,0x6e, /* ="fav">..<option */ \
	0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x50,0x49,0x43,0x31,0x38,0x22,0x3e,0x50, /*  value="PIC18">P */ \
	0x49,0x43,0x31,0x38,0x3c,0x2f,0x6f,0x70,0x74,0x69,0x6f,0x6e,0x3e,0x0d,0x0a,0x3c, /* IC18</option>..< */ \
	0x6f,0x70,0x74,0x69,0x6f,0x6e,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x50,0x49, /* option value="PI */ \
	0x43,0x32,0x34,0x22,0x3e,0x50,0x49,0x43,0x32,0x34,0x3c,0x2f,0x6f,0x70,0x74,0x69, /* C24">PIC24</opti */ \
	0x6f,0x6e,0x3e,0x0d,0x0a,0x3c,0x6f,0x70,0x74,0x69,0x6f,0x6e,0x20,0x76,0x61,0x6c, /* on>..<option val */ \
	0x75,0x65,0x3d,0x22,0x64,0x73,0x50,0x49,0x43,0x22,0x3e,0x64,0x73,0x50,0x49,0x43, /* ue="dsPIC">dsPIC */ \
	0x3c,0x2f,0x6f,0x70,0x74,0x69,0x6f,0x6e,0x3e,0x0d,0x0a,0x3c,0x6f,0x70,0x74,0x69, /* </option>..<opti */ \
	0x6f,0x6e,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x50,0x49,0x43,0x33,0x32,0x22, /* on value="PIC32" */ \
	0x3e,0x50,0x49,0x43,0x33,0x32,0x3c,0x2f,0x6f,0x70,0x74,0x69,0x6f,0x6e,0x3e,0x0d, /* >PIC32</option>. */ \
	0x0a,0x3c,0x2f,0x73,0x65,0x6c,0x65,0x63,0x74,0x3e,0x0d,0x0a,0x3c,0x2f,0x74,0x64, /* .</select>..</td */ \
	0x3e,0x3c,0x2f,0x74,0x72,0x3e,0x0d,0x0a,0x3c,0x74,0x72,0x3e,0x3c,0x74,0x64,0x3e, /* ></tr>..<tr><td> */ \
	0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x74,0x64,0x3e,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20, /* </td><td><input  */ \
	0x74,0x79,0x70,0x65,0x3d,0x22,0x73,0x75,0x62,0x6d,0x69,0x74,0x22,0x20,0x76,0x61, /* type="submit" va */ \
	0x6c,0x75,0x65,0x3d,0x22,0x53,0x65,0x74,0x20,0x43,0x6f,0x6f,0x6b,0x69,0x65,0x73, /* lue="Set Cookies */ \
	0x22,0x20,0x2f,0x3e,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x2f,0x74,0x72,0x3e,0x0d,0x0a, /* " /></td></tr>.. */ \
	0x3c,0x2f,0x74,0x61,0x62,0x6c,0x65,0x3e,0x0d,0x0a,0x3c,0x2f,0x64,0x69,0x76,0x3e, /* </table>..</div> */ \
	0x0d,0x0a,0x3c,0x2f,0x66,0x6f,0x72,0x6d,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x70,0x3e, /* ..</form>....<p> */ \
	0x43,0x6f,0x6f,0x6b,0x69,0x65,0x73,0x20,0x61,0x72,0x65,0x20,0x73,0x65,0x74,0x20, /* Cookies are set  */ \
	0x62,0x79,0x20,0x73,0x74,0x6f,0x72,0x69,0x6e,0x67,0x20,0x6e,0x75,0x6c,0x6c,0x2d, /* by storing null- */ \
	0x74,0x65,0x72,0x6d,0x69,0x6e,0x61,0x74,0x65,0x64,0x20,0x6e,0x61,0x6d,0x65,0x2f, /* terminated name/ */ \
	0x76,0x61,0x6c,0x75,0x65,0x20,0x70,0x61,0x69,0x72,0x73,0x20,0x69,0x6e,0x20,0x3c, /* value pairs in < */ \
	0x63,0x6f,0x64,0x65,0x3e,0x63,0x75,0x72,0x48,0x54,0x54,0x50,0x2e,0x64,0x61,0x74, /* code>curHTTP.dat */ \
	0x61,0x3c,0x2f,0x63,0x6f,0x64,0x65,0x3e,0x20,0x0d,0x0a,0x61,0x6e,0x64,0x20,0x69, /* a</code> ..and i */ \
	0x6e,0x64,0x69,0x63,0x61,0x74,0x69,0x6e,0x67,0x20,0x68,0x6f,0x77,0x20,0x6d,0x61, /* ndicating how ma */ \
	0x6e,0x79,0x20,0x63,0x6f,0x6f,0x6b,0x69,0x65,0x73,0x20,0x61,0x72,0x65,0x20,0x74, /* ny cookies are t */ \
	0x6f,0x20,0x62,0x65,0x20,0x73,0x65,0x74,0x20,0x69,0x6e,0x20,0x3c,0x63,0x6f,0x64, /* o be set in <cod */ \
	0x65,0x3e,0x63,0x75,0x72,0x48,0x54,0x54,0x50,0x2e,0x68,0x61,0x73,0x41,0x72,0x67, /* e>curHTTP.hasArg */ \
	0x73,0x3c,0x2f,0x63,0x6f,0x64,0x65,0x3e,0x2e,0x20,0x20,0x54,0x68,0x65,0x79,0x20, /* s</code>.  They  */ \
	0x0d,0x0a,0x63,0x61,0x6e,0x20,0x62,0x65,0x20,0x73,0x65,0x74,0x20,0x69,0x6e,0x20, /* ..can be set in  */ \
	0x65,0x69,0x74,0x68,0x65,0x72,0x20,0x3c,0x63,0x6f,0x64,0x65,0x3e,0x48,0x54,0x54, /* either <code>HTT */ \
	0x50,0x45,0x78,0x65,0x63,0x75,0x74,0x65,0x47,0x65,0x74,0x3c,0x2f,0x63,0x6f,0x64, /* PExecuteGet</cod */ \
	0x65,0x3e,0x20,0x6f,0x72,0x20,0x3c,0x63,0x6f,0x64,0x65,0x3e,0x48,0x54,0x54,0x50, /* e> or <code>HTTP */ \
	0x45,0x78,0x65,0x63,0x75,0x74,0x65,0x50,0x6f,0x73,0x74,0x3c,0x2f,0x63,0x6f,0x64, /* ExecutePost</cod */ \
	0x65,0x3e,0x2e,0x3c,0x2f,0x70,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x70,0x3e,0x43,0x6f, /* e>.</p>....<p>Co */ \
	0x6f,0x6b,0x69,0x65,0x73,0x20,0x61,0x72,0x65,0x20,0x72,0x65,0x74,0x72,0x69,0x65, /* okies are retrie */ \
	0x76,0x65,0x64,0x20,0x69,0x6e,0x20,0x74,0x68,0x65,0x20,0x73,0x61,0x6d,0x65,0x20  /* ved in the same  */
#define DATACHUNK000004 \
	0x6d,0x61,0x6e,0x6e,0x65,0x72,0x20,0x61,0x73,0x20,0x47,0x45,0x54,0x20,0x66,0x6f, /* manner as GET fo */ \
	0x72,0x6d,0x20,0x61,0x72,0x67,0x75,0x6d,0x65,0x6e,0x74,0x73,0x2e,0x20,0x20,0x54, /* rm arguments.  T */ \
	0x68,0x65,0x79,0x20,0x61,0x72,0x65,0x20,0x73,0x74,0x6f,0x72,0x65,0x64,0x20,0x0d, /* hey are stored . */ \
	0x0a,0x69,0x6e,0x20,0x3c,0x63,0x6f,0x64,0x65,0x3e,0x63,0x75,0x72,0x48,0x54,0x54, /* .in <code>curHTT */ \
	0x50,0x2e,0x64,0x61,0x74,0x61,0x3c,0x2f,0x63,0x6f,0x64,0x65,0x3e,0x20,0x61,0x6e, /* P.data</code> an */ \
	0x64,0x20,0x63,0x61,0x6e,0x20,0x62,0x65,0x20,0x6c,0x6f,0x63,0x61,0x74,0x65,0x64, /* d can be located */ \
	0x20,0x75,0x73,0x69,0x6e,0x67,0x20,0x74,0x68,0x65,0x20,0x3c,0x63,0x6f,0x64,0x65, /*  using the <code */ \
	0x3e,0x48,0x54,0x54,0x50,0x47,0x65,0x74,0x41,0x72,0x67,0x3c,0x2f,0x63,0x6f,0x64, /* >HTTPGetArg</cod */ \
	0x65,0x3e,0x20,0x0d,0x0a,0x66,0x75,0x6e,0x63,0x74,0x69,0x6f,0x6e,0x73,0x2e,0x20, /* e> ..functions.  */ \
	0x20,0x53,0x69,0x6e,0x63,0x65,0x20,0x74,0x68,0x65,0x79,0x20,0x61,0x72,0x65,0x20, /*  Since they are  */ \
	0x73,0x74,0x6f,0x72,0x65,0x64,0x20,0x69,0x6e,0x20,0x74,0x68,0x65,0x20,0x73,0x61, /* stored in the sa */ \
	0x6d,0x65,0x20,0x61,0x72,0x72,0x61,0x79,0x20,0x61,0x73,0x20,0x47,0x45,0x54,0x20, /* me array as GET  */ \
	0x61,0x72,0x67,0x75,0x6d,0x65,0x6e,0x74,0x73,0x2c,0x20,0x74,0x68,0x65,0x20,0x74, /* arguments, the t */ \
	0x6f,0x74,0x61,0x6c,0x20,0x0d,0x0a,0x6c,0x65,0x6e,0x67,0x74,0x68,0x20,0x6f,0x66, /* otal ..length of */ \
	0x20,0x63,0x6f,0x6f,0x6b,0x69,0x65,0x73,0x20,0x61,0x6e,0x64,0x20,0x76,0x61,0x72, /*  cookies and var */ \
	0x69,0x61,0x62,0x6c,0x65,0x20,0x61,0x72,0x67,0x75,0x6d,0x65,0x6e,0x74,0x73,0x20, /* iable arguments  */ \
	0x63,0x61,0x6e,0x6e,0x6f,0x74,0x20,0x65,0x78,0x63,0x65,0x65,0x64,0x20,0x74,0x68, /* cannot exceed th */ \
	0x65,0x20,0x38,0x30,0x20,0x62,0x79,0x74,0x65,0x20,0x62,0x75,0x66,0x66,0x65,0x72, /* e 80 byte buffer */ \
	0x20,0x6c,0x69,0x6d,0x69,0x74,0x2e,0x3c,0x2f,0x70,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c, /*  limit.</p>....< */ \
	0x70,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x65,0x78,0x65,0x72,0x63,0x69,0x73, /* p class="exercis */ \
	0x65,0x22,0x3e,0x3c,0x62,0x3e,0x45,0x78,0x65,0x72,0x63,0x69,0x73,0x65,0x3a,0x3c, /* e"><b>Exercise:< */ \
	0x2f,0x62,0x3e,0x20,0x53,0x65,0x74,0x20,0x61,0x20,0x73,0x65,0x63,0x6f,0x6e,0x64, /* /b> Set a second */ \
	0x20,0x63,0x6f,0x6f,0x6b,0x69,0x65,0x20,0x6e,0x61,0x6d,0x65,0x64,0x20,0x3c,0x63, /*  cookie named <c */ \
	0x6f,0x64,0x65,0x3e,0x66,0x61,0x76,0x3c,0x2f,0x63,0x6f,0x64,0x65,0x3e,0x20,0x77, /* ode>fav</code> w */ \
	0x69,0x74,0x68,0x20,0x74,0x68,0x65,0x20,0x0d,0x0a,0x76,0x61,0x6c,0x75,0x65,0x20, /* ith the ..value  */ \
	0x6f,0x66,0x20,0x74,0x68,0x65,0x20,0x3c,0x63,0x6f,0x64,0x65,0x3e,0x66,0x61,0x76, /* of the <code>fav */ \
	0x6f,0x72,0x69,0x74,0x65,0x3c,0x2f,0x63,0x6f,0x64,0x65,0x3e,0x20,0x66,0x69,0x65, /* orite</code> fie */ \
	0x6c,0x64,0x20,0x61,0x6e,0x64,0x20,0x68,0x61,0x76,0x65,0x20,0x69,0x74,0x20,0x64, /* ld and have it d */ \
	0x69,0x73,0x70,0x6c,0x61,0x79,0x65,0x64,0x20,0x69,0x6e,0x20,0x74,0x68,0x65,0x20, /* isplayed in the  */ \
	0x67,0x72,0x61,0x79,0x20,0x62,0x6f,0x78,0x20,0x61,0x62,0x6f,0x76,0x65,0x2e,0x3c, /* gray box above.< */ \
	0x2f,0x70,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x0d, /* /p>....</div>... */ \
	0x0a,0x3c,0x73,0x63,0x72,0x69,0x70,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74, /* .<script type="t */ \
	0x65,0x78,0x74,0x2f,0x6a,0x61,0x76,0x61,0x73,0x63,0x72,0x69,0x70,0x74,0x22,0x3e, /* ext/javascript"> */ \
	0x0d,0x0a,0x3c,0x21,0x2d,0x2d,0x0d,0x0a,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74, /* ..<!--..document */ \
	0x2e,0x67,0x65,0x74,0x45,0x6c,0x65,0x6d,0x65,0x6e,0x74,0x42,0x79,0x49,0x64,0x28, /* .getElementById( */ \
	0x27,0x68,0x65,0x6c,0x6c,0x6f,0x27,0x29,0x2e,0x69,0x6e,0x6e,0x65,0x72,0x48,0x54, /* 'hello').innerHT */ \
	0x4d,0x4c,0x20,0x3d,0x20,0x22,0x7e,0x68,0x65,0x6c,0x6c,0x6f,0x6d,0x73,0x67,0x7e, /* ML = "~hellomsg~ */ \
	0x22,0x3b,0x0d,0x0a,0x2d,0x2d,0x3e,0x0d,0x0a,0x3c,0x2f,0x73,0x63,0x72,0x69,0x70, /* ";..-->..</scrip */ \
	0x74,0x3e,0x0d,0x0a,0x7e,0x69,0x6e,0x63,0x3a,0x66,0x6f,0x6f,0x74,0x65,0x72,0x2e, /* t>..~inc:footer. */ \
	0x69,0x6e,0x63,0x7e,0x00,0x00,0x00,0x00,0x33,0x00,0x00,0x00,0xac,0x01,0x00,0x00, /* inc~....3....... */ \
	0x03,0x00,0x00,0x00,0x6a,0x08,0x00,0x00,0x01,0x00,0x00,0x00,0x88,0x08,0x00,0x00, /* ....j........... */ \
	0x02,0x00,0x00,0x00,0x7e,0x69,0x6e,0x63,0x3a,0x68,0x65,0x61,0x64,0x65,0x72,0x2e, /* ....~inc:header. */ \
	0x69,0x6e,0x63,0x7e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x20,0x69,0x64,0x3d,0x22,0x63, /* inc~..<div id="c */ \
	0x6f,0x6e,0x74,0x65,0x6e,0x74,0x22,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x68,0x31,0x3e, /* ontent">....<h1> */ \
	0x44,0x79,0x6e,0x61,0x6d,0x69,0x63,0x20,0x56,0x61,0x72,0x69,0x61,0x62,0x6c,0x65, /* Dynamic Variable */ \
	0x73,0x3c,0x2f,0x68,0x31,0x3e,0x0d,0x0a,0x3c,0x70,0x3e,0x4f,0x6e,0x65,0x20,0x6f, /* s</h1>..<p>One o */ \
	0x66,0x20,0x74,0x68,0x65,0x20,0x6d,0x6f,0x73,0x74,0x20,0x62,0x61,0x73,0x69,0x63, /* f the most basic */ \
	0x20,0x6e,0x65,0x65,0x64,0x73,0x20,0x69,0x73,0x20,0x74,0x6f,0x20,0x70,0x72,0x6f, /*  needs is to pro */ \
	0x76,0x69,0x64,0x65,0x20,0x73,0x74,0x61,0x74,0x75,0x73,0x20,0x69,0x6e,0x66,0x6f, /* vide status info */ \
	0x72,0x6d,0x61,0x74,0x69,0x6f,0x6e,0x20,0x62,0x61,0x63,0x6b,0x20,0x74,0x6f,0x20, /* rmation back to  */ \
	0x74,0x68,0x65,0x20,0x75,0x73,0x65,0x72,0x20,0x6f,0x66,0x20,0x0d,0x0a,0x79,0x6f, /* the user of ..yo */ \
	0x75,0x72,0x20,0x77,0x65,0x62,0x20,0x61,0x70,0x70,0x6c,0x69,0x63,0x61,0x74,0x69, /* ur web applicati */ \
	0x6f,0x6e,0x2e,0x20,0x20,0x54,0x68,0x65,0x20,0x48,0x54,0x54,0x50,0x20,0x73,0x65, /* on.  The HTTP se */ \
	0x72,0x76,0x65,0x72,0x20,0x70,0x72,0x6f,0x76,0x69,0x64,0x65,0x73,0x20,0x66,0x6f, /* rver provides fo */ \
	0x72,0x20,0x74,0x68,0x69,0x73,0x20,0x75,0x73,0x69,0x6e,0x67,0x20,0x3c,0x69,0x3e, /* r this using <i> */ \
	0x64,0x79,0x6e,0x61,0x6d,0x69,0x63,0x20,0x0d,0x0a,0x76,0x61,0x72,0x69,0x61,0x62, /* dynamic ..variab */ \
	0x6c,0x65,0x20,0x73,0x75,0x62,0x73,0x74,0x69,0x74,0x75,0x74,0x69,0x6f,0x6e,0x20, /* le substitution  */ \
	0x63,0x61,0x6c,0x6c,0x62,0x61,0x63,0x6b,0x73,0x3c,0x2f,0x69,0x3e,0x2e,0x20,0x20, /* callbacks</i>.   */ \
	0x54,0x68,0x65,0x73,0x65,0x20,0x63,0x6f,0x6d,0x6d,0x61,0x6e,0x64,0x73,0x20,0x69, /* These commands i */ \
	0x6e,0x20,0x79,0x6f,0x75,0x72,0x20,0x48,0x54,0x4d,0x4c,0x20,0x63,0x6f,0x64,0x65, /* n your HTML code */ \
	0x20,0x77,0x69,0x6c,0x6c,0x0d,0x0a,0x61,0x6c,0x65,0x72,0x74,0x20,0x74,0x68,0x65, /*  will..alert the */ \
	0x20,0x73,0x65,0x72,0x76,0x65,0x72,0x20,0x74,0x6f,0x20,0x65,0x78,0x65,0x63,0x75, /*  server to execu */ \
	0x74,0x65,0x20,0x61,0x20,0x63,0x61,0x6c,0x6c,0x62,0x61,0x63,0x6b,0x20,0x66,0x75, /* te a callback fu */ \
	0x6e,0x63,0x74,0x69,0x6f,0x6e,0x20,0x61,0x74,0x20,0x74,0x68,0x61,0x74,0x20,0x70  /* nction at that p */
#define DATACHUNK000005 \
	0x6f,0x69,0x6e,0x74,0x2e,0x3c,0x2f,0x70,0x3e,0x0d,0x0a,0x3c,0x70,0x3e,0x54,0x6f, /* oint.</p>..<p>To */ \
	0x20,0x69,0x6e,0x73,0x65,0x72,0x74,0x20,0x61,0x20,0x64,0x79,0x6e,0x61,0x6d,0x69, /*  insert a dynami */ \
	0x63,0x20,0x76,0x61,0x72,0x69,0x61,0x62,0x6c,0x65,0x2c,0x20,0x70,0x6c,0x61,0x63, /* c variable, plac */ \
	0x65,0x20,0x74,0x68,0x65,0x20,0x6e,0x61,0x6d,0x65,0x20,0x6f,0x66,0x20,0x74,0x68, /* e the name of th */ \
	0x65,0x20,0x76,0x61,0x72,0x69,0x61,0x62,0x6c,0x65,0x20,0x69,0x6e,0x73,0x69,0x64, /* e variable insid */ \
	0x65,0x20,0x6f,0x66,0x20,0x74,0x68,0x65,0x20,0x74,0x69,0x6c,0x64,0x65,0x0d,0x0a, /* e of the tilde.. */ \
	0x28,0x3c,0x63,0x6f,0x64,0x65,0x3e,0x7e,0x7e,0x3c,0x2f,0x63,0x6f,0x64,0x65,0x3e, /* (<code>~~</code> */ \
	0x29,0x20,0x63,0x68,0x61,0x72,0x61,0x63,0x74,0x65,0x72,0x2c,0x20,0x6c,0x69,0x6b, /* ) character, lik */ \
	0x65,0x20,0x74,0x68,0x69,0x73,0x3a,0x20,0x3c,0x63,0x6f,0x64,0x65,0x3e,0x7e,0x7e, /* e this: <code>~~ */ \
	0x6d,0x79,0x56,0x61,0x72,0x69,0x61,0x62,0x6c,0x65,0x7e,0x7e,0x3c,0x2f,0x63,0x6f, /* myVariable~~</co */ \
	0x64,0x65,0x3e,0x2e,0x20,0x20,0x57,0x68,0x65,0x6e,0x20,0x74,0x68,0x61,0x74,0x20, /* de>.  When that  */ \
	0x0d,0x0a,0x73,0x65,0x71,0x75,0x65,0x6e,0x63,0x65,0x20,0x69,0x73,0x20,0x66,0x6f, /* ..sequence is fo */ \
	0x75,0x6e,0x64,0x2c,0x20,0x74,0x68,0x65,0x20,0x73,0x65,0x72,0x76,0x65,0x72,0x20, /* und, the server  */ \
	0x77,0x69,0x6c,0x6c,0x20,0x63,0x61,0x6c,0x6c,0x20,0x74,0x68,0x65,0x20,0x66,0x75, /* will call the fu */ \
	0x6e,0x63,0x74,0x69,0x6f,0x6e,0x20,0x3c,0x63,0x6f,0x64,0x65,0x3e,0x48,0x54,0x54, /* nction <code>HTT */ \
	0x50,0x50,0x72,0x69,0x6e,0x74,0x5f,0x6d,0x79,0x56,0x61,0x72,0x69,0x61,0x62,0x6c, /* PPrint_myVariabl */ \
	0x65,0x28,0x29,0x3c,0x2f,0x63,0x6f,0x64,0x65,0x3e,0x2e,0x3c,0x2f,0x70,0x3e,0x0d, /* e()</code>.</p>. */ \
	0x0a,0x0d,0x0a,0x3c,0x70,0x3e,0x46,0x6f,0x72,0x20,0x65,0x78,0x61,0x6d,0x70,0x6c, /* ...<p>For exampl */ \
	0x65,0x2c,0x20,0x68,0x65,0x72,0x65,0x27,0x73,0x20,0x74,0x68,0x65,0x20,0x62,0x75, /* e, here's the bu */ \
	0x69,0x6c,0x64,0x20,0x64,0x61,0x74,0x65,0x20,0x6f,0x66,0x20,0x74,0x68,0x65,0x20, /* ild date of the  */ \
	0x48,0x45,0x58,0x20,0x66,0x69,0x6c,0x65,0x20,0x70,0x72,0x6f,0x67,0x72,0x61,0x6d, /* HEX file program */ \
	0x6d,0x65,0x64,0x20,0x69,0x6e,0x20,0x79,0x6f,0x75,0x72,0x20,0x70,0x61,0x72,0x74, /* med in your part */ \
	0x3a,0x3c,0x2f,0x70,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x20,0x63,0x6c, /* :</p>....<div cl */ \
	0x61,0x73,0x73,0x3d,0x22,0x65,0x78,0x61,0x6d,0x70,0x6c,0x65,0x62,0x6f,0x78,0x20, /* ass="examplebox  */ \
	0x63,0x6f,0x64,0x65,0x22,0x3e,0x7e,0x62,0x75,0x69,0x6c,0x64,0x64,0x61,0x74,0x65, /* code">~builddate */ \
	0x7e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x70,0x3e,0x59,0x6f, /* ~</div>....<p>Yo */ \
	0x75,0x20,0x63,0x61,0x6e,0x20,0x61,0x6c,0x73,0x6f,0x20,0x70,0x61,0x73,0x73,0x20, /* u can also pass  */ \
	0x70,0x61,0x72,0x61,0x6d,0x65,0x74,0x65,0x72,0x73,0x20,0x74,0x6f,0x20,0x64,0x79, /* parameters to dy */ \
	0x6e,0x61,0x6d,0x69,0x63,0x20,0x76,0x61,0x72,0x69,0x61,0x62,0x6c,0x65,0x73,0x20, /* namic variables  */ \
	0x62,0x79,0x20,0x70,0x6c,0x61,0x63,0x69,0x6e,0x67,0x20,0x6e,0x75,0x6d,0x65,0x72, /* by placing numer */ \
	0x69,0x63,0x20,0x76,0x61,0x6c,0x75,0x65,0x73,0x20,0x69,0x6e,0x73,0x69,0x64,0x65, /* ic values inside */ \
	0x20,0x0d,0x0a,0x6f,0x66,0x20,0x70,0x61,0x72,0x65,0x6e,0x74,0x68,0x65,0x73,0x69, /*  ..of parenthesi */ \
	0x73,0x20,0x61,0x66,0x74,0x65,0x72,0x20,0x74,0x68,0x65,0x20,0x76,0x61,0x72,0x69, /* s after the vari */ \
	0x61,0x62,0x6c,0x65,0x20,0x6e,0x61,0x6d,0x65,0x2e,0x20,0x20,0x3c,0x63,0x6f,0x64, /* able name.  <cod */ \
	0x65,0x3e,0x7e,0x7e,0x6c,0x65,0x64,0x28,0x32,0x29,0x7e,0x7e,0x3c,0x2f,0x63,0x6f, /* e>~~led(2)~~</co */ \
	0x64,0x65,0x3e,0x20,0x77,0x69,0x6c,0x6c,0x20,0x70,0x72,0x69,0x6e,0x74,0x20,0x74, /* de> will print t */ \
	0x68,0x65,0x20,0x76,0x61,0x6c,0x75,0x65,0x0d,0x0a,0x6f,0x66,0x20,0x74,0x68,0x65, /* he value..of the */ \
	0x20,0x73,0x65,0x63,0x6f,0x6e,0x64,0x20,0x4c,0x45,0x44,0x2e,0x20,0x20,0x54,0x68, /*  second LED.  Th */ \
	0x65,0x20,0x6e,0x75,0x6d,0x65,0x72,0x69,0x63,0x20,0x76,0x61,0x6c,0x75,0x65,0x73, /* e numeric values */ \
	0x20,0x61,0x72,0x65,0x20,0x70,0x61,0x73,0x73,0x65,0x64,0x20,0x61,0x73,0x20,0x57, /*  are passed as W */ \
	0x4f,0x52,0x44,0x20,0x76,0x61,0x6c,0x75,0x65,0x73,0x20,0x74,0x6f,0x20,0x79,0x6f, /* ORD values to yo */ \
	0x75,0x72,0x20,0x63,0x61,0x6c,0x6c,0x62,0x61,0x63,0x6b,0x20,0x66,0x75,0x6e,0x63, /* ur callback func */ \
	0x74,0x69,0x6f,0x6e,0x2e,0x0d,0x0a,0x59,0x6f,0x75,0x20,0x63,0x61,0x6e,0x20,0x70, /* tion...You can p */ \
	0x61,0x73,0x73,0x20,0x61,0x73,0x20,0x6d,0x61,0x6e,0x79,0x20,0x70,0x61,0x72,0x61, /* ass as many para */ \
	0x6d,0x65,0x74,0x65,0x72,0x73,0x20,0x61,0x73,0x20,0x79,0x6f,0x75,0x20,0x77,0x69, /* meters as you wi */ \
	0x73,0x68,0x20,0x74,0x6f,0x20,0x74,0x68,0x65,0x73,0x65,0x20,0x66,0x75,0x6e,0x63, /* sh to these func */ \
	0x74,0x69,0x6f,0x6e,0x73,0x2c,0x20,0x61,0x6e,0x64,0x20,0x69,0x66,0x20,0x79,0x6f, /* tions, and if yo */ \
	0x75,0x72,0x20,0x43,0x20,0x63,0x6f,0x64,0x65,0x20,0x68,0x61,0x73,0x20,0x0d,0x0a, /* ur C code has .. */ \
	0x63,0x6f,0x6e,0x73,0x74,0x61,0x6e,0x74,0x73,0x20,0x64,0x65,0x66,0x69,0x6e,0x65, /* constants define */ \
	0x64,0x2c,0x20,0x74,0x68,0x6f,0x73,0x65,0x20,0x77,0x69,0x6c,0x6c,0x20,0x62,0x65, /* d, those will be */ \
	0x20,0x70,0x61,0x72,0x73,0x65,0x64,0x20,0x61,0x73,0x20,0x77,0x65,0x6c,0x6c,0x2e, /*  parsed as well. */ \
	0x3c,0x2f,0x70,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x70,0x3e,0x41,0x73,0x20,0x61,0x6e, /* </p>....<p>As an */ \
	0x20,0x65,0x78,0x61,0x6d,0x70,0x6c,0x65,0x2c,0x20,0x68,0x65,0x72,0x65,0x20,0x69, /*  example, here i */ \
	0x73,0x20,0x61,0x20,0x62,0x69,0x6e,0x61,0x72,0x79,0x20,0x72,0x65,0x70,0x72,0x65, /* s a binary repre */ \
	0x73,0x65,0x6e,0x74,0x61,0x74,0x69,0x6f,0x6e,0x20,0x77,0x68,0x69,0x63,0x68,0x20, /* sentation which  */ \
	0x4c,0x45,0x44,0x73,0x20,0x61,0x72,0x65,0x20,0x6f,0x6e,0x20,0x61,0x6e,0x64,0x20, /* LEDs are on and  */ \
	0x6f,0x66,0x66,0x20,0x6f,0x6e,0x20,0x74,0x68,0x65,0x20,0x62,0x6f,0x61,0x72,0x64, /* off on the board */ \
	0x3a,0x3c,0x2f,0x70,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x20,0x63,0x6c, /* :</p>....<div cl */ \
	0x61,0x73,0x73,0x3d,0x22,0x65,0x78,0x61,0x6d,0x70,0x6c,0x65,0x62,0x6f,0x78,0x20, /* ass="examplebox  */ \
	0x63,0x6f,0x64,0x65,0x22,0x20,0x73,0x74,0x79,0x6c,0x65,0x3d,0x22,0x6c,0x65,0x74, /* code" style="let */ \
	0x74,0x65,0x72,0x2d,0x73,0x70,0x61,0x63,0x69,0x6e,0x67,0x3a,0x20,0x31,0x30,0x70, /* ter-spacing: 10p */ \
	0x78,0x22,0x3e,0x0d,0x0a,0x7e,0x6c,0x65,0x64,0x28,0x37,0x29,0x7e,0x20,0x7e,0x6c, /* x">..~led(7)~ ~l */ \
	0x65,0x64,0x28,0x36,0x29,0x7e,0x20,0x7e,0x6c,0x65,0x64,0x28,0x35,0x29,0x7e,0x20, /* ed(6)~ ~led(5)~  */ \
	0x7e,0x6c,0x65,0x64,0x28,0x34,0x29,0x7e,0x20,0x7e,0x6c,0x65,0x64,0x28,0x33,0x29  /* ~led(4)~ ~led(3) */
#define DATACHUNK000006 \
	0x7e,0x20,0x7e,0x6c,0x65,0x64,0x28,0x32,0x29,0x7e,0x20,0x7e,0x6c,0x65,0x64,0x28, /* ~ ~led(2)~ ~led( */ \
	0x31,0x29,0x7e,0x20,0x3f,0x0d,0x0a,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x0d, /* 1)~ ?..</div>... */ \
	0x0a,0x3c,0x70,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x65,0x78,0x65,0x72,0x63, /* .<p class="exerc */ \
	0x69,0x73,0x65,0x22,0x3e,0x3c,0x62,0x3e,0x45,0x78,0x65,0x72,0x63,0x69,0x73,0x65, /* ise"><b>Exercise */ \
	0x3a,0x3c,0x2f,0x62,0x3e,0x20,0x54,0x72,0x79,0x20,0x74,0x6f,0x20,0x61,0x64,0x64, /* :</b> Try to add */ \
	0x20,0x74,0x68,0x65,0x20,0x6c,0x61,0x73,0x74,0x20,0x28,0x4c,0x53,0x42,0x29,0x20, /*  the last (LSB)  */ \
	0x4c,0x45,0x44,0x20,0x74,0x6f,0x20,0x74,0x68,0x65,0x20,0x6f,0x75,0x74,0x70,0x75, /* LED to the outpu */ \
	0x74,0x20,0x61,0x62,0x6f,0x76,0x65,0x2e,0x3c,0x2f,0x70,0x3e,0x0d,0x0a,0x0d,0x0a, /* t above.</p>.... */ \
	0x3c,0x70,0x3e,0x46,0x6f,0x72,0x20,0x73,0x68,0x6f,0x72,0x74,0x20,0x6f,0x75,0x74, /* <p>For short out */ \
	0x70,0x75,0x74,0x73,0x20,0x28,0x6c,0x65,0x73,0x73,0x20,0x74,0x68,0x61,0x6e,0x20, /* puts (less than  */ \
	0x31,0x36,0x20,0x62,0x79,0x74,0x65,0x73,0x29,0x20,0x79,0x6f,0x75,0x20,0x6e,0x65, /* 16 bytes) you ne */ \
	0x65,0x64,0x20,0x6f,0x6e,0x6c,0x79,0x20,0x74,0x6f,0x20,0x63,0x61,0x6c,0x6c,0x20, /* ed only to call  */ \
	0x74,0x68,0x65,0x20,0x61,0x70,0x70,0x72,0x6f,0x70,0x72,0x69,0x61,0x74,0x65,0x20, /* the appropriate  */ \
	0x0d,0x0a,0x3c,0x63,0x6f,0x64,0x65,0x3e,0x54,0x43,0x50,0x50,0x75,0x74,0x3c,0x2f, /* ..<code>TCPPut</ */ \
	0x63,0x6f,0x64,0x65,0x3e,0x20,0x66,0x75,0x6e,0x63,0x74,0x69,0x6f,0x6e,0x20,0x61, /* code> function a */ \
	0x6e,0x64,0x20,0x72,0x65,0x74,0x75,0x72,0x6e,0x2e,0x20,0x20,0x46,0x6f,0x72,0x20, /* nd return.  For  */ \
	0x6c,0x6f,0x6e,0x67,0x65,0x72,0x20,0x6f,0x75,0x74,0x70,0x75,0x74,0x73,0x20,0x74, /* longer outputs t */ \
	0x68,0x65,0x20,0x6f,0x75,0x74,0x70,0x75,0x74,0x20,0x73,0x74,0x61,0x74,0x65,0x20, /* he output state  */ \
	0x6d,0x75,0x73,0x74,0x20,0x62,0x65,0x20,0x0d,0x0a,0x6d,0x61,0x6e,0x61,0x67,0x65, /* must be ..manage */ \
	0x64,0x20,0x74,0x68,0x72,0x6f,0x75,0x67,0x68,0x20,0x73,0x75,0x63,0x63,0x65,0x73, /* d through succes */ \
	0x73,0x69,0x76,0x65,0x20,0x63,0x61,0x6c,0x6c,0x73,0x2c,0x20,0x77,0x68,0x69,0x63, /* sive calls, whic */ \
	0x68,0x20,0x70,0x72,0x65,0x76,0x65,0x6e,0x74,0x73,0x20,0x74,0x68,0x65,0x20,0x6c, /* h prevents the l */ \
	0x69,0x6d,0x69,0x74,0x65,0x64,0x20,0x62,0x75,0x66,0x66,0x65,0x72,0x20,0x73,0x70, /* imited buffer sp */ \
	0x61,0x63,0x65,0x20,0x66,0x72,0x6f,0x6d,0x20,0x62,0x65,0x69,0x6e,0x67,0x20,0x0d, /* ace from being . */ \
	0x0a,0x6f,0x76,0x65,0x72,0x72,0x75,0x6e,0x2e,0x3c,0x2f,0x70,0x3e,0x0d,0x0a,0x3c, /* .overrun.</p>..< */ \
	0x70,0x3e,0x41,0x73,0x20,0x61,0x6e,0x20,0x65,0x78,0x61,0x6d,0x70,0x6c,0x65,0x2c, /* p>As an example, */ \
	0x20,0x68,0x65,0x72,0x65,0x20,0x69,0x73,0x20,0x74,0x68,0x65,0x20,0x63,0x75,0x72, /*  here is the cur */ \
	0x72,0x65,0x6e,0x74,0x20,0x4c,0x43,0x44,0x20,0x64,0x69,0x73,0x70,0x6c,0x61,0x79, /* rent LCD display */ \
	0x20,0x28,0x77,0x68,0x69,0x63,0x68,0x20,0x75,0x73,0x65,0x73,0x20,0x33,0x32,0x20, /*  (which uses 32  */ \
	0x62,0x79,0x74,0x65,0x73,0x29,0x3a,0x3c,0x2f,0x70,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c, /* bytes):</p>....< */ \
	0x64,0x69,0x76,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x65,0x78,0x61,0x6d,0x70, /* div class="examp */ \
	0x6c,0x65,0x62,0x6f,0x78,0x20,0x63,0x6f,0x64,0x65,0x22,0x3e,0x7e,0x6c,0x63,0x64, /* lebox code">~lcd */ \
	0x74,0x65,0x78,0x74,0x7e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c, /* text~</div>....< */ \
	0x70,0x3e,0x59,0x6f,0x75,0x20,0x63,0x61,0x6e,0x20,0x61,0x6c,0x73,0x6f,0x20,0x75, /* p>You can also u */ \
	0x73,0x65,0x20,0x64,0x79,0x6e,0x61,0x6d,0x69,0x63,0x20,0x76,0x61,0x72,0x69,0x61, /* se dynamic varia */ \
	0x62,0x6c,0x65,0x73,0x20,0x74,0x6f,0x20,0x69,0x6e,0x63,0x6c,0x75,0x64,0x65,0x20, /* bles to include  */ \
	0x66,0x69,0x6c,0x65,0x73,0x2e,0x20,0x20,0x54,0x68,0x69,0x73,0x20,0x69,0x73,0x20, /* files.  This is  */ \
	0x75,0x73,0x65,0x66,0x75,0x6c,0x20,0x74,0x6f,0x20,0x73,0x61,0x76,0x65,0x20,0x0d, /* useful to save . */ \
	0x0a,0x73,0x74,0x6f,0x72,0x61,0x67,0x65,0x20,0x73,0x70,0x61,0x63,0x65,0x20,0x66, /* .storage space f */ \
	0x6f,0x72,0x20,0x79,0x6f,0x75,0x72,0x20,0x70,0x61,0x67,0x65,0x73,0x2c,0x20,0x73, /* or your pages, s */ \
	0x69,0x6e,0x63,0x65,0x20,0x61,0x20,0x70,0x6f,0x72,0x74,0x69,0x6f,0x6e,0x20,0x6f, /* ince a portion o */ \
	0x66,0x20,0x6d,0x6f,0x73,0x74,0x20,0x70,0x61,0x67,0x65,0x73,0x20,0x28,0x68,0x65, /* f most pages (he */ \
	0x61,0x64,0x65,0x72,0x2c,0x20,0x6d,0x65,0x6e,0x75,0x2c,0x20,0x66,0x6f,0x6f,0x74, /* ader, menu, foot */ \
	0x65,0x72,0x29,0x20,0x0d,0x0a,0x64,0x6f,0x20,0x6e,0x6f,0x74,0x20,0x63,0x68,0x61, /* er) ..do not cha */ \
	0x6e,0x67,0x65,0x2e,0x20,0x20,0x42,0x79,0x20,0x70,0x6c,0x61,0x63,0x69,0x6e,0x67, /* nge.  By placing */ \
	0x20,0x3c,0x63,0x6f,0x64,0x65,0x3e,0x7e,0x7e,0x69,0x6e,0x63,0x26,0x23,0x30,0x35, /*  <code>~~inc&#05 */ \
	0x38,0x3b,0x66,0x69,0x6c,0x65,0x6e,0x61,0x6d,0x65,0x2e,0x69,0x6e,0x63,0x7e,0x7e, /* 8;filename.inc~~ */ \
	0x3c,0x2f,0x63,0x6f,0x64,0x65,0x3e,0x20,0x69,0x6e,0x20,0x79,0x6f,0x75,0x72,0x20, /* </code> in your  */ \
	0x48,0x54,0x4d,0x4c,0x20,0x63,0x6f,0x64,0x65,0x2c,0x20,0x0d,0x0a,0x74,0x68,0x65, /* HTML code, ..the */ \
	0x20,0x66,0x69,0x6c,0x65,0x20,0x3c,0x63,0x6f,0x64,0x65,0x3e,0x66,0x69,0x6c,0x65, /*  file <code>file */ \
	0x6e,0x61,0x6d,0x65,0x2e,0x69,0x6e,0x63,0x3c,0x2f,0x63,0x6f,0x64,0x65,0x3e,0x20, /* name.inc</code>  */ \
	0x77,0x69,0x6c,0x6c,0x20,0x62,0x65,0x20,0x72,0x65,0x61,0x64,0x20,0x61,0x6e,0x64, /* will be read and */ \
	0x20,0x69,0x6e,0x73,0x65,0x72,0x74,0x65,0x64,0x20,0x61,0x74,0x20,0x74,0x68,0x69, /*  inserted at thi */ \
	0x73,0x20,0x6c,0x6f,0x63,0x61,0x74,0x69,0x6f,0x6e,0x2e,0x3c,0x2f,0x70,0x3e,0x0d, /* s location.</p>. */ \
	0x0a,0x3c,0x70,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x65,0x78,0x65,0x72,0x63, /* .<p class="exerc */ \
	0x69,0x73,0x65,0x22,0x3e,0x3c,0x62,0x3e,0x45,0x78,0x65,0x72,0x63,0x69,0x73,0x65, /* ise"><b>Exercise */ \
	0x3a,0x3c,0x2f,0x62,0x3e,0x20,0x4c,0x6f,0x6f,0x6b,0x20,0x61,0x74,0x20,0x63,0x6f, /* :</b> Look at co */ \
	0x64,0x65,0x20,0x66,0x6f,0x72,0x20,0x74,0x68,0x69,0x73,0x20,0x70,0x61,0x67,0x65, /* de for this page */ \
	0x20,0x61,0x6e,0x64,0x20,0x66,0x69,0x6e,0x64,0x20,0x68,0x6f,0x77,0x20,0x0d,0x0a, /*  and find how .. */ \
	0x3c,0x63,0x6f,0x64,0x65,0x3e,0x68,0x65,0x61,0x64,0x65,0x72,0x2e,0x69,0x6e,0x63, /* <code>header.inc */ \
	0x3c,0x2f,0x63,0x6f,0x64,0x65,0x3e,0x20,0x61,0x6e,0x64,0x20,0x3c,0x63,0x6f,0x64, /* </code> and <cod */ \
	0x65,0x3e,0x66,0x6f,0x6f,0x74,0x65,0x72,0x2e,0x69,0x6e,0x63,0x3c,0x2f,0x63,0x6f, /* e>footer.inc</co */ \
	0x64,0x65,0x3e,0x20,0x61,0x72,0x65,0x20,0x75,0x73,0x65,0x64,0x2e,0x20,0x20,0x54, /* de> are used.  T */ \
	0x68,0x65,0x73,0x65,0x20,0x66,0x69,0x6c,0x65,0x73,0x20,0x70,0x72,0x6f,0x76,0x69  /* hese files provi */
#define DATACHUNK000007 \
	0x64,0x65,0x20,0x0d,0x0a,0x61,0x20,0x74,0x65,0x6d,0x70,0x6c,0x61,0x74,0x65,0x20, /* de ..a template  */ \
	0x66,0x6f,0x72,0x20,0x74,0x68,0x65,0x20,0x70,0x61,0x67,0x65,0x73,0x20,0x74,0x6f, /* for the pages to */ \
	0x20,0x69,0x6e,0x63,0x6c,0x75,0x64,0x65,0x20,0x74,0x68,0x65,0x20,0x73,0x61,0x6d, /*  include the sam */ \
	0x65,0x20,0x6d,0x65,0x6e,0x75,0x2c,0x20,0x6c,0x61,0x79,0x6f,0x75,0x74,0x2c,0x20, /* e menu, layout,  */ \
	0x61,0x6e,0x64,0x20,0x64,0x65,0x73,0x69,0x67,0x6e,0x20,0x65,0x6c,0x65,0x6d,0x65, /* and design eleme */ \
	0x6e,0x74,0x73,0x2e,0x3c,0x2f,0x70,0x3e,0x0d,0x0a,0x3c,0x70,0x3e,0x3c,0x73,0x6d, /* nts.</p>..<p><sm */ \
	0x61,0x6c,0x6c,0x3e,0x28,0x41,0x74,0x20,0x74,0x68,0x69,0x73,0x20,0x74,0x69,0x6d, /* all>(At this tim */ \
	0x65,0x2c,0x20,0x64,0x79,0x6e,0x61,0x6d,0x69,0x63,0x20,0x76,0x61,0x72,0x69,0x61, /* e, dynamic varia */ \
	0x62,0x6c,0x65,0x73,0x20,0x61,0x72,0x65,0x20,0x6e,0x6f,0x6e,0x2d,0x72,0x65,0x63, /* bles are non-rec */ \
	0x75,0x72,0x73,0x69,0x76,0x65,0x2c,0x20,0x73,0x6f,0x20,0x76,0x61,0x72,0x69,0x61, /* ursive, so varia */ \
	0x62,0x6c,0x65,0x73,0x20,0x6c,0x6f,0x63,0x61,0x74,0x65,0x64,0x20,0x69,0x6e,0x73, /* bles located ins */ \
	0x69,0x64,0x65,0x0d,0x0a,0x66,0x69,0x6c,0x65,0x73,0x3c,0x62,0x72,0x20,0x2f,0x3e, /* ide..files<br /> */ \
	0x20,0x69,0x6e,0x63,0x6c,0x75,0x64,0x65,0x64,0x20,0x69,0x6e,0x20,0x74,0x68,0x69, /*  included in thi */ \
	0x73,0x20,0x6d,0x61,0x6e,0x6e,0x65,0x72,0x20,0x61,0x72,0x65,0x20,0x6e,0x6f,0x74, /* s manner are not */ \
	0x20,0x70,0x61,0x72,0x73,0x65,0x64,0x2e,0x29,0x3c,0x2f,0x73,0x6d,0x61,0x6c,0x6c, /*  parsed.)</small */ \
	0x3e,0x3c,0x2f,0x70,0x3e,0x0d,0x0a,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x0d, /* ></p>..</div>... */ \
	0x0a,0x3c,0x73,0x63,0x72,0x69,0x70,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74, /* .<script type="t */ \
	0x65,0x78,0x74,0x2f,0x6a,0x61,0x76,0x61,0x73,0x63,0x72,0x69,0x70,0x74,0x22,0x3e, /* ext/javascript"> */ \
	0x0d,0x0a,0x3c,0x21,0x2d,0x2d,0x0d,0x0a,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74, /* ..<!--..document */ \
	0x2e,0x67,0x65,0x74,0x45,0x6c,0x65,0x6d,0x65,0x6e,0x74,0x42,0x79,0x49,0x64,0x28, /* .getElementById( */ \
	0x27,0x68,0x65,0x6c,0x6c,0x6f,0x27,0x29,0x2e,0x69,0x6e,0x6e,0x65,0x72,0x48,0x54, /* 'hello').innerHT */ \
	0x4d,0x4c,0x20,0x3d,0x20,0x22,0x7e,0x68,0x65,0x6c,0x6c,0x6f,0x6d,0x73,0x67,0x7e, /* ML = "~hellomsg~ */ \
	0x22,0x3b,0x0d,0x0a,0x2d,0x2d,0x3e,0x0d,0x0a,0x3c,0x2f,0x73,0x63,0x72,0x69,0x70, /* ";..-->..</scrip */ \
	0x74,0x3e,0x0d,0x0a,0x7e,0x69,0x6e,0x63,0x3a,0x66,0x6f,0x6f,0x74,0x65,0x72,0x2e, /* t>..~inc:footer. */ \
	0x69,0x6e,0x63,0x7e,0x00,0x00,0x00,0x00,0x33,0x00,0x00,0x00,0xd3,0x01,0x00,0x00, /* inc~....3....... */ \
	0x04,0x00,0x00,0x00,0xfa,0x01,0x00,0x00,0x04,0x00,0x00,0x00,0x06,0x02,0x00,0x00, /* ................ */ \
	0x04,0x00,0x00,0x00,0xf2,0x02,0x00,0x00,0x05,0x00,0x00,0x00,0x8e,0x03,0x00,0x00, /* ................ */ \
	0x04,0x00,0x00,0x00,0x96,0x03,0x00,0x00,0x04,0x00,0x00,0x00,0x41,0x05,0x00,0x00, /* ............A... */ \
	0x06,0x00,0x00,0x00,0x4a,0x05,0x00,0x00,0x07,0x00,0x00,0x00,0x53,0x05,0x00,0x00, /* ....J.......S... */ \
	0x08,0x00,0x00,0x00,0x5c,0x05,0x00,0x00,0x09,0x00,0x00,0x00,0x65,0x05,0x00,0x00, /* ....\.......e... */ \
	0x0a,0x00,0x00,0x00,0x6e,0x05,0x00,0x00,0x0b,0x00,0x00,0x00,0x77,0x05,0x00,0x00, /* ....n.......w... */ \
	0x0c,0x00,0x00,0x00,0x68,0x07,0x00,0x00,0x0d,0x00,0x00,0x00,0x43,0x08,0x00,0x00, /* ....h.......C... */ \
	0x04,0x00,0x00,0x00,0x5a,0x08,0x00,0x00,0x04,0x00,0x00,0x00,0xc2,0x0a,0x00,0x00, /* ....Z........... */ \
	0x01,0x00,0x00,0x00,0xe0,0x0a,0x00,0x00,0x02,0x00,0x00,0x00,0x3c,0x64,0x69,0x76, /* ............<div */ \
	0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x73,0x70,0x61,0x63,0x65,0x72,0x22,0x3e, /*  class="spacer"> */ \
	0x26,0x6e,0x62,0x73,0x70,0x3b,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64, /* &nbsp;</div>..<d */ \
	0x69,0x76,0x20,0x69,0x64,0x3d,0x22,0x66,0x6f,0x6f,0x74,0x65,0x72,0x22,0x3e,0x43, /* iv id="footer">C */ \
	0x6f,0x70,0x79,0x72,0x69,0x67,0x68,0x74,0x20,0x26,0x63,0x6f,0x70,0x79,0x3b,0x20, /* opyright &copy;  */ \
	0x32,0x30,0x30,0x39,0x20,0x4d,0x69,0x63,0x72,0x6f,0x63,0x68,0x69,0x70,0x20,0x54, /* 2009 Microchip T */ \
	0x65,0x63,0x68,0x6e,0x6f,0x6c,0x6f,0x67,0x79,0x2c,0x20,0x49,0x6e,0x63,0x2e,0x3c, /* echnology, Inc.< */ \
	0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x3c, /* /div>....</div>< */ \
	0x2f,0x64,0x69,0x76,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x3c,0x2f,0x64,0x69,0x76, /* /div></div></div */ \
	0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x2f,0x62,0x6f,0x64, /* ></div>....</bod */ \
	0x79,0x3e,0x0d,0x0a,0x3c,0x2f,0x68,0x74,0x6d,0x6c,0x3e,0x7e,0x69,0x6e,0x63,0x3a, /* y>..</html>~inc: */ \
	0x68,0x65,0x61,0x64,0x65,0x72,0x2e,0x69,0x6e,0x63,0x7e,0x0d,0x0a,0x3c,0x64,0x69, /* header.inc~..<di */ \
	0x76,0x20,0x69,0x64,0x3d,0x22,0x63,0x6f,0x6e,0x74,0x65,0x6e,0x74,0x22,0x3e,0x0d, /* v id="content">. */ \
	0x0a,0x0d,0x0a,0x3c,0x68,0x31,0x3e,0x46,0x6f,0x72,0x6d,0x20,0x50,0x72,0x6f,0x63, /* ...<h1>Form Proc */ \
	0x65,0x73,0x73,0x69,0x6e,0x67,0x3c,0x2f,0x68,0x31,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c, /* essing</h1>....< */ \
	0x70,0x3e,0x59,0x6f,0x75,0x72,0x20,0x61,0x70,0x70,0x6c,0x69,0x63,0x61,0x74,0x69, /* p>Your applicati */ \
	0x6f,0x6e,0x20,0x77,0x69,0x6c,0x6c,0x20,0x6c,0x69,0x6b,0x65,0x6c,0x79,0x20,0x6e, /* on will likely n */ \
	0x65,0x65,0x64,0x20,0x74,0x6f,0x20,0x61,0x63,0x63,0x65,0x70,0x74,0x20,0x64,0x61, /* eed to accept da */ \
	0x74,0x61,0x20,0x66,0x72,0x6f,0x6d,0x20,0x74,0x68,0x65,0x20,0x75,0x73,0x65,0x72, /* ta from the user */ \
	0x2e,0x20,0x20,0x46,0x6f,0x72,0x6d,0x73,0x20,0x61,0x6c,0x6c,0x6f,0x77,0x0d,0x0a, /* .  Forms allow.. */ \
	0x79,0x6f,0x75,0x20,0x74,0x6f,0x20,0x64,0x6f,0x20,0x6a,0x75,0x73,0x74,0x20,0x74, /* you to do just t */ \
	0x68,0x61,0x74,0x2e,0x20,0x20,0x46,0x6f,0x72,0x6d,0x73,0x20,0x63,0x61,0x6e,0x20, /* hat.  Forms can  */ \
	0x62,0x65,0x20,0x73,0x75,0x62,0x6d,0x69,0x74,0x74,0x65,0x64,0x20,0x69,0x6e,0x20, /* be submitted in  */ \
	0x6f,0x6e,0x65,0x20,0x6f,0x66,0x20,0x74,0x77,0x6f,0x20,0x6d,0x65,0x74,0x68,0x6f, /* one of two metho */ \
	0x64,0x73,0x20,0x28,0x3c,0x69,0x3e,0x47,0x45,0x54,0x3c,0x2f,0x69,0x3e,0x20,0x61, /* ds (<i>GET</i> a */ \
	0x6e,0x64,0x20,0x0d,0x0a,0x3c,0x69,0x3e,0x50,0x4f,0x53,0x54,0x3c,0x2f,0x69,0x3e, /* nd ..<i>POST</i> */ \
	0x29,0x2c,0x20,0x61,0x6e,0x64,0x20,0x74,0x68,0x69,0x73,0x20,0x73,0x65,0x72,0x76, /* ), and this serv */ \
	0x65,0x72,0x20,0x73,0x75,0x70,0x70,0x6f,0x72,0x74,0x73,0x20,0x62,0x6f,0x74,0x68, /* er supports both */ \
	0x2e,0x3c,0x2f,0x70,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x68,0x36,0x3e,0x3c,0x2f,0x68, /* .</p>....<h6></h */ \
	0x36,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x70,0x3e,0x54,0x68,0x65,0x20,0x3c,0x62,0x3e, /* 6>....<p>The <b> */ \
	0x47,0x45,0x54,0x3c,0x2f,0x62,0x3e,0x20,0x6d,0x65,0x74,0x68,0x6f,0x64,0x20,0x61  /* GET</b> method a */
#define DATACHUNK000008 \
	0x70,0x70,0x65,0x6e,0x64,0x73,0x20,0x74,0x68,0x65,0x20,0x64,0x61,0x74,0x61,0x20, /* ppends the data  */ \
	0x74,0x6f,0x20,0x74,0x68,0x65,0x20,0x65,0x6e,0x64,0x20,0x6f,0x66,0x20,0x74,0x68, /* to the end of th */ \
	0x65,0x20,0x55,0x52,0x49,0x2e,0x20,0x20,0x59,0x6f,0x75,0x27,0x6c,0x6c,0x20,0x73, /* e URI.  You'll s */ \
	0x65,0x65,0x20,0x74,0x68,0x69,0x73,0x20,0x0d,0x0a,0x64,0x61,0x74,0x61,0x20,0x66, /* ee this ..data f */ \
	0x6f,0x6c,0x6c,0x6f,0x77,0x69,0x6e,0x67,0x20,0x74,0x68,0x65,0x20,0x71,0x75,0x65, /* ollowing the que */ \
	0x73,0x74,0x69,0x6f,0x6e,0x20,0x6d,0x61,0x72,0x6b,0x20,0x28,0x3f,0x29,0x20,0x69, /* stion mark (?) i */ \
	0x6e,0x20,0x79,0x6f,0x75,0x72,0x20,0x62,0x72,0x6f,0x77,0x73,0x65,0x72,0x27,0x73, /* n your browser's */ \
	0x20,0x61,0x64,0x64,0x72,0x65,0x73,0x73,0x20,0x62,0x61,0x72,0x2e,0x20,0x20,0x46, /*  address bar.  F */ \
	0x6f,0x72,0x20,0x4d,0x69,0x63,0x72,0x6f,0x63,0x68,0x69,0x70,0x27,0x73,0x20,0x0d, /* or Microchip's . */ \
	0x0a,0x65,0x6d,0x62,0x65,0x64,0x64,0x65,0x64,0x20,0x73,0x65,0x72,0x76,0x65,0x72, /* .embedded server */ \
	0x2c,0x20,0x74,0x68,0x69,0x73,0x20,0x64,0x61,0x74,0x61,0x20,0x69,0x73,0x20,0x6c, /* , this data is l */ \
	0x69,0x6d,0x69,0x74,0x65,0x64,0x20,0x74,0x6f,0x20,0x61,0x72,0x6f,0x75,0x6e,0x64, /* imited to around */ \
	0x20,0x38,0x30,0x20,0x62,0x79,0x74,0x65,0x73,0x2e,0x20,0x20,0x48,0x6f,0x77,0x65, /*  80 bytes.  Howe */ \
	0x76,0x65,0x72,0x2c,0x20,0x74,0x68,0x69,0x73,0x20,0x73,0x6f,0x72,0x74,0x20,0x6f, /* ver, this sort o */ \
	0x66,0x20,0x0d,0x0a,0x73,0x75,0x62,0x6d,0x69,0x73,0x73,0x69,0x6f,0x6e,0x20,0x69, /* f ..submission i */ \
	0x73,0x20,0x67,0x65,0x6e,0x65,0x72,0x61,0x6c,0x6c,0x79,0x20,0x65,0x61,0x73,0x69, /* s generally easi */ \
	0x65,0x72,0x20,0x74,0x6f,0x20,0x70,0x72,0x6f,0x63,0x65,0x73,0x73,0x2e,0x20,0x44, /* er to process. D */ \
	0x61,0x74,0x61,0x20,0x73,0x65,0x6e,0x74,0x20,0x76,0x69,0x61,0x20,0x47,0x45,0x54, /* ata sent via GET */ \
	0x20,0x69,0x73,0x20,0x61,0x75,0x74,0x6f,0x6d,0x61,0x74,0x69,0x63,0x61,0x6c,0x6c, /*  is automaticall */ \
	0x79,0x20,0x0d,0x0a,0x64,0x65,0x63,0x6f,0x64,0x65,0x64,0x2c,0x20,0x61,0x6e,0x64, /* y ..decoded, and */ \
	0x20,0x73,0x74,0x6f,0x72,0x65,0x64,0x20,0x69,0x6e,0x20,0x74,0x68,0x65,0x20,0x61, /*  stored in the a */ \
	0x72,0x72,0x61,0x79,0x20,0x3c,0x63,0x6f,0x64,0x65,0x3e,0x63,0x75,0x72,0x48,0x54, /* rray <code>curHT */ \
	0x54,0x50,0x2e,0x64,0x61,0x74,0x61,0x3c,0x2f,0x63,0x6f,0x64,0x65,0x3e,0x2e,0x20, /* TP.data</code>.  */ \
	0x20,0x59,0x6f,0x75,0x72,0x20,0x61,0x70,0x70,0x6c,0x69,0x63,0x61,0x74,0x69,0x6f, /*  Your applicatio */ \
	0x6e,0x20,0x77,0x69,0x6c,0x6c,0x0d,0x0a,0x68,0x61,0x6e,0x64,0x6c,0x65,0x20,0x74, /* n will..handle t */ \
	0x68,0x65,0x20,0x64,0x61,0x74,0x61,0x20,0x69,0x6e,0x20,0x74,0x68,0x65,0x20,0x3c, /* he data in the < */ \
	0x63,0x6f,0x64,0x65,0x3e,0x48,0x54,0x54,0x50,0x45,0x78,0x65,0x63,0x75,0x74,0x65, /* code>HTTPExecute */ \
	0x47,0x65,0x74,0x3c,0x2f,0x63,0x6f,0x64,0x65,0x3e,0x20,0x63,0x61,0x6c,0x6c,0x62, /* Get</code> callb */ \
	0x61,0x63,0x6b,0x2e,0x20,0x20,0x54,0x68,0x65,0x20,0x66,0x75,0x6e,0x63,0x74,0x69, /* ack.  The functi */ \
	0x6f,0x6e,0x73,0x20,0x0d,0x0a,0x3c,0x63,0x6f,0x64,0x65,0x3e,0x48,0x54,0x54,0x50, /* ons ..<code>HTTP */ \
	0x47,0x65,0x74,0x41,0x72,0x67,0x3c,0x2f,0x63,0x6f,0x64,0x65,0x3e,0x20,0x61,0x6e, /* GetArg</code> an */ \
	0x64,0x20,0x3c,0x63,0x6f,0x64,0x65,0x3e,0x48,0x54,0x54,0x50,0x47,0x65,0x74,0x52, /* d <code>HTTPGetR */ \
	0x4f,0x4d,0x41,0x72,0x67,0x3c,0x2f,0x63,0x6f,0x64,0x65,0x3e,0x20,0x70,0x72,0x6f, /* OMArg</code> pro */ \
	0x76,0x69,0x64,0x65,0x20,0x61,0x6e,0x20,0x65,0x61,0x73,0x79,0x20,0x0d,0x0a,0x6d, /* vide an easy ..m */ \
	0x65,0x74,0x68,0x6f,0x64,0x20,0x74,0x6f,0x20,0x72,0x65,0x74,0x72,0x69,0x65,0x76, /* ethod to retriev */ \
	0x65,0x20,0x73,0x75,0x62,0x6d,0x69,0x74,0x74,0x65,0x64,0x20,0x76,0x61,0x6c,0x75, /* e submitted valu */ \
	0x65,0x73,0x20,0x66,0x6f,0x72,0x20,0x70,0x72,0x6f,0x63,0x65,0x73,0x73,0x69,0x6e, /* es for processin */ \
	0x67,0x2e,0x3c,0x2f,0x70,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x70,0x3e,0x41,0x73,0x20, /* g.</p>....<p>As  */ \
	0x61,0x6e,0x20,0x65,0x78,0x61,0x6d,0x70,0x6c,0x65,0x2c,0x20,0x74,0x68,0x69,0x73, /* an example, this */ \
	0x20,0x47,0x45,0x54,0x20,0x66,0x6f,0x72,0x6d,0x20,0x63,0x6f,0x6e,0x74,0x72,0x6f, /*  GET form contro */ \
	0x6c,0x73,0x20,0x73,0x65,0x76,0x65,0x72,0x61,0x6c,0x20,0x4c,0x45,0x44,0x73,0x20, /* ls several LEDs  */ \
	0x6f,0x6e,0x20,0x74,0x68,0x65,0x20,0x64,0x65,0x6d,0x6f,0x20,0x62,0x6f,0x61,0x72, /* on the demo boar */ \
	0x64,0x3a,0x3c,0x2f,0x70,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x66,0x6f,0x72,0x6d,0x20, /* d:</p>....<form  */ \
	0x6d,0x65,0x74,0x68,0x6f,0x64,0x3d,0x22,0x67,0x65,0x74,0x22,0x20,0x61,0x63,0x74, /* method="get" act */ \
	0x69,0x6f,0x6e,0x3d,0x22,0x66,0x6f,0x72,0x6d,0x73,0x2e,0x68,0x74,0x6d,0x22,0x3e, /* ion="forms.htm"> */ \
	0x0d,0x0a,0x3c,0x64,0x69,0x76,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x65,0x78, /* ..<div class="ex */ \
	0x61,0x6d,0x70,0x6c,0x65,0x62,0x6f,0x78,0x22,0x3e,0x0d,0x0a,0x3c,0x62,0x3e,0x34, /* amplebox">..<b>4 */ \
	0x3a,0x3c,0x2f,0x62,0x3e,0x20,0x3c,0x73,0x65,0x6c,0x65,0x63,0x74,0x20,0x6e,0x61, /* :</b> <select na */ \
	0x6d,0x65,0x3d,0x22,0x6c,0x65,0x64,0x34,0x22,0x3e,0x3c,0x6f,0x70,0x74,0x69,0x6f, /* me="led4"><optio */ \
	0x6e,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x31,0x22,0x20,0x7e,0x6c,0x65,0x64, /* n value="1" ~led */ \
	0x53,0x65,0x6c,0x65,0x63,0x74,0x65,0x64,0x28,0x34,0x2c,0x54,0x52,0x55,0x45,0x29, /* Selected(4,TRUE) */ \
	0x7e,0x3e,0x4f,0x6e,0x3c,0x2f,0x6f,0x70,0x74,0x69,0x6f,0x6e,0x3e,0x3c,0x6f,0x70, /* ~>On</option><op */ \
	0x74,0x69,0x6f,0x6e,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x30,0x22,0x20,0x7e, /* tion value="0" ~ */ \
	0x6c,0x65,0x64,0x53,0x65,0x6c,0x65,0x63,0x74,0x65,0x64,0x28,0x34,0x2c,0x46,0x41, /* ledSelected(4,FA */ \
	0x4c,0x53,0x45,0x29,0x7e,0x3e,0x4f,0x66,0x66,0x3c,0x2f,0x6f,0x70,0x74,0x69,0x6f, /* LSE)~>Off</optio */ \
	0x6e,0x3e,0x3c,0x2f,0x73,0x65,0x6c,0x65,0x63,0x74,0x3e,0x26,0x6e,0x62,0x73,0x70, /* n></select>&nbsp */ \
	0x3b,0x20,0x0d,0x0a,0x3c,0x62,0x3e,0x33,0x3a,0x3c,0x2f,0x62,0x3e,0x20,0x3c,0x73, /* ; ..<b>3:</b> <s */ \
	0x65,0x6c,0x65,0x63,0x74,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x6c,0x65,0x64,0x33, /* elect name="led3 */ \
	0x22,0x3e,0x3c,0x6f,0x70,0x74,0x69,0x6f,0x6e,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d, /* "><option value= */ \
	0x22,0x31,0x22,0x20,0x7e,0x6c,0x65,0x64,0x53,0x65,0x6c,0x65,0x63,0x74,0x65,0x64, /* "1" ~ledSelected */ \
	0x28,0x33,0x2c,0x54,0x52,0x55,0x45,0x29,0x7e,0x3e,0x4f,0x6e,0x3c,0x2f,0x6f,0x70, /* (3,TRUE)~>On</op */ \
	0x74,0x69,0x6f,0x6e,0x3e,0x3c,0x6f,0x70,0x74,0x69,0x6f,0x6e,0x20,0x76,0x61,0x6c, /* tion><option val */ \
	0x75,0x65,0x3d,0x22,0x30,0x22,0x20,0x7e,0x6c,0x65,0x64,0x53,0x65,0x6c,0x65,0x63, /* ue="0" ~ledSelec */ \
	0x74,0x65,0x64,0x28,0x33,0x2c,0x46,0x41,0x4c,0x53,0x45,0x29,0x7e,0x3e,0x4f,0x66  /* ted(3,FALSE)~>Of */
#define DATACHUNK000009 \
	0x66,0x3c,0x2f,0x6f,0x70,0x74,0x69,0x6f,0x6e,0x3e,0x3c,0x2f,0x73,0x65,0x6c,0x65, /* f</option></sele */ \
	0x63,0x74,0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x20,0x0d,0x0a,0x3c,0x62,0x3e,0x32, /* ct>&nbsp; ..<b>2 */ \
	0x3a,0x3c,0x2f,0x62,0x3e,0x20,0x3c,0x73,0x65,0x6c,0x65,0x63,0x74,0x20,0x6e,0x61, /* :</b> <select na */ \
	0x6d,0x65,0x3d,0x22,0x6c,0x65,0x64,0x32,0x22,0x3e,0x3c,0x6f,0x70,0x74,0x69,0x6f, /* me="led2"><optio */ \
	0x6e,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x31,0x22,0x20,0x7e,0x6c,0x65,0x64, /* n value="1" ~led */ \
	0x53,0x65,0x6c,0x65,0x63,0x74,0x65,0x64,0x28,0x32,0x2c,0x54,0x52,0x55,0x45,0x29, /* Selected(2,TRUE) */ \
	0x7e,0x3e,0x4f,0x6e,0x3c,0x2f,0x6f,0x70,0x74,0x69,0x6f,0x6e,0x3e,0x3c,0x6f,0x70, /* ~>On</option><op */ \
	0x74,0x69,0x6f,0x6e,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x30,0x22,0x20,0x7e, /* tion value="0" ~ */ \
	0x6c,0x65,0x64,0x53,0x65,0x6c,0x65,0x63,0x74,0x65,0x64,0x28,0x32,0x2c,0x46,0x41, /* ledSelected(2,FA */ \
	0x4c,0x53,0x45,0x29,0x7e,0x3e,0x4f,0x66,0x66,0x3c,0x2f,0x6f,0x70,0x74,0x69,0x6f, /* LSE)~>Off</optio */ \
	0x6e,0x3e,0x3c,0x2f,0x73,0x65,0x6c,0x65,0x63,0x74,0x3e,0x26,0x6e,0x62,0x73,0x70, /* n></select>&nbsp */ \
	0x3b,0x20,0x0d,0x0a,0x3c,0x62,0x3e,0x31,0x3a,0x3c,0x2f,0x62,0x3e,0x20,0x3c,0x73, /* ; ..<b>1:</b> <s */ \
	0x65,0x6c,0x65,0x63,0x74,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x6c,0x65,0x64,0x31, /* elect name="led1 */ \
	0x22,0x3e,0x3c,0x6f,0x70,0x74,0x69,0x6f,0x6e,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d, /* "><option value= */ \
	0x22,0x31,0x22,0x20,0x7e,0x6c,0x65,0x64,0x53,0x65,0x6c,0x65,0x63,0x74,0x65,0x64, /* "1" ~ledSelected */ \
	0x28,0x31,0x2c,0x54,0x52,0x55,0x45,0x29,0x7e,0x3e,0x4f,0x6e,0x3c,0x2f,0x6f,0x70, /* (1,TRUE)~>On</op */ \
	0x74,0x69,0x6f,0x6e,0x3e,0x3c,0x6f,0x70,0x74,0x69,0x6f,0x6e,0x20,0x76,0x61,0x6c, /* tion><option val */ \
	0x75,0x65,0x3d,0x22,0x30,0x22,0x20,0x7e,0x6c,0x65,0x64,0x53,0x65,0x6c,0x65,0x63, /* ue="0" ~ledSelec */ \
	0x74,0x65,0x64,0x28,0x31,0x2c,0x46,0x41,0x4c,0x53,0x45,0x29,0x7e,0x3e,0x4f,0x66, /* ted(1,FALSE)~>Of */ \
	0x66,0x3c,0x2f,0x6f,0x70,0x74,0x69,0x6f,0x6e,0x3e,0x3c,0x2f,0x73,0x65,0x6c,0x65, /* f</option></sele */ \
	0x63,0x74,0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x20,0x0d,0x0a,0x3c,0x62,0x72,0x20, /* ct>&nbsp; ..<br  */ \
	0x2f,0x3e,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x73, /* /><input type="s */ \
	0x75,0x62,0x6d,0x69,0x74,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x53,0x61, /* ubmit" value="Sa */ \
	0x76,0x65,0x22,0x20,0x73,0x74,0x79,0x6c,0x65,0x3d,0x22,0x6d,0x61,0x72,0x67,0x69, /* ve" style="margi */ \
	0x6e,0x2d,0x74,0x6f,0x70,0x3a,0x35,0x70,0x78,0x3b,0x22,0x3e,0x0d,0x0a,0x3c,0x2f, /* n-top:5px;">..</ */ \
	0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x2f,0x66,0x6f,0x72,0x6d,0x3e,0x0d,0x0a,0x0d, /* div>..</form>... */ \
	0x0a,0x3c,0x70,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x65,0x78,0x65,0x72,0x63, /* .<p class="exerc */ \
	0x69,0x73,0x65,0x22,0x3e,0x3c,0x62,0x3e,0x45,0x78,0x65,0x72,0x63,0x69,0x73,0x65, /* ise"><b>Exercise */ \
	0x3a,0x3c,0x2f,0x62,0x3e,0x20,0x4d,0x6f,0x64,0x69,0x66,0x79,0x20,0x74,0x68,0x69, /* :</b> Modify thi */ \
	0x73,0x20,0x66,0x6f,0x72,0x6d,0x20,0x74,0x6f,0x20,0x73,0x75,0x70,0x70,0x6f,0x72, /* s form to suppor */ \
	0x74,0x20,0x4c,0x45,0x44,0x20,0x35,0x2e,0x3c,0x2f,0x70,0x3e,0x0d,0x0a,0x0d,0x0a, /* t LED 5.</p>.... */ \
	0x3c,0x68,0x36,0x3e,0x3c,0x2f,0x68,0x36,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x70,0x3e, /* <h6></h6>....<p> */ \
	0x54,0x68,0x65,0x20,0x3c,0x62,0x3e,0x50,0x4f,0x53,0x54,0x3c,0x2f,0x62,0x3e,0x20, /* The <b>POST</b>  */ \
	0x6d,0x65,0x74,0x68,0x6f,0x64,0x20,0x73,0x75,0x62,0x6d,0x69,0x74,0x73,0x20,0x74, /* method submits t */ \
	0x68,0x65,0x20,0x64,0x61,0x74,0x61,0x20,0x61,0x66,0x74,0x65,0x72,0x20,0x74,0x68, /* he data after th */ \
	0x65,0x20,0x72,0x65,0x71,0x75,0x65,0x73,0x74,0x20,0x68,0x65,0x61,0x64,0x65,0x72, /* e request header */ \
	0x73,0x20,0x61,0x72,0x65,0x20,0x0d,0x0a,0x73,0x65,0x6e,0x74,0x2e,0x20,0x20,0x54, /* s are ..sent.  T */ \
	0x68,0x69,0x73,0x20,0x61,0x6c,0x6c,0x6f,0x77,0x73,0x20,0x74,0x68,0x65,0x20,0x64, /* his allows the d */ \
	0x61,0x74,0x61,0x20,0x74,0x6f,0x20,0x62,0x65,0x20,0x76,0x69,0x72,0x74,0x75,0x61, /* ata to be virtua */ \
	0x6c,0x6c,0x79,0x20,0x75,0x6e,0x6c,0x69,0x6d,0x69,0x74,0x65,0x64,0x20,0x69,0x6e, /* lly unlimited in */ \
	0x20,0x6c,0x65,0x6e,0x67,0x74,0x68,0x2c,0x20,0x61,0x73,0x20,0x6c,0x6f,0x6e,0x67, /*  length, as long */ \
	0x20,0x61,0x73,0x20,0x79,0x6f,0x75,0x72,0x20,0x0d,0x0a,0x61,0x70,0x70,0x6c,0x69, /*  as your ..appli */ \
	0x63,0x61,0x74,0x69,0x6f,0x6e,0x20,0x63,0x61,0x6e,0x20,0x70,0x72,0x6f,0x63,0x65, /* cation can proce */ \
	0x73,0x73,0x20,0x69,0x74,0x20,0x69,0x6e,0x20,0x63,0x68,0x75,0x6e,0x6b,0x73,0x2e, /* ss it in chunks. */ \
	0x20,0x20,0x48,0x6f,0x77,0x65,0x76,0x65,0x72,0x2c,0x20,0x79,0x6f,0x75,0x72,0x20, /*   However, your  */ \
	0x61,0x70,0x70,0x6c,0x69,0x63,0x61,0x74,0x69,0x6f,0x6e,0x20,0x6d,0x75,0x73,0x74, /* application must */ \
	0x20,0x6d,0x61,0x6e,0x61,0x67,0x65,0x20,0x0d,0x0a,0x74,0x68,0x65,0x20,0x72,0x65, /*  manage ..the re */ \
	0x63,0x65,0x69,0x70,0x74,0x20,0x6f,0x66,0x20,0x64,0x61,0x74,0x61,0x2c,0x20,0x73, /* ceipt of data, s */ \
	0x6f,0x20,0x69,0x74,0x20,0x69,0x73,0x20,0x67,0x65,0x6e,0x65,0x72,0x61,0x6c,0x6c, /* o it is generall */ \
	0x79,0x20,0x6d,0x6f,0x72,0x65,0x20,0x63,0x6f,0x6d,0x70,0x6c,0x69,0x63,0x61,0x74, /* y more complicat */ \
	0x65,0x64,0x2e,0x3c,0x2f,0x70,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x70,0x3e,0x41,0x73, /* ed.</p>....<p>As */ \
	0x20,0x61,0x6e,0x20,0x65,0x78,0x61,0x6d,0x70,0x6c,0x65,0x2c,0x20,0x74,0x68,0x69, /*  an example, thi */ \
	0x73,0x20,0x50,0x4f,0x53,0x54,0x20,0x66,0x6f,0x72,0x6d,0x20,0x73,0x65,0x74,0x73, /* s POST form sets */ \
	0x20,0x74,0x68,0x65,0x20,0x74,0x65,0x78,0x74,0x20,0x73,0x68,0x6f,0x77,0x6e,0x20, /*  the text shown  */ \
	0x6f,0x6e,0x20,0x74,0x68,0x65,0x20,0x4c,0x43,0x44,0x20,0x64,0x69,0x73,0x70,0x6c, /* on the LCD displ */ \
	0x61,0x79,0x3a,0x3c,0x2f,0x70,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x66,0x6f,0x72,0x6d, /* ay:</p>....<form */ \
	0x20,0x6d,0x65,0x74,0x68,0x6f,0x64,0x3d,0x22,0x70,0x6f,0x73,0x74,0x22,0x20,0x61, /*  method="post" a */ \
	0x63,0x74,0x69,0x6f,0x6e,0x3d,0x22,0x66,0x6f,0x72,0x6d,0x73,0x2e,0x68,0x74,0x6d, /* ction="forms.htm */ \
	0x22,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22, /* ">..<div class=" */ \
	0x65,0x78,0x61,0x6d,0x70,0x6c,0x65,0x62,0x6f,0x78,0x22,0x3e,0x0d,0x0a,0x3c,0x62, /* examplebox">..<b */ \
	0x3e,0x4c,0x43,0x44,0x3a,0x3c,0x2f,0x62,0x3e,0x20,0x3c,0x69,0x6e,0x70,0x75,0x74, /* >LCD:</b> <input */ \
	0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x22,0x20,0x6e,0x61,0x6d, /*  type="text" nam */ \
	0x65,0x3d,0x22,0x6c,0x63,0x64,0x22,0x20,0x6d,0x61,0x78,0x6c,0x65,0x6e,0x67,0x74, /* e="lcd" maxlengt */ \
	0x68,0x3d,0x22,0x33,0x32,0x22,0x3e,0x20,0x26,0x6e,0x62,0x73,0x70,0x3b,0x20,0x3c  /* h="32"> &nbsp; < */
#define DATACHUNK00000a \
	0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x73,0x75,0x62,0x6d, /* input type="subm */ \
	0x69,0x74,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x53,0x61,0x76,0x65,0x22, /* it" value="Save" */ \
	0x3e,0x0d,0x0a,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x2f,0x66,0x6f,0x72, /* >..</div>..</for */ \
	0x6d,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x0d,0x0a, /* m>....</div>.... */ \
	0x3c,0x73,0x63,0x72,0x69,0x70,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65, /* <script type="te */ \
	0x78,0x74,0x2f,0x6a,0x61,0x76,0x61,0x73,0x63,0x72,0x69,0x70,0x74,0x22,0x3e,0x0d, /* xt/javascript">. */ \
	0x0a,0x3c,0x21,0x2d,0x2d,0x0d,0x0a,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e, /* .<!--..document. */ \
	0x67,0x65,0x74,0x45,0x6c,0x65,0x6d,0x65,0x6e,0x74,0x42,0x79,0x49,0x64,0x28,0x27, /* getElementById(' */ \
	0x68,0x65,0x6c,0x6c,0x6f,0x27,0x29,0x2e,0x69,0x6e,0x6e,0x65,0x72,0x48,0x54,0x4d, /* hello').innerHTM */ \
	0x4c,0x20,0x3d,0x20,0x22,0x7e,0x68,0x65,0x6c,0x6c,0x6f,0x6d,0x73,0x67,0x7e,0x22, /* L = "~hellomsg~" */ \
	0x3b,0x0d,0x0a,0x2d,0x2d,0x3e,0x0d,0x0a,0x3c,0x2f,0x73,0x63,0x72,0x69,0x70,0x74, /* ;..-->..</script */ \
	0x3e,0x0d,0x0a,0x7e,0x69,0x6e,0x63,0x3a,0x66,0x6f,0x6f,0x74,0x65,0x72,0x2e,0x69, /* >..~inc:footer.i */ \
	0x6e,0x63,0x7e,0x00,0x00,0x00,0x00,0x33,0x00,0x00,0x00,0x61,0x04,0x00,0x00,0x0e, /* nc~....3...a.... */ \
	0x00,0x00,0x00,0x94,0x04,0x00,0x00,0x0f,0x00,0x00,0x00,0xf9,0x04,0x00,0x00,0x10, /* ................ */ \
	0x00,0x00,0x00,0x2c,0x05,0x00,0x00,0x11,0x00,0x00,0x00,0x91,0x05,0x00,0x00,0x12, /* ...,............ */ \
	0x00,0x00,0x00,0xc4,0x05,0x00,0x00,0x13,0x00,0x00,0x00,0x29,0x06,0x00,0x00,0x14, /* ...........).... */ \
	0x00,0x00,0x00,0x5c,0x06,0x00,0x00,0x15,0x00,0x00,0x00,0xda,0x09,0x00,0x00,0x01, /* ...\............ */ \
	0x00,0x00,0x00,0xf8,0x09,0x00,0x00,0x02,0x00,0x00,0x00,0x3c,0x21,0x44,0x4f,0x43, /* ...........<!DOC */ \
	0x54,0x59,0x50,0x45,0x20,0x68,0x74,0x6d,0x6c,0x20,0x50,0x55,0x42,0x4c,0x49,0x43, /* TYPE html PUBLIC */ \
	0x20,0x22,0x2d,0x2f,0x2f,0x57,0x33,0x43,0x2f,0x2f,0x44,0x54,0x44,0x20,0x58,0x48, /*  "-//W3C//DTD XH */ \
	0x54,0x4d,0x4c,0x20,0x31,0x2e,0x30,0x20,0x53,0x74,0x72,0x69,0x63,0x74,0x2f,0x2f, /* TML 1.0 Strict// */ \
	0x45,0x4e,0x22,0x0d,0x0a,0x20,0x20,0x22,0x68,0x74,0x74,0x70,0x3a,0x2f,0x2f,0x77, /* EN"..  "http://w */ \
	0x77,0x77,0x2e,0x77,0x33,0x2e,0x6f,0x72,0x67,0x2f,0x54,0x52,0x2f,0x78,0x68,0x74, /* ww.w3.org/TR/xht */ \
	0x6d,0x6c,0x31,0x2f,0x44,0x54,0x44,0x2f,0x78,0x68,0x74,0x6d,0x6c,0x31,0x2d,0x73, /* ml1/DTD/xhtml1-s */ \
	0x74,0x72,0x69,0x63,0x74,0x2e,0x64,0x74,0x64,0x22,0x3e,0x0d,0x0a,0x3c,0x68,0x74, /* trict.dtd">..<ht */ \
	0x6d,0x6c,0x20,0x78,0x6d,0x6c,0x6e,0x73,0x3d,0x22,0x68,0x74,0x74,0x70,0x3a,0x2f, /* ml xmlns="http:/ */ \
	0x2f,0x77,0x77,0x77,0x2e,0x77,0x33,0x2e,0x6f,0x72,0x67,0x2f,0x31,0x39,0x39,0x39, /* /www.w3.org/1999 */ \
	0x2f,0x78,0x68,0x74,0x6d,0x6c,0x22,0x20,0x78,0x6d,0x6c,0x3a,0x6c,0x61,0x6e,0x67, /* /xhtml" xml:lang */ \
	0x3d,0x22,0x65,0x6e,0x22,0x20,0x6c,0x61,0x6e,0x67,0x3d,0x22,0x65,0x6e,0x22,0x3e, /* ="en" lang="en"> */ \
	0x0d,0x0a,0x3c,0x68,0x65,0x61,0x64,0x3e,0x0d,0x0a,0x3c,0x74,0x69,0x74,0x6c,0x65, /* ..<head>..<title */ \
	0x3e,0x4d,0x69,0x63,0x72,0x6f,0x63,0x68,0x69,0x70,0x20,0x54,0x43,0x50,0x2f,0x49, /* >Microchip TCP/I */ \
	0x50,0x20,0x53,0x74,0x61,0x63,0x6b,0x20,0x44,0x65,0x6d,0x6f,0x20,0x41,0x70,0x70, /* P Stack Demo App */ \
	0x3c,0x2f,0x74,0x69,0x74,0x6c,0x65,0x3e,0x0d,0x0a,0x3c,0x6c,0x69,0x6e,0x6b,0x20, /* </title>..<link  */ \
	0x68,0x72,0x65,0x66,0x3d,0x22,0x2f,0x6d,0x63,0x68,0x70,0x2e,0x63,0x73,0x73,0x22, /* href="/mchp.css" */ \
	0x20,0x72,0x65,0x6c,0x3d,0x22,0x73,0x74,0x79,0x6c,0x65,0x73,0x68,0x65,0x65,0x74, /*  rel="stylesheet */ \
	0x22,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x2f,0x63,0x73,0x73, /* " type="text/css */ \
	0x22,0x20,0x2f,0x3e,0x0d,0x0a,0x3c,0x73,0x63,0x72,0x69,0x70,0x74,0x20,0x73,0x72, /* " />..<script sr */ \
	0x63,0x3d,0x22,0x2f,0x6d,0x63,0x68,0x70,0x2e,0x6a,0x73,0x22,0x20,0x74,0x79,0x70, /* c="/mchp.js" typ */ \
	0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x2f,0x6a,0x61,0x76,0x61,0x73,0x63,0x72,0x69, /* e="text/javascri */ \
	0x70,0x74,0x22,0x3e,0x3c,0x2f,0x73,0x63,0x72,0x69,0x70,0x74,0x3e,0x0d,0x0a,0x3c, /* pt"></script>..< */ \
	0x2f,0x68,0x65,0x61,0x64,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x62,0x6f,0x64,0x79,0x3e, /* /head>....<body> */ \
	0x0d,0x0a,0x3c,0x64,0x69,0x76,0x20,0x69,0x64,0x3d,0x22,0x73,0x68,0x61,0x64,0x6f, /* ..<div id="shado */ \
	0x77,0x2d,0x6f,0x6e,0x65,0x22,0x3e,0x3c,0x64,0x69,0x76,0x20,0x69,0x64,0x3d,0x22, /* w-one"><div id=" */ \
	0x73,0x68,0x61,0x64,0x6f,0x77,0x2d,0x74,0x77,0x6f,0x22,0x3e,0x3c,0x64,0x69,0x76, /* shadow-two"><div */ \
	0x20,0x69,0x64,0x3d,0x22,0x73,0x68,0x61,0x64,0x6f,0x77,0x2d,0x74,0x68,0x72,0x65, /*  id="shadow-thre */ \
	0x65,0x22,0x3e,0x3c,0x64,0x69,0x76,0x20,0x69,0x64,0x3d,0x22,0x73,0x68,0x61,0x64, /* e"><div id="shad */ \
	0x6f,0x77,0x2d,0x66,0x6f,0x75,0x72,0x22,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x20, /* ow-four">..<div  */ \
	0x69,0x64,0x3d,0x22,0x70,0x61,0x67,0x65,0x22,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x64, /* id="page">....<d */ \
	0x69,0x76,0x20,0x73,0x74,0x79,0x6c,0x65,0x3d,0x22,0x70,0x61,0x64,0x64,0x69,0x6e, /* iv style="paddin */ \
	0x67,0x3a,0x30,0x20,0x30,0x20,0x35,0x70,0x78,0x20,0x35,0x70,0x78,0x22,0x3e,0x3c, /* g:0 0 5px 5px">< */ \
	0x69,0x6d,0x67,0x20,0x73,0x72,0x63,0x3d,0x22,0x2f,0x6d,0x63,0x68,0x70,0x2e,0x67, /* img src="/mchp.g */ \
	0x69,0x66,0x22,0x20,0x61,0x6c,0x74,0x3d,0x22,0x4d,0x69,0x63,0x72,0x6f,0x63,0x68, /* if" alt="Microch */ \
	0x69,0x70,0x22,0x20,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x0d,0x0a, /* ip" /></div>.... */ \
	0x3c,0x64,0x69,0x76,0x20,0x69,0x64,0x3d,0x22,0x74,0x69,0x74,0x6c,0x65,0x22,0x3e, /* <div id="title"> */ \
	0x3c,0x64,0x69,0x76,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x72,0x69,0x67,0x68, /* <div class="righ */ \
	0x74,0x22,0x3e,0x54,0x43,0x50,0x2f,0x49,0x50,0x20,0x53,0x74,0x61,0x63,0x6b,0x20, /* t">TCP/IP Stack  */ \
	0x44,0x65,0x6d,0x6f,0x20,0x41,0x70,0x70,0x6c,0x69,0x63,0x61,0x74,0x69,0x6f,0x6e, /* Demo Application */ \
	0x3c,0x2f,0x64,0x69,0x76,0x3e,0x3c,0x73,0x70,0x61,0x6e,0x20,0x69,0x64,0x3d,0x22, /* </div><span id=" */ \
	0x68,0x65,0x6c,0x6c,0x6f,0x22,0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x3c,0x2f,0x73, /* hello">&nbsp;</s */ \
	0x70,0x61,0x6e,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x64, /* pan></div>....<d */ \
	0x69,0x76,0x20,0x69,0x64,0x3d,0x22,0x6d,0x65,0x6e,0x75,0x22,0x3e,0x0d,0x0a,0x3c, /* iv id="menu">..< */ \
	0x61,0x20,0x68,0x72,0x65,0x66,0x3d,0x22,0x2f,0x69,0x6e,0x64,0x65,0x78,0x2e,0x68, /* a href="/index.h */ \
	0x74,0x6d,0x22,0x3e,0x4f,0x76,0x65,0x72,0x76,0x69,0x65,0x77,0x3c,0x2f,0x61,0x3e, /* tm">Overview</a> */ \
	0x0d,0x0a,0x3c,0x61,0x20,0x68,0x72,0x65,0x66,0x3d,0x22,0x2f,0x64,0x79,0x6e,0x76  /* ..<a href="/dynv */
#define DATACHUNK00000b \
	0x61,0x72,0x73,0x2e,0x68,0x74,0x6d,0x22,0x3e,0x44,0x79,0x6e,0x61,0x6d,0x69,0x63, /* ars.htm">Dynamic */ \
	0x20,0x56,0x61,0x72,0x69,0x61,0x62,0x6c,0x65,0x73,0x3c,0x2f,0x61,0x3e,0x0d,0x0a, /*  Variables</a>.. */ \
	0x3c,0x61,0x20,0x68,0x72,0x65,0x66,0x3d,0x22,0x2f,0x66,0x6f,0x72,0x6d,0x73,0x2e, /* <a href="/forms. */ \
	0x68,0x74,0x6d,0x22,0x3e,0x46,0x6f,0x72,0x6d,0x20,0x50,0x72,0x6f,0x63,0x65,0x73, /* htm">Form Proces */ \
	0x73,0x69,0x6e,0x67,0x3c,0x2f,0x61,0x3e,0x0d,0x0a,0x3c,0x61,0x20,0x68,0x72,0x65, /* sing</a>..<a hre */ \
	0x66,0x3d,0x22,0x2f,0x61,0x75,0x74,0x68,0x2e,0x68,0x74,0x6d,0x22,0x3e,0x41,0x75, /* f="/auth.htm">Au */ \
	0x74,0x68,0x65,0x6e,0x74,0x69,0x63,0x61,0x74,0x69,0x6f,0x6e,0x3c,0x2f,0x61,0x3e, /* thentication</a> */ \
	0x0d,0x0a,0x3c,0x61,0x20,0x68,0x72,0x65,0x66,0x3d,0x22,0x2f,0x63,0x6f,0x6f,0x6b, /* ..<a href="/cook */ \
	0x69,0x65,0x73,0x2e,0x68,0x74,0x6d,0x22,0x3e,0x43,0x6f,0x6f,0x6b,0x69,0x65,0x73, /* ies.htm">Cookies */ \
	0x3c,0x2f,0x61,0x3e,0x0d,0x0a,0x3c,0x61,0x20,0x68,0x72,0x65,0x66,0x3d,0x22,0x2f, /* </a>..<a href="/ */ \
	0x75,0x70,0x6c,0x6f,0x61,0x64,0x2e,0x68,0x74,0x6d,0x22,0x3e,0x46,0x69,0x6c,0x65, /* upload.htm">File */ \
	0x20,0x55,0x70,0x6c,0x6f,0x61,0x64,0x73,0x3c,0x2f,0x61,0x3e,0x0d,0x0a,0x3c,0x61, /*  Uploads</a>..<a */ \
	0x20,0x68,0x72,0x65,0x66,0x3d,0x22,0x2f,0x65,0x6d,0x61,0x69,0x6c,0x22,0x3e,0x53, /*  href="/email">S */ \
	0x65,0x6e,0x64,0x20,0x45,0x2d,0x6d,0x61,0x69,0x6c,0x3c,0x2f,0x61,0x3e,0x0d,0x0a, /* end E-mail</a>.. */ \
	0x3c,0x61,0x20,0x68,0x72,0x65,0x66,0x3d,0x22,0x2f,0x64,0x79,0x6e,0x64,0x6e,0x73, /* <a href="/dyndns */ \
	0x22,0x3e,0x44,0x79,0x6e,0x61,0x6d,0x69,0x63,0x20,0x44,0x4e,0x53,0x3c,0x2f,0x61, /* ">Dynamic DNS</a */ \
	0x3e,0x0d,0x0a,0x3c,0x61,0x20,0x68,0x72,0x65,0x66,0x3d,0x22,0x2f,0x70,0x72,0x6f, /* >..<a href="/pro */ \
	0x74,0x65,0x63,0x74,0x2f,0x63,0x6f,0x6e,0x66,0x69,0x67,0x2e,0x68,0x74,0x6d,0x22, /* tect/config.htm" */ \
	0x3e,0x4e,0x65,0x74,0x77,0x6f,0x72,0x6b,0x20,0x43,0x6f,0x6e,0x66,0x69,0x67,0x75, /* >Network Configu */ \
	0x72,0x61,0x74,0x69,0x6f,0x6e,0x3c,0x2f,0x61,0x3e,0x0d,0x0a,0x3c,0x61,0x20,0x68, /* ration</a>..<a h */ \
	0x72,0x65,0x66,0x3d,0x22,0x2f,0x73,0x6e,0x6d,0x70,0x2f,0x73,0x6e,0x6d,0x70,0x63, /* ref="/snmp/snmpc */ \
	0x6f,0x6e,0x66,0x69,0x67,0x2e,0x68,0x74,0x6d,0x22,0x3e,0x53,0x4e,0x4d,0x50,0x20, /* onfig.htm">SNMP  */ \
	0x43,0x6f,0x6e,0x66,0x69,0x67,0x75,0x72,0x61,0x74,0x69,0x6f,0x6e,0x3c,0x2f,0x61, /* Configuration</a */ \
	0x3e,0x0d,0x0a,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x7e,0x69,0x6e,0x63,0x3a,0x68,0x65, /* >..</div>~inc:he */ \
	0x61,0x64,0x65,0x72,0x2e,0x69,0x6e,0x63,0x7e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x20, /* ader.inc~..<div  */ \
	0x69,0x64,0x3d,0x22,0x63,0x6f,0x6e,0x74,0x65,0x6e,0x74,0x22,0x3e,0x0d,0x0a,0x0d, /* id="content">... */ \
	0x0a,0x3c,0x64,0x69,0x76,0x20,0x69,0x64,0x3d,0x22,0x73,0x74,0x61,0x74,0x75,0x73, /* .<div id="status */ \
	0x22,0x3e,0x0d,0x0a,0x09,0x3c,0x64,0x69,0x76,0x20,0x69,0x64,0x3d,0x22,0x6c,0x6f, /* ">...<div id="lo */ \
	0x61,0x64,0x69,0x6e,0x67,0x22,0x20,0x73,0x74,0x79,0x6c,0x65,0x3d,0x22,0x64,0x69, /* ading" style="di */ \
	0x73,0x70,0x6c,0x61,0x79,0x3a,0x6e,0x6f,0x6e,0x65,0x22,0x3e,0x45,0x72,0x72,0x6f, /* splay:none">Erro */ \
	0x72,0x3a,0x3c,0x62,0x72,0x20,0x2f,0x3e,0x43,0x6f,0x6e,0x6e,0x65,0x63,0x74,0x69, /* r:<br />Connecti */ \
	0x6f,0x6e,0x20,0x74,0x6f,0x20,0x64,0x65,0x6d,0x6f,0x20,0x62,0x6f,0x61,0x72,0x64, /* on to demo board */ \
	0x20,0x77,0x61,0x73,0x20,0x6c,0x6f,0x73,0x74,0x2e,0x3c,0x2f,0x64,0x69,0x76,0x3e, /*  was lost.</div> */ \
	0x0d,0x0a,0x09,0x3c,0x64,0x69,0x76,0x20,0x69,0x64,0x3d,0x22,0x64,0x69,0x73,0x70, /* ...<div id="disp */ \
	0x6c,0x61,0x79,0x22,0x3e,0x0d,0x0a,0x09,0x09,0x3c,0x73,0x70,0x61,0x6e,0x20,0x73, /* lay">....<span s */ \
	0x74,0x79,0x6c,0x65,0x3d,0x22,0x66,0x6c,0x6f,0x61,0x74,0x3a,0x72,0x69,0x67,0x68, /* tyle="float:righ */ \
	0x74,0x3b,0x66,0x6f,0x6e,0x74,0x2d,0x73,0x69,0x7a,0x65,0x3a,0x39,0x70,0x78,0x3b, /* t;font-size:9px; */ \
	0x66,0x6f,0x6e,0x74,0x2d,0x77,0x65,0x69,0x67,0x68,0x74,0x3a,0x6e,0x6f,0x72,0x6d, /* font-weight:norm */ \
	0x61,0x6c,0x3b,0x70,0x61,0x64,0x64,0x69,0x6e,0x67,0x2d,0x74,0x6f,0x70,0x3a,0x38, /* al;padding-top:8 */ \
	0x70,0x78,0x3b,0x74,0x65,0x78,0x74,0x2d,0x69,0x6e,0x64,0x65,0x6e,0x74,0x3a,0x30, /* px;text-indent:0 */ \
	0x70,0x78,0x22,0x3e,0x28,0x63,0x6c,0x69,0x63,0x6b,0x20,0x74,0x6f,0x20,0x74,0x6f, /* px">(click to to */ \
	0x67,0x67,0x6c,0x65,0x29,0x3c,0x2f,0x73,0x70,0x61,0x6e,0x3e,0x0d,0x0a,0x09,0x09, /* ggle)</span>.... */ \
	0x3c,0x70,0x3e,0x4c,0x45,0x44,0x73,0x3a,0x3c,0x62,0x72,0x20,0x2f,0x3e,0x3c,0x73, /* <p>LEDs:<br /><s */ \
	0x70,0x61,0x6e,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x6c,0x65,0x64,0x73,0x22, /* pan class="leds" */ \
	0x3e,0x0d,0x0a,0x09,0x09,0x3c,0x61,0x20,0x69,0x64,0x3d,0x22,0x6c,0x65,0x64,0x37, /* >....<a id="led7 */ \
	0x22,0x20,0x6f,0x6e,0x63,0x6c,0x69,0x63,0x6b,0x3d,0x22,0x6e,0x65,0x77,0x41,0x4a, /* " onclick="newAJ */ \
	0x41,0x58,0x43,0x6f,0x6d,0x6d,0x61,0x6e,0x64,0x28,0x27,0x6c,0x65,0x64,0x73,0x2e, /* AXCommand('leds. */ \
	0x63,0x67,0x69,0x3f,0x6c,0x65,0x64,0x3d,0x37,0x27,0x29,0x3b,0x22,0x3e,0x26,0x62, /* cgi?led=7');">&b */ \
	0x75,0x6c,0x6c,0x3b,0x3c,0x2f,0x61,0x3e,0x0d,0x0a,0x09,0x09,0x3c,0x61,0x20,0x69, /* ull;</a>....<a i */ \
	0x64,0x3d,0x22,0x6c,0x65,0x64,0x36,0x22,0x20,0x6f,0x6e,0x63,0x6c,0x69,0x63,0x6b, /* d="led6" onclick */ \
	0x3d,0x22,0x6e,0x65,0x77,0x41,0x4a,0x41,0x58,0x43,0x6f,0x6d,0x6d,0x61,0x6e,0x64, /* ="newAJAXCommand */ \
	0x28,0x27,0x6c,0x65,0x64,0x73,0x2e,0x63,0x67,0x69,0x3f,0x6c,0x65,0x64,0x3d,0x36, /* ('leds.cgi?led=6 */ \
	0x27,0x29,0x3b,0x22,0x3e,0x26,0x62,0x75,0x6c,0x6c,0x3b,0x3c,0x2f,0x61,0x3e,0x0d, /* ');">&bull;</a>. */ \
	0x0a,0x09,0x09,0x3c,0x61,0x20,0x69,0x64,0x3d,0x22,0x6c,0x65,0x64,0x35,0x22,0x20, /* ...<a id="led5"  */ \
	0x6f,0x6e,0x63,0x6c,0x69,0x63,0x6b,0x3d,0x22,0x6e,0x65,0x77,0x41,0x4a,0x41,0x58, /* onclick="newAJAX */ \
	0x43,0x6f,0x6d,0x6d,0x61,0x6e,0x64,0x28,0x27,0x6c,0x65,0x64,0x73,0x2e,0x63,0x67, /* Command('leds.cg */ \
	0x69,0x3f,0x6c,0x65,0x64,0x3d,0x35,0x27,0x29,0x3b,0x22,0x3e,0x26,0x62,0x75,0x6c, /* i?led=5');">&bul */ \
	0x6c,0x3b,0x3c,0x2f,0x61,0x3e,0x0d,0x0a,0x09,0x09,0x3c,0x61,0x20,0x69,0x64,0x3d, /* l;</a>....<a id= */ \
	0x22,0x6c,0x65,0x64,0x34,0x22,0x20,0x6f,0x6e,0x63,0x6c,0x69,0x63,0x6b,0x3d,0x22, /* "led4" onclick=" */ \
	0x6e,0x65,0x77,0x41,0x4a,0x41,0x58,0x43,0x6f,0x6d,0x6d,0x61,0x6e,0x64,0x28,0x27, /* newAJAXCommand(' */ \
	0x6c,0x65,0x64,0x73,0x2e,0x63,0x67,0x69,0x3f,0x6c,0x65,0x64,0x3d,0x34,0x27,0x29, /* leds.cgi?led=4') */ \
	0x3b,0x22,0x3e,0x26,0x62,0x75,0x6c,0x6c,0x3b,0x3c,0x2f,0x61,0x3e,0x0d,0x0a,0x09, /* ;">&bull;</a>... */ \
	0x09,0x3c,0x61,0x20,0x69,0x64,0x3d,0x22,0x6c,0x65,0x64,0x33,0x22,0x20,0x6f,0x6e, /* .<a id="led3" on */ \
	0x63,0x6c,0x69,0x63,0x6b,0x3d,0x22,0x6e,0x65,0x77,0x41,0x4a,0x41,0x58,0x43,0x6f  /* click="newAJAXCo */
#define DATACHUNK00000c \
	0x6d,0x6d,0x61,0x6e,0x64,0x28,0x27,0x6c,0x65,0x64,0x73,0x2e,0x63,0x67,0x69,0x3f, /* mmand('leds.cgi? */ \
	0x6c,0x65,0x64,0x3d,0x33,0x27,0x29,0x3b,0x22,0x3e,0x26,0x62,0x75,0x6c,0x6c,0x3b, /* led=3');">&bull; */ \
	0x3c,0x2f,0x61,0x3e,0x0d,0x0a,0x09,0x09,0x3c,0x61,0x20,0x69,0x64,0x3d,0x22,0x6c, /* </a>....<a id="l */ \
	0x65,0x64,0x32,0x22,0x20,0x6f,0x6e,0x63,0x6c,0x69,0x63,0x6b,0x3d,0x22,0x6e,0x65, /* ed2" onclick="ne */ \
	0x77,0x41,0x4a,0x41,0x58,0x43,0x6f,0x6d,0x6d,0x61,0x6e,0x64,0x28,0x27,0x6c,0x65, /* wAJAXCommand('le */ \
	0x64,0x73,0x2e,0x63,0x67,0x69,0x3f,0x6c,0x65,0x64,0x3d,0x32,0x27,0x29,0x3b,0x22, /* ds.cgi?led=2');" */ \
	0x3e,0x26,0x62,0x75,0x6c,0x6c,0x3b,0x3c,0x2f,0x61,0x3e,0x0d,0x0a,0x09,0x09,0x3c, /* >&bull;</a>....< */ \
	0x61,0x20,0x69,0x64,0x3d,0x22,0x6c,0x65,0x64,0x31,0x22,0x20,0x6f,0x6e,0x63,0x6c, /* a id="led1" oncl */ \
	0x69,0x63,0x6b,0x3d,0x22,0x6e,0x65,0x77,0x41,0x4a,0x41,0x58,0x43,0x6f,0x6d,0x6d, /* ick="newAJAXComm */ \
	0x61,0x6e,0x64,0x28,0x27,0x6c,0x65,0x64,0x73,0x2e,0x63,0x67,0x69,0x3f,0x6c,0x65, /* and('leds.cgi?le */ \
	0x64,0x3d,0x31,0x27,0x29,0x3b,0x22,0x3e,0x26,0x62,0x75,0x6c,0x6c,0x3b,0x3c,0x2f, /* d=1');">&bull;</ */ \
	0x61,0x3e,0x0d,0x0a,0x09,0x09,0x3c,0x61,0x20,0x69,0x64,0x3d,0x22,0x6c,0x65,0x64, /* a>....<a id="led */ \
	0x30,0x22,0x3e,0x26,0x62,0x75,0x6c,0x6c,0x3b,0x3c,0x2f,0x61,0x3e,0x0d,0x0a,0x09, /* 0">&bull;</a>... */ \
	0x09,0x3c,0x2f,0x73,0x70,0x61,0x6e,0x3e,0x3c,0x2f,0x70,0x3e,0x0d,0x0a,0x09,0x09, /* .</span></p>.... */ \
	0x3c,0x70,0x3e,0x42,0x75,0x74,0x74,0x6f,0x6e,0x73,0x3a,0x3c,0x62,0x72,0x20,0x2f, /* <p>Buttons:<br / */ \
	0x3e,0x0d,0x0a,0x09,0x09,0x3c,0x73,0x70,0x61,0x6e,0x20,0x69,0x64,0x3d,0x22,0x62, /* >....<span id="b */ \
	0x74,0x6e,0x33,0x22,0x3e,0x3f,0x3c,0x2f,0x73,0x70,0x61,0x6e,0x3e,0x20,0x26,0x6e, /* tn3">?</span> &n */ \
	0x62,0x73,0x70,0x3b,0x20,0x0d,0x0a,0x09,0x09,0x3c,0x73,0x70,0x61,0x6e,0x20,0x69, /* bsp; ....<span i */ \
	0x64,0x3d,0x22,0x62,0x74,0x6e,0x32,0x22,0x3e,0x3f,0x3c,0x2f,0x73,0x70,0x61,0x6e, /* d="btn2">?</span */ \
	0x3e,0x20,0x26,0x6e,0x62,0x73,0x70,0x3b,0x20,0x0d,0x0a,0x09,0x09,0x3c,0x73,0x70, /* > &nbsp; ....<sp */ \
	0x61,0x6e,0x20,0x69,0x64,0x3d,0x22,0x62,0x74,0x6e,0x31,0x22,0x3e,0x3f,0x3c,0x2f, /* an id="btn1">?</ */ \
	0x73,0x70,0x61,0x6e,0x3e,0x20,0x26,0x6e,0x62,0x73,0x70,0x3b,0x20,0x0d,0x0a,0x09, /* span> &nbsp; ... */ \
	0x09,0x3c,0x73,0x70,0x61,0x6e,0x20,0x69,0x64,0x3d,0x22,0x62,0x74,0x6e,0x30,0x22, /* .<span id="btn0" */ \
	0x3e,0x3f,0x3c,0x2f,0x73,0x70,0x61,0x6e,0x3e,0x3c,0x2f,0x70,0x3e,0x0d,0x0a,0x09, /* >?</span></p>... */ \
	0x09,0x3c,0x70,0x3e,0x50,0x6f,0x74,0x65,0x6e,0x74,0x69,0x6f,0x6d,0x65,0x74,0x65, /* .<p>Potentiomete */ \
	0x72,0x3a,0x20,0x3c,0x73,0x70,0x61,0x6e,0x20,0x69,0x64,0x3d,0x22,0x70,0x6f,0x74, /* r: <span id="pot */ \
	0x30,0x22,0x20,0x73,0x74,0x79,0x6c,0x65,0x3d,0x22,0x66,0x6f,0x6e,0x74,0x2d,0x77, /* 0" style="font-w */ \
	0x65,0x69,0x67,0x68,0x74,0x3a,0x6e,0x6f,0x72,0x6d,0x61,0x6c,0x22,0x3e,0x3f,0x3c, /* eight:normal">?< */ \
	0x2f,0x73,0x70,0x61,0x6e,0x3e,0x3c,0x2f,0x70,0x3e,0x0d,0x0a,0x09,0x3c,0x2f,0x64, /* /span></p>...</d */ \
	0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c, /* iv>..</div>....< */ \
	0x68,0x31,0x3e,0x57,0x65,0x6c,0x63,0x6f,0x6d,0x65,0x21,0x3c,0x2f,0x68,0x31,0x3e, /* h1>Welcome!</h1> */ \
	0x0d,0x0a,0x0d,0x0a,0x3c,0x74,0x61,0x62,0x6c,0x65,0x20,0x73,0x74,0x79,0x6c,0x65, /* ....<table style */ \
	0x3d,0x22,0x70,0x61,0x64,0x64,0x69,0x6e,0x67,0x2d,0x6c,0x65,0x66,0x74,0x3a,0x20, /* ="padding-left:  */ \
	0x31,0x30,0x70,0x78,0x3b,0x22,0x3e,0x0d,0x0a,0x3c,0x74,0x72,0x3e,0x3c,0x74,0x64, /* 10px;">..<tr><td */ \
	0x3e,0x3c,0x62,0x3e,0x53,0x74,0x61,0x63,0x6b,0x20,0x56,0x65,0x72,0x73,0x69,0x6f, /* ><b>Stack Versio */ \
	0x6e,0x3a,0x3c,0x2f,0x62,0x3e,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x74,0x64,0x3e,0x26, /* n:</b></td><td>& */ \
	0x6e,0x62,0x73,0x70,0x3b,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x74,0x64,0x3e,0x7e,0x76, /* nbsp;</td><td>~v */ \
	0x65,0x72,0x73,0x69,0x6f,0x6e,0x7e,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x2f,0x74,0x72, /* ersion~</td></tr */ \
	0x3e,0x0d,0x0a,0x3c,0x74,0x72,0x3e,0x3c,0x74,0x64,0x3e,0x3c,0x62,0x3e,0x42,0x75, /* >..<tr><td><b>Bu */ \
	0x69,0x6c,0x64,0x20,0x44,0x61,0x74,0x65,0x3a,0x3c,0x2f,0x62,0x3e,0x3c,0x2f,0x74, /* ild Date:</b></t */ \
	0x64,0x3e,0x3c,0x74,0x64,0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x3c,0x2f,0x74,0x64, /* d><td>&nbsp;</td */ \
	0x3e,0x3c,0x74,0x64,0x3e,0x7e,0x62,0x75,0x69,0x6c,0x64,0x64,0x61,0x74,0x65,0x7e, /* ><td>~builddate~ */ \
	0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x2f,0x74,0x72,0x3e,0x0d,0x0a,0x3c,0x2f,0x74,0x61, /* </td></tr>..</ta */ \
	0x62,0x6c,0x65,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x70,0x3e,0x54,0x68,0x69,0x73,0x20, /* ble>....<p>This  */ \
	0x73,0x69,0x74,0x65,0x20,0x64,0x65,0x6d,0x6f,0x6e,0x73,0x74,0x72,0x61,0x74,0x65, /* site demonstrate */ \
	0x73,0x20,0x74,0x68,0x65,0x20,0x70,0x6f,0x77,0x65,0x72,0x2c,0x20,0x66,0x6c,0x65, /* s the power, fle */ \
	0x78,0x69,0x62,0x69,0x6c,0x69,0x74,0x79,0x2c,0x20,0x61,0x6e,0x64,0x20,0x73,0x63, /* xibility, and sc */ \
	0x61,0x6c,0x61,0x62,0x69,0x6c,0x69,0x74,0x79,0x20,0x6f,0x66,0x20,0x61,0x6e,0x20, /* alability of an  */ \
	0x38,0x2c,0x20,0x31,0x36,0x2c,0x20,0x6f,0x72,0x20,0x33,0x32,0x2d,0x62,0x69,0x74, /* 8, 16, or 32-bit */ \
	0x20,0x65,0x6d,0x62,0x65,0x64,0x64,0x65,0x64,0x0d,0x0a,0x77,0x65,0x62,0x20,0x73, /*  embedded..web s */ \
	0x65,0x72,0x76,0x65,0x72,0x2e,0x20,0x20,0x45,0x76,0x65,0x72,0x79,0x74,0x68,0x69, /* erver.  Everythi */ \
	0x6e,0x67,0x20,0x79,0x6f,0x75,0x20,0x73,0x65,0x65,0x20,0x69,0x73,0x20,0x70,0x6f, /* ng you see is po */ \
	0x77,0x65,0x72,0x65,0x64,0x20,0x62,0x79,0x20,0x61,0x20,0x4d,0x69,0x63,0x72,0x6f, /* wered by a Micro */ \
	0x63,0x68,0x69,0x70,0x20,0x50,0x49,0x43,0x20,0x6d,0x69,0x63,0x72,0x6f,0x63,0x6f, /* chip PIC microco */ \
	0x6e,0x74,0x72,0x6f,0x6c,0x6c,0x65,0x72,0x20,0x0d,0x0a,0x72,0x75,0x6e,0x6e,0x69, /* ntroller ..runni */ \
	0x6e,0x67,0x20,0x74,0x68,0x65,0x20,0x4d,0x69,0x63,0x72,0x6f,0x63,0x68,0x69,0x70, /* ng the Microchip */ \
	0x20,0x54,0x43,0x50,0x2f,0x49,0x50,0x20,0x53,0x74,0x61,0x63,0x6b,0x2e,0x3c,0x2f, /*  TCP/IP Stack.</ */ \
	0x70,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x70,0x3e,0x4f,0x6e,0x20,0x74,0x68,0x65,0x20, /* p>....<p>On the  */ \
	0x72,0x69,0x67,0x68,0x74,0x20,0x79,0x6f,0x75,0x27,0x6c,0x6c,0x20,0x73,0x65,0x65, /* right you'll see */ \
	0x20,0x74,0x68,0x65,0x20,0x63,0x75,0x72,0x72,0x65,0x6e,0x74,0x20,0x73,0x74,0x61, /*  the current sta */ \
	0x74,0x75,0x73,0x20,0x6f,0x66,0x20,0x74,0x68,0x65,0x20,0x64,0x65,0x6d,0x6f,0x20, /* tus of the demo  */ \
	0x62,0x6f,0x61,0x72,0x64,0x2e,0x20,0x20,0x46,0x6f,0x72,0x20,0x61,0x20,0x71,0x75, /* board.  For a qu */ \
	0x69,0x63,0x6b,0x20,0x0d,0x0a,0x65,0x78,0x61,0x6d,0x70,0x6c,0x65,0x2c,0x20,0x63, /* ick ..example, c */ \
	0x6c,0x69,0x63,0x6b,0x20,0x74,0x68,0x65,0x20,0x4c,0x45,0x44,0x73,0x20,0x74,0x6f  /* lick the LEDs to */
#define DATACHUNK00000d \
	0x20,0x74,0x6f,0x67,0x67,0x6c,0x65,0x20,0x74,0x68,0x65,0x20,0x6c,0x69,0x67,0x68, /*  toggle the ligh */ \
	0x74,0x73,0x20,0x6f,0x6e,0x20,0x74,0x68,0x65,0x20,0x62,0x6f,0x61,0x72,0x64,0x2e, /* ts on the board. */ \
	0x20,0x20,0x50,0x72,0x65,0x73,0x73,0x20,0x74,0x68,0x65,0x20,0x70,0x75,0x73,0x68, /*   Press the push */ \
	0x20,0x0d,0x0a,0x62,0x75,0x74,0x74,0x6f,0x6e,0x73,0x20,0x28,0x65,0x78,0x63,0x65, /*  ..buttons (exce */ \
	0x70,0x74,0x20,0x4d,0x43,0x4c,0x52,0x21,0x29,0x20,0x6f,0x72,0x20,0x74,0x75,0x72, /* pt MCLR!) or tur */ \
	0x6e,0x20,0x74,0x68,0x65,0x20,0x70,0x6f,0x74,0x65,0x6e,0x74,0x69,0x6f,0x6d,0x65, /* n the potentiome */ \
	0x74,0x65,0x72,0x20,0x61,0x6e,0x64,0x20,0x79,0x6f,0x75,0x27,0x6c,0x6c,0x20,0x73, /* ter and you'll s */ \
	0x65,0x65,0x20,0x74,0x68,0x65,0x20,0x73,0x74,0x61,0x74,0x75,0x73,0x20,0x0d,0x0a, /* ee the status .. */ \
	0x75,0x70,0x64,0x61,0x74,0x65,0x20,0x69,0x6d,0x6d,0x65,0x64,0x69,0x61,0x74,0x65, /* update immediate */ \
	0x6c,0x79,0x2e,0x20,0x20,0x54,0x68,0x69,0x73,0x20,0x65,0x78,0x61,0x6d,0x70,0x6c, /* ly.  This exampl */ \
	0x65,0x73,0x20,0x75,0x73,0x65,0x73,0x20,0x41,0x4a,0x41,0x58,0x20,0x74,0x65,0x63, /* es uses AJAX tec */ \
	0x68,0x6e,0x69,0x71,0x75,0x65,0x73,0x20,0x74,0x6f,0x20,0x70,0x72,0x6f,0x76,0x69, /* hniques to provi */ \
	0x64,0x65,0x20,0x72,0x65,0x61,0x6c,0x2d,0x74,0x69,0x6d,0x65,0x20,0x0d,0x0a,0x66, /* de real-time ..f */ \
	0x65,0x65,0x64,0x62,0x61,0x63,0x6b,0x2e,0x3c,0x2f,0x70,0x3e,0x0d,0x0a,0x0d,0x0a, /* eedback.</p>.... */ \
	0x3c,0x70,0x3e,0x54,0x68,0x69,0x73,0x20,0x73,0x69,0x74,0x65,0x20,0x69,0x73,0x20, /* <p>This site is  */ \
	0x70,0x72,0x6f,0x76,0x69,0x64,0x65,0x64,0x20,0x61,0x73,0x20,0x61,0x20,0x74,0x75, /* provided as a tu */ \
	0x74,0x6f,0x72,0x69,0x61,0x6c,0x20,0x66,0x6f,0x72,0x20,0x74,0x68,0x65,0x20,0x76, /* torial for the v */ \
	0x61,0x72,0x69,0x6f,0x75,0x73,0x20,0x66,0x65,0x61,0x74,0x75,0x72,0x65,0x73,0x20, /* arious features  */ \
	0x6f,0x66,0x20,0x74,0x68,0x65,0x20,0x48,0x54,0x54,0x50,0x0d,0x0a,0x77,0x65,0x62, /* of the HTTP..web */ \
	0x20,0x73,0x65,0x72,0x76,0x65,0x72,0x2c,0x20,0x69,0x6e,0x63,0x6c,0x75,0x64,0x69, /*  server, includi */ \
	0x6e,0x67,0x3a,0x3c,0x2f,0x70,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x75,0x6c,0x3e,0x0d, /* ng:</p>....<ul>. */ \
	0x0a,0x3c,0x6c,0x69,0x3e,0x3c,0x62,0x3e,0x44,0x79,0x6e,0x61,0x6d,0x69,0x63,0x20, /* .<li><b>Dynamic  */ \
	0x56,0x61,0x72,0x69,0x61,0x62,0x6c,0x65,0x20,0x53,0x75,0x62,0x73,0x74,0x69,0x74, /* Variable Substit */ \
	0x75,0x74,0x69,0x6f,0x6e,0x3c,0x2f,0x62,0x3e,0x20,0x2d,0x20,0x64,0x69,0x73,0x70, /* ution</b> - disp */ \
	0x6c,0x61,0x79,0x20,0x72,0x65,0x61,0x6c,0x2d,0x74,0x69,0x6d,0x65,0x20,0x64,0x61, /* lay real-time da */ \
	0x74,0x61,0x3c,0x2f,0x6c,0x69,0x3e,0x0d,0x0a,0x3c,0x6c,0x69,0x3e,0x3c,0x62,0x3e, /* ta</li>..<li><b> */ \
	0x46,0x6f,0x72,0x6d,0x20,0x50,0x72,0x6f,0x63,0x65,0x73,0x73,0x69,0x6e,0x67,0x3c, /* Form Processing< */ \
	0x2f,0x62,0x3e,0x20,0x2d,0x20,0x68,0x61,0x6e,0x64,0x6c,0x65,0x20,0x69,0x6e,0x70, /* /b> - handle inp */ \
	0x75,0x74,0x20,0x66,0x72,0x6f,0x6d,0x20,0x74,0x68,0x65,0x20,0x63,0x6c,0x69,0x65, /* ut from the clie */ \
	0x6e,0x74,0x3c,0x2f,0x6c,0x69,0x3e,0x0d,0x0a,0x3c,0x6c,0x69,0x3e,0x3c,0x62,0x3e, /* nt</li>..<li><b> */ \
	0x41,0x75,0x74,0x68,0x65,0x6e,0x74,0x69,0x63,0x61,0x74,0x69,0x6f,0x6e,0x3c,0x2f, /* Authentication</ */ \
	0x62,0x3e,0x20,0x2d,0x20,0x72,0x65,0x71,0x75,0x69,0x72,0x65,0x20,0x61,0x20,0x75, /* b> - require a u */ \
	0x73,0x65,0x72,0x20,0x6e,0x61,0x6d,0x65,0x20,0x61,0x6e,0x64,0x20,0x70,0x61,0x73, /* ser name and pas */ \
	0x73,0x77,0x6f,0x72,0x64,0x3c,0x2f,0x6c,0x69,0x3e,0x0d,0x0a,0x3c,0x6c,0x69,0x3e, /* sword</li>..<li> */ \
	0x3c,0x62,0x3e,0x43,0x6f,0x6f,0x6b,0x69,0x65,0x73,0x3c,0x2f,0x62,0x3e,0x20,0x2d, /* <b>Cookies</b> - */ \
	0x20,0x73,0x74,0x6f,0x72,0x65,0x20,0x73,0x65,0x73,0x73,0x69,0x6f,0x6e,0x20,0x73, /*  store session s */ \
	0x74,0x61,0x74,0x65,0x20,0x69,0x6e,0x66,0x6f,0x72,0x6d,0x61,0x74,0x69,0x6f,0x6e, /* tate information */ \
	0x20,0x66,0x6f,0x72,0x20,0x72,0x69,0x63,0x68,0x65,0x72,0x20,0x61,0x70,0x70,0x6c, /*  for richer appl */ \
	0x69,0x63,0x61,0x74,0x69,0x6f,0x6e,0x73,0x3c,0x2f,0x6c,0x69,0x3e,0x0d,0x0a,0x3c, /* ications</li>..< */ \
	0x6c,0x69,0x3e,0x3c,0x62,0x3e,0x46,0x69,0x6c,0x65,0x20,0x55,0x70,0x6c,0x6f,0x61, /* li><b>File Uploa */ \
	0x64,0x73,0x3c,0x2f,0x62,0x3e,0x20,0x2d,0x20,0x70,0x61,0x72,0x73,0x65,0x20,0x66, /* ds</b> - parse f */ \
	0x69,0x6c,0x65,0x73,0x20,0x66,0x6f,0x72,0x20,0x63,0x6f,0x6e,0x66,0x69,0x67,0x75, /* iles for configu */ \
	0x72,0x61,0x74,0x69,0x6f,0x6e,0x20,0x73,0x65,0x74,0x74,0x69,0x6e,0x67,0x73,0x20, /* ration settings  */ \
	0x61,0x6e,0x64,0x20,0x6d,0x6f,0x72,0x65,0x3c,0x2f,0x6c,0x69,0x3e,0x0d,0x0a,0x3c, /* and more</li>..< */ \
	0x2f,0x75,0x6c,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x70,0x3e,0x53,0x65,0x76,0x65,0x72, /* /ul>....<p>Sever */ \
	0x61,0x6c,0x20,0x65,0x78,0x61,0x6d,0x70,0x6c,0x65,0x20,0x61,0x70,0x70,0x6c,0x69, /* al example appli */ \
	0x63,0x61,0x74,0x69,0x6f,0x6e,0x73,0x20,0x61,0x72,0x65,0x20,0x61,0x6c,0x73,0x6f, /* cations are also */ \
	0x20,0x70,0x72,0x6f,0x76,0x69,0x64,0x65,0x64,0x20,0x66,0x6f,0x72,0x20,0x75,0x70, /*  provided for up */ \
	0x64,0x61,0x74,0x69,0x6e,0x67,0x20,0x63,0x6f,0x6e,0x66,0x69,0x67,0x75,0x72,0x61, /* dating configura */ \
	0x74,0x69,0x6f,0x6e,0x20,0x0d,0x0a,0x70,0x61,0x72,0x61,0x6d,0x65,0x74,0x65,0x72, /* tion ..parameter */ \
	0x73,0x2c,0x20,0x73,0x65,0x6e,0x64,0x69,0x6e,0x67,0x20,0x65,0x2d,0x6d,0x61,0x69, /* s, sending e-mai */ \
	0x6c,0x73,0x2c,0x20,0x61,0x6e,0x64,0x20,0x63,0x6f,0x6e,0x74,0x72,0x6f,0x6c,0x6c, /* ls, and controll */ \
	0x69,0x6e,0x67,0x20,0x74,0x68,0x65,0x20,0x44,0x79,0x6e,0x61,0x6d,0x69,0x63,0x20, /* ing the Dynamic  */ \
	0x44,0x4e,0x53,0x20,0x63,0x6c,0x69,0x65,0x6e,0x74,0x2e,0x20,0x20,0x54,0x68,0x61, /* DNS client.  Tha */ \
	0x6e,0x6b,0x73,0x20,0x74,0x6f,0x0d,0x0a,0x62,0x75,0x69,0x6c,0x74,0x2d,0x69,0x6e, /* nks to..built-in */ \
	0x20,0x47,0x5a,0x49,0x50,0x20,0x63,0x6f,0x6d,0x70,0x72,0x65,0x73,0x73,0x69,0x6f, /*  GZIP compressio */ \
	0x6e,0x20,0x73,0x75,0x70,0x70,0x6f,0x72,0x74,0x2c,0x20,0x61,0x6c,0x6c,0x20,0x74, /* n support, all t */ \
	0x68,0x65,0x73,0x65,0x20,0x74,0x75,0x74,0x6f,0x72,0x69,0x61,0x6c,0x73,0x20,0x61, /* hese tutorials a */ \
	0x6e,0x64,0x20,0x65,0x78,0x61,0x6d,0x70,0x6c,0x65,0x73,0x20,0x66,0x69,0x74,0x20, /* nd examples fit  */ \
	0x69,0x6e,0x20,0x74,0x68,0x65,0x20,0x0d,0x0a,0x33,0x32,0x6b,0x42,0x20,0x6f,0x6e, /* in the ..32kB on */ \
	0x2d,0x62,0x6f,0x61,0x72,0x64,0x20,0x45,0x45,0x50,0x52,0x4f,0x4d,0x21,0x3c,0x2f, /* -board EEPROM!</ */ \
	0x70,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x70,0x3e,0x46,0x6f,0x72,0x20,0x6d,0x6f,0x72, /* p>....<p>For mor */ \
	0x65,0x20,0x69,0x6e,0x66,0x6f,0x72,0x6d,0x61,0x74,0x69,0x6f,0x6e,0x20,0x6f,0x6e, /* e information on */ \
	0x20,0x74,0x68,0x65,0x20,0x4d,0x69,0x63,0x72,0x6f,0x63,0x68,0x69,0x70,0x20,0x54  /*  the Microchip T */
#define DATACHUNK00000e \
	0x43,0x50,0x2f,0x49,0x50,0x20,0x53,0x74,0x61,0x63,0x6b,0x2c,0x20,0x70,0x6c,0x65, /* CP/IP Stack, ple */ \
	0x61,0x73,0x65,0x20,0x72,0x65,0x66,0x65,0x72,0x20,0x74,0x6f,0x20,0x0d,0x0a,0x74, /* ase refer to ..t */ \
	0x68,0x65,0x20,0x54,0x43,0x50,0x2f,0x49,0x50,0x20,0x53,0x74,0x61,0x63,0x6b,0x20, /* he TCP/IP Stack  */ \
	0x41,0x50,0x49,0x20,0x69,0x6e,0x73,0x74,0x61,0x6c,0x6c,0x65,0x64,0x20,0x77,0x69, /* API installed wi */ \
	0x74,0x68,0x20,0x74,0x68,0x65,0x20,0x73,0x74,0x61,0x63,0x6b,0x2e,0x20,0x20,0x54, /* th the stack.  T */ \
	0x68,0x69,0x73,0x20,0x6d,0x61,0x6e,0x75,0x61,0x6c,0x20,0x63,0x61,0x6e,0x20,0x62, /* his manual can b */ \
	0x65,0x20,0x0d,0x0a,0x6c,0x61,0x75,0x6e,0x63,0x68,0x65,0x64,0x20,0x66,0x72,0x6f, /* e ..launched fro */ \
	0x6d,0x20,0x79,0x6f,0x75,0x72,0x20,0x57,0x69,0x6e,0x64,0x6f,0x77,0x73,0x20,0x53, /* m your Windows S */ \
	0x74,0x61,0x72,0x74,0x20,0x6d,0x65,0x6e,0x75,0x2e,0x3c,0x2f,0x70,0x3e,0x0d,0x0a, /* tart menu.</p>.. */ \
	0x0d,0x0a,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x73,0x63,0x72, /* ..</div>....<scr */ \
	0x69,0x70,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x2f,0x6a, /* ipt type="text/j */ \
	0x61,0x76,0x61,0x73,0x63,0x72,0x69,0x70,0x74,0x22,0x3e,0x0d,0x0a,0x3c,0x21,0x2d, /* avascript">..<!- */ \
	0x2d,0x0d,0x0a,0x2f,0x2f,0x20,0x50,0x61,0x72,0x73,0x65,0x73,0x20,0x74,0x68,0x65, /* -..// Parses the */ \
	0x20,0x78,0x6d,0x6c,0x52,0x65,0x73,0x70,0x6f,0x6e,0x73,0x65,0x20,0x66,0x72,0x6f, /*  xmlResponse fro */ \
	0x6d,0x20,0x73,0x74,0x61,0x74,0x75,0x73,0x2e,0x78,0x6d,0x6c,0x20,0x61,0x6e,0x64, /* m status.xml and */ \
	0x20,0x75,0x70,0x64,0x61,0x74,0x65,0x73,0x20,0x74,0x68,0x65,0x20,0x73,0x74,0x61, /*  updates the sta */ \
	0x74,0x75,0x73,0x20,0x62,0x6f,0x78,0x0d,0x0a,0x66,0x75,0x6e,0x63,0x74,0x69,0x6f, /* tus box..functio */ \
	0x6e,0x20,0x75,0x70,0x64,0x61,0x74,0x65,0x53,0x74,0x61,0x74,0x75,0x73,0x28,0x78, /* n updateStatus(x */ \
	0x6d,0x6c,0x44,0x61,0x74,0x61,0x29,0x20,0x7b,0x0d,0x0a,0x09,0x2f,0x2f,0x20,0x43, /* mlData) {...// C */ \
	0x68,0x65,0x63,0x6b,0x20,0x69,0x66,0x20,0x61,0x20,0x74,0x69,0x6d,0x65,0x6f,0x75, /* heck if a timeou */ \
	0x74,0x20,0x6f,0x63,0x63,0x75,0x72,0x72,0x65,0x64,0x0d,0x0a,0x09,0x69,0x66,0x28, /* t occurred...if( */ \
	0x21,0x78,0x6d,0x6c,0x44,0x61,0x74,0x61,0x29,0x0d,0x0a,0x09,0x7b,0x0d,0x0a,0x09, /* !xmlData)...{... */ \
	0x09,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e,0x67,0x65,0x74,0x45,0x6c,0x65, /* .document.getEle */ \
	0x6d,0x65,0x6e,0x74,0x42,0x79,0x49,0x64,0x28,0x27,0x64,0x69,0x73,0x70,0x6c,0x61, /* mentById('displa */ \
	0x79,0x27,0x29,0x2e,0x73,0x74,0x79,0x6c,0x65,0x2e,0x64,0x69,0x73,0x70,0x6c,0x61, /* y').style.displa */ \
	0x79,0x20,0x3d,0x20,0x27,0x6e,0x6f,0x6e,0x65,0x27,0x3b,0x0d,0x0a,0x09,0x09,0x64, /* y = 'none';....d */ \
	0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e,0x67,0x65,0x74,0x45,0x6c,0x65,0x6d,0x65, /* ocument.getEleme */ \
	0x6e,0x74,0x42,0x79,0x49,0x64,0x28,0x27,0x6c,0x6f,0x61,0x64,0x69,0x6e,0x67,0x27, /* ntById('loading' */ \
	0x29,0x2e,0x73,0x74,0x79,0x6c,0x65,0x2e,0x64,0x69,0x73,0x70,0x6c,0x61,0x79,0x20, /* ).style.display  */ \
	0x3d,0x20,0x27,0x69,0x6e,0x6c,0x69,0x6e,0x65,0x27,0x3b,0x0d,0x0a,0x09,0x09,0x72, /* = 'inline';....r */ \
	0x65,0x74,0x75,0x72,0x6e,0x3b,0x0d,0x0a,0x09,0x7d,0x0d,0x0a,0x0d,0x0a,0x09,0x2f, /* eturn;...}...../ */ \
	0x2f,0x20,0x4d,0x61,0x6b,0x65,0x20,0x73,0x75,0x72,0x65,0x20,0x77,0x65,0x27,0x72, /* / Make sure we'r */ \
	0x65,0x20,0x64,0x69,0x73,0x70,0x6c,0x61,0x79,0x69,0x6e,0x67,0x20,0x74,0x68,0x65, /* e displaying the */ \
	0x20,0x73,0x74,0x61,0x74,0x75,0x73,0x20,0x64,0x69,0x73,0x70,0x6c,0x61,0x79,0x0d, /*  status display. */ \
	0x0a,0x09,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e,0x67,0x65,0x74,0x45,0x6c, /* ..document.getEl */ \
	0x65,0x6d,0x65,0x6e,0x74,0x42,0x79,0x49,0x64,0x28,0x27,0x6c,0x6f,0x61,0x64,0x69, /* ementById('loadi */ \
	0x6e,0x67,0x27,0x29,0x2e,0x73,0x74,0x79,0x6c,0x65,0x2e,0x64,0x69,0x73,0x70,0x6c, /* ng').style.displ */ \
	0x61,0x79,0x20,0x3d,0x20,0x27,0x6e,0x6f,0x6e,0x65,0x27,0x3b,0x0d,0x0a,0x09,0x64, /* ay = 'none';...d */ \
	0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e,0x67,0x65,0x74,0x45,0x6c,0x65,0x6d,0x65, /* ocument.getEleme */ \
	0x6e,0x74,0x42,0x79,0x49,0x64,0x28,0x27,0x64,0x69,0x73,0x70,0x6c,0x61,0x79,0x27, /* ntById('display' */ \
	0x29,0x2e,0x73,0x74,0x79,0x6c,0x65,0x2e,0x64,0x69,0x73,0x70,0x6c,0x61,0x79,0x20, /* ).style.display  */ \
	0x3d,0x20,0x27,0x69,0x6e,0x6c,0x69,0x6e,0x65,0x27,0x3b,0x0d,0x0a,0x09,0x0d,0x0a, /* = 'inline';..... */ \
	0x09,0x2f,0x2f,0x20,0x4c,0x6f,0x6f,0x70,0x20,0x6f,0x76,0x65,0x72,0x20,0x61,0x6c, /* .// Loop over al */ \
	0x6c,0x20,0x74,0x68,0x65,0x20,0x4c,0x45,0x44,0x73,0x0d,0x0a,0x09,0x66,0x6f,0x72, /* l the LEDs...for */ \
	0x28,0x69,0x20,0x3d,0x20,0x30,0x3b,0x20,0x69,0x20,0x3c,0x20,0x38,0x3b,0x20,0x69, /* (i = 0; i < 8; i */ \
	0x2b,0x2b,0x29,0x20,0x7b,0x0d,0x0a,0x09,0x09,0x69,0x66,0x28,0x67,0x65,0x74,0x58, /* ++) {....if(getX */ \
	0x4d,0x4c,0x56,0x61,0x6c,0x75,0x65,0x28,0x78,0x6d,0x6c,0x44,0x61,0x74,0x61,0x2c, /* MLValue(xmlData, */ \
	0x20,0x27,0x6c,0x65,0x64,0x27,0x2b,0x69,0x29,0x20,0x3d,0x3d,0x20,0x27,0x31,0x27, /*  'led'+i) == '1' */ \
	0x29,0x0d,0x0a,0x09,0x09,0x09,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e,0x67, /* ).....document.g */ \
	0x65,0x74,0x45,0x6c,0x65,0x6d,0x65,0x6e,0x74,0x42,0x79,0x49,0x64,0x28,0x27,0x6c, /* etElementById('l */ \
	0x65,0x64,0x27,0x20,0x2b,0x20,0x69,0x29,0x2e,0x73,0x74,0x79,0x6c,0x65,0x2e,0x63, /* ed' + i).style.c */ \
	0x6f,0x6c,0x6f,0x72,0x20,0x3d,0x20,0x27,0x23,0x30,0x39,0x30,0x27,0x3b,0x0d,0x0a, /* olor = '#090';.. */ \
	0x09,0x09,0x65,0x6c,0x73,0x65,0x0d,0x0a,0x09,0x09,0x09,0x64,0x6f,0x63,0x75,0x6d, /* ..else.....docum */ \
	0x65,0x6e,0x74,0x2e,0x67,0x65,0x74,0x45,0x6c,0x65,0x6d,0x65,0x6e,0x74,0x42,0x79, /* ent.getElementBy */ \
	0x49,0x64,0x28,0x27,0x6c,0x65,0x64,0x27,0x20,0x2b,0x20,0x69,0x29,0x2e,0x73,0x74, /* Id('led' + i).st */ \
	0x79,0x6c,0x65,0x2e,0x63,0x6f,0x6c,0x6f,0x72,0x20,0x3d,0x20,0x27,0x23,0x64,0x64, /* yle.color = '#dd */ \
	0x64,0x27,0x3b,0x0d,0x0a,0x09,0x7d,0x0d,0x0a,0x09,0x0d,0x0a,0x09,0x2f,0x2f,0x20, /* d';...}......//  */ \
	0x4c,0x6f,0x6f,0x70,0x20,0x6f,0x76,0x65,0x72,0x20,0x61,0x6c,0x6c,0x20,0x74,0x68, /* Loop over all th */ \
	0x65,0x20,0x62,0x75,0x74,0x74,0x6f,0x6e,0x73,0x0d,0x0a,0x09,0x66,0x6f,0x72,0x28, /* e buttons...for( */ \
	0x69,0x20,0x3d,0x20,0x30,0x3b,0x20,0x69,0x20,0x3c,0x20,0x34,0x3b,0x20,0x69,0x2b, /* i = 0; i < 4; i+ */ \
	0x2b,0x29,0x20,0x7b,0x0d,0x0a,0x09,0x09,0x69,0x66,0x28,0x67,0x65,0x74,0x58,0x4d, /* +) {....if(getXM */ \
	0x4c,0x56,0x61,0x6c,0x75,0x65,0x28,0x78,0x6d,0x6c,0x44,0x61,0x74,0x61,0x2c,0x20, /* LValue(xmlData,  */ \
	0x27,0x62,0x74,0x6e,0x27,0x2b,0x69,0x29,0x20,0x3d,0x3d,0x20,0x27,0x75,0x70,0x27, /* 'btn'+i) == 'up' */ \
	0x29,0x0d,0x0a,0x09,0x09,0x09,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e,0x67  /* ).....document.g */
#define DATACHUNK00000f \
	0x65,0x74,0x45,0x6c,0x65,0x6d,0x65,0x6e,0x74,0x42,0x79,0x49,0x64,0x28,0x27,0x62, /* etElementById('b */ \
	0x74,0x6e,0x27,0x20,0x2b,0x20,0x69,0x29,0x2e,0x69,0x6e,0x6e,0x65,0x72,0x48,0x54, /* tn' + i).innerHT */ \
	0x4d,0x4c,0x20,0x3d,0x20,0x27,0x26,0x4c,0x61,0x6d,0x62,0x64,0x61,0x3b,0x27,0x3b, /* ML = '&Lambda;'; */ \
	0x0d,0x0a,0x09,0x09,0x65,0x6c,0x73,0x65,0x0d,0x0a,0x09,0x09,0x09,0x64,0x6f,0x63, /* ....else.....doc */ \
	0x75,0x6d,0x65,0x6e,0x74,0x2e,0x67,0x65,0x74,0x45,0x6c,0x65,0x6d,0x65,0x6e,0x74, /* ument.getElement */ \
	0x42,0x79,0x49,0x64,0x28,0x27,0x62,0x74,0x6e,0x27,0x20,0x2b,0x20,0x69,0x29,0x2e, /* ById('btn' + i). */ \
	0x69,0x6e,0x6e,0x65,0x72,0x48,0x54,0x4d,0x4c,0x20,0x3d,0x20,0x27,0x56,0x27,0x3b, /* innerHTML = 'V'; */ \
	0x0d,0x0a,0x09,0x7d,0x0d,0x0a,0x09,0x0d,0x0a,0x09,0x2f,0x2f,0x20,0x55,0x70,0x64, /* ...}......// Upd */ \
	0x61,0x74,0x65,0x20,0x74,0x68,0x65,0x20,0x50,0x4f,0x54,0x20,0x76,0x61,0x6c,0x75, /* ate the POT valu */ \
	0x65,0x0d,0x0a,0x09,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e,0x67,0x65,0x74, /* e...document.get */ \
	0x45,0x6c,0x65,0x6d,0x65,0x6e,0x74,0x42,0x79,0x49,0x64,0x28,0x27,0x70,0x6f,0x74, /* ElementById('pot */ \
	0x30,0x27,0x29,0x2e,0x69,0x6e,0x6e,0x65,0x72,0x48,0x54,0x4d,0x4c,0x20,0x3d,0x20, /* 0').innerHTML =  */ \
	0x67,0x65,0x74,0x58,0x4d,0x4c,0x56,0x61,0x6c,0x75,0x65,0x28,0x78,0x6d,0x6c,0x44, /* getXMLValue(xmlD */ \
	0x61,0x74,0x61,0x2c,0x20,0x27,0x70,0x6f,0x74,0x30,0x27,0x29,0x3b,0x09,0x0d,0x0a, /* ata, 'pot0');... */ \
	0x7d,0x0d,0x0a,0x73,0x65,0x74,0x54,0x69,0x6d,0x65,0x6f,0x75,0x74,0x28,0x22,0x6e, /* }..setTimeout("n */ \
	0x65,0x77,0x41,0x4a,0x41,0x58,0x43,0x6f,0x6d,0x6d,0x61,0x6e,0x64,0x28,0x27,0x73, /* ewAJAXCommand('s */ \
	0x74,0x61,0x74,0x75,0x73,0x2e,0x78,0x6d,0x6c,0x27,0x2c,0x20,0x75,0x70,0x64,0x61, /* tatus.xml', upda */ \
	0x74,0x65,0x53,0x74,0x61,0x74,0x75,0x73,0x2c,0x20,0x74,0x72,0x75,0x65,0x29,0x22, /* teStatus, true)" */ \
	0x2c,0x35,0x30,0x30,0x29,0x3b,0x0d,0x0a,0x2f,0x2f,0x2d,0x2d,0x3e,0x0d,0x0a,0x3c, /* ,500);..//-->..< */ \
	0x2f,0x73,0x63,0x72,0x69,0x70,0x74,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x73,0x63,0x72, /* /script>....<scr */ \
	0x69,0x70,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x2f,0x6a, /* ipt type="text/j */ \
	0x61,0x76,0x61,0x73,0x63,0x72,0x69,0x70,0x74,0x22,0x3e,0x0d,0x0a,0x3c,0x21,0x2d, /* avascript">..<!- */ \
	0x2d,0x0d,0x0a,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e,0x67,0x65,0x74,0x45, /* -..document.getE */ \
	0x6c,0x65,0x6d,0x65,0x6e,0x74,0x42,0x79,0x49,0x64,0x28,0x27,0x68,0x65,0x6c,0x6c, /* lementById('hell */ \
	0x6f,0x27,0x29,0x2e,0x69,0x6e,0x6e,0x65,0x72,0x48,0x54,0x4d,0x4c,0x20,0x3d,0x20, /* o').innerHTML =  */ \
	0x22,0x7e,0x68,0x65,0x6c,0x6c,0x6f,0x6d,0x73,0x67,0x7e,0x22,0x3b,0x0d,0x0a,0x2f, /* "~hellomsg~";../ */ \
	0x2f,0x2d,0x2d,0x3e,0x0d,0x0a,0x3c,0x2f,0x73,0x63,0x72,0x69,0x70,0x74,0x3e,0x0d, /* /-->..</script>. */ \
	0x0a,0x0d,0x0a,0x7e,0x69,0x6e,0x63,0x3a,0x66,0x6f,0x6f,0x74,0x65,0x72,0x2e,0x69, /* ...~inc:footer.i */ \
	0x6e,0x63,0x7e,0x0d,0x0a,0x00,0x00,0x00,0x00,0x33,0x00,0x00,0x00,0xd5,0x04,0x00, /* nc~......3...... */ \
	0x00,0x16,0x00,0x00,0x00,0x1c,0x05,0x00,0x00,0x05,0x00,0x00,0x00,0x18,0x10,0x00, /* ................ */ \
	0x00,0x01,0x00,0x00,0x00,0x3a,0x10,0x00,0x00,0x02,0x00,0x00,0x00,0x53,0x75,0x63, /* .....:.......Suc */ \
	0x63,0x65,0x73,0x73,0x21,0x20,0x7e,0x6c,0x65,0x64,0x28,0x30,0x29,0x7e,0x09,0x00, /* cess! ~led(0)~.. */ \
	0x00,0x00,0x17,0x00,0x00,0x00,0x1f,0x8b,0x08,0x00,0x00,0x00,0x00,0x00,0x04,0x00, /* ................ */ \
	0xed,0xbd,0x07,0x60,0x1c,0x49,0x96,0x25,0x26,0x2f,0x6d,0xca,0x7b,0x7f,0x4a,0xf5, /* ...`.I.%&/m.{.J. */ \
	0x4a,0xd7,0xe0,0x74,0xa1,0x08,0x80,0x60,0x13,0x24,0xd8,0x90,0x40,0x10,0xec,0xc1, /* J..t...`.$..@... */ \
	0x88,0xcd,0xe6,0x92,0xec,0x1d,0x69,0x47,0x23,0x29,0xab,0x2a,0x81,0xca,0x65,0x56, /* ......iG#)....eV */ \
	0x65,0x5d,0x66,0x16,0x40,0xcc,0xed,0x9d,0xbc,0xf7,0xde,0x7b,0xef,0xbd,0xf7,0xde, /* e]f.@......{.... */ \
	0x7b,0xef,0xbd,0xf7,0xba,0x3b,0x9d,0x4e,0x27,0xf7,0xdf,0xff,0x3f,0x5c,0x66,0x64, /* {....;.N'...?\fd */ \
	0x01,0x6c,0xf6,0xce,0x4a,0xda,0xc9,0x9e,0x21,0x80,0xaa,0xc8,0x1f,0x3f,0x7e,0x7c, /* .l..J...!....?~| */ \
	0x1f,0x3f,0x22,0x26,0xd5,0xec,0x3a,0xfd,0xc5,0xbf,0x71,0xf2,0x63,0xe7,0xd5,0xb2, /* .?"&..:...q.c... */ \
	0xdd,0x3e,0xcf,0x16,0x45,0x79,0xfd,0x28,0xfd,0xc9,0xbc,0x9e,0x65,0xcb,0x6c,0x94, /* .>..Ey.(....e.l. */ \
	0x1e,0xd7,0x45,0x56,0x8e,0xd2,0x26,0x5b,0x36,0xdb,0x4d,0x5e,0x17,0xe7,0x87,0xd4, /* ..EV..&[6.M^.... */ \
	0x74,0x92,0x4d,0xdf,0x5e,0xd4,0xd5,0x7a,0x39,0x7b,0x94,0xfe,0xf8,0xfd,0x09,0xfe, /* t.M.^..z9{...... */ \
	0xc3,0xc7,0x8b,0xac,0xbe,0x28,0x96,0x8f,0xd2,0x9d,0xd5,0xbb,0x34,0x5b,0xb7,0x15, /* .....(......4[.. */ \
	0x3e,0x5b,0x65,0xb3,0x59,0xb1,0xbc,0xa0,0x0f,0xe9,0xbf,0x3d,0x7c,0xb3,0x43,0x1f, /* >[e.Y......=|.C. */ \
	0xff,0x92,0xdf,0x38,0xf9,0x8d,0x93,0x1f,0x6f,0xe6,0xd9,0xac,0xba,0xda,0xae,0x96, /* ...8....o....... */ \
	0x39,0x23,0x70,0x55,0xcc,0xda,0xf9,0xa3,0xf4,0xc1,0xa7,0xd4,0x8a,0x7b,0xa9,0xea, /* 9#pU.........{.. */ \
	0x59,0x5e,0x3f,0x4a,0x77,0xe9,0xa5,0xa6,0x2a,0x8b,0x19,0xf5,0x75,0xff,0xbe,0xfb, /* Y^?Jw.......u... */ \
	0x66,0xbb,0xad,0x56,0x8f,0x18,0x5c,0xac,0xe7,0x5f,0xe2,0x3a,0x68,0xaf,0x2a,0xee, /* f..V..\.._.:h... */ \
	0x20,0x02,0x70,0x7f,0x82,0xff,0x62,0x30,0xfd,0xf7,0xe7,0x75,0x9e,0x0f,0x42,0xd8, /*  .p...b0...u..B. */ \
	0xdf,0xbf,0xe1,0xf5,0xf3,0x6a,0x5d,0x0f,0xbd,0x7d,0x2f,0xc3,0x7f,0x03,0x00,0x08, /* .....j]..}/..... */ \
	0xc4,0x2a,0xbb,0x18,0xec,0xf9,0xde,0xbd,0x7b,0xbd,0xc9,0x38,0x3f,0x3f,0x8f,0x01, /* ........{..8??.. */ \
	0x73,0xd3,0xb0,0xa7,0xc4,0xe5,0xd9,0x6e,0x8a,0x1f,0xe4,0x04,0x72,0x67,0xd5,0x86, /* s......n....rg.. */ \
	0x1d,0xb6,0x33,0xc7,0x11,0x91,0x36,0x6d,0xd1,0x96,0x8a,0x95,0xdf,0xf7,0x74,0x27, /* ..3...6m......t' */ \
	0xec,0x6a,0xdf,0xeb,0xe9,0x2a,0x2f,0x2e,0xe6,0xed,0xa3,0x74,0x52,0x95,0x33,0x7c, /* .j..../....tR.3| */ \
	0x38,0xad,0xca,0xaa,0x76,0xf8,0xca,0xfc,0x6d,0x4f,0xaa,0xb6,0xad,0x16,0xd4,0xdb, /* 8...v...mO...... */ \
	0x7d,0x79,0x75,0xae,0x6f,0xed,0x7e,0xca,0x7f,0xfb,0xbd,0x8f,0x6b,0x7c,0x25,0x68, /* }yu.o.~.....k|%h */ \
	0x96,0x55,0x46,0x8d,0xf8,0x03,0xbc,0xa5,0x7c,0x74,0x6f,0x47,0x87,0xda,0xe6,0xef, /* .UF.....|toG.... */ \
	0xda,0xed,0xac,0x2c,0x2e,0x96,0xae,0x91,0x80,0x5a,0xe4,0xcb,0xb5,0x0f,0xa2,0xcc, /* ...,.....Z...... */ \
	0xcf,0x7d,0x08,0xbb,0xf7,0x15,0x82,0x0e,0x69,0xbb,0x16,0x74,0x94,0x86,0x1e,0x8c, /* .}......i..t.... */ \
	0xcc,0x67,0xe0,0xdd,0x7d,0x7d,0x6d,0x56,0x34,0xab,0x32,0x23,0x69,0x9a,0x94,0xd5, /* .g..}}mV4.2#i... */ \
	0xf4,0x6d,0x6f,0xae,0x94,0x5e,0x4a,0x8a,0xab,0x79,0xd1,0xe6,0x01,0xfd,0x0e,0x36, /* .mo..^J..y.....6 */ \
	0xd0,0x4f,0x27,0xd8,0x12,0xcc,0x71,0x85,0x52,0x94,0x07,0x3d,0xcb,0xa7,0x55,0x9d, /* .O'...q.R..=..U. */ \
	0xb5,0x45,0x45,0x23,0x5f,0x92,0x98,0x75,0x90,0x7e,0x34,0xaf,0x2e,0x73,0x65,0x4d  /* .EE#_..u.~4..seM */
#define DATACHUNK000010 \
	0x1f,0xb1,0x19,0x33,0x96,0xb4,0x9c,0x52,0xef,0xf9,0xb2,0xf5,0xc7,0x77,0x7f,0x4f, /* ...3...R.....w.O */ \
	0xa7,0xa7,0x4b,0xf8,0x0e,0x99,0x76,0x7d,0x32,0x19,0x38,0x42,0x29,0x33,0xfd,0x4a, /* ..K...v}2.8B)3.J */ \
	0x82,0xcd,0xc8,0xda,0x57,0x3d,0x7c,0x0d,0x00,0x41,0xb5,0x0f,0x80,0x06,0x92,0xd7, /* ....W=|..A...... */ \
	0x65,0x11,0x81,0x32,0xdf,0x65,0x00,0xca,0x71,0x22,0x21,0x0e,0xcf,0x71,0xb3,0xca, /* e..2.e..q"!..q.. */ \
	0xa6,0xa6,0x8f,0x32,0xcf,0x6a,0x90,0xbc,0x9d,0x5b,0x28,0xe7,0x55,0xd5,0xea,0xd7, /* ...2.j...[(.U... */ \
	0x9e,0x74,0xec,0x8c,0x0f,0xf2,0x85,0x37,0x97,0x3f,0xfe,0xe9,0xa7,0x9f,0x5a,0xb4, /* .t.....7.?....Z. */ \
	0x94,0xf3,0xa6,0xd4,0x79,0x5e,0x1f,0xda,0xae,0x85,0x3e,0x29,0x58,0x8c,0x34,0x63, /* ....y^....>)X.4c */ \
	0x97,0xd3,0x18,0x2f,0x25,0x60,0x20,0xcd,0x98,0xe9,0x19,0xcd,0x7a,0x3e,0x33,0xbd, /* .../%` .....z>3. */ \
	0xa8,0x2e,0x6d,0xb3,0x76,0xdd,0x04,0x6c,0xf8,0x60,0xf3,0x34,0x39,0xf8,0x3e,0x42, /* ..m.v..l.`.49.>B */ \
	0xae,0xbf,0x58,0x5f,0x51,0x66,0x0c,0x10,0x58,0x31,0x0a,0xb6,0x8b,0xfb,0x32,0x3a, /* ..X_Qf..X1....2: */ \
	0xfa,0xd7,0x00,0x67,0x9a,0x14,0x34,0x3d,0x4b,0x82,0xb0,0xdd,0x45,0xc1,0x33,0x0e, /* ...g..4=K...E.3. */ \
	0x02,0x6f,0x5c,0xe6,0xb3,0xa6,0x4b,0xef,0xdd,0x7d,0x4f,0x1b,0x05,0x0d,0x43,0xf6, /* .o\...K..}O...C. */ \
	0x9a,0xcd,0x44,0xd9,0xac,0xeb,0x06,0x7f,0xaf,0xaa,0x42,0xe7,0x20,0xf6,0x66,0x8c, /* ..D.......B. .f. */ \
	0xbb,0xe4,0xfd,0x8d,0xec,0x39,0xce,0xdf,0x65,0x8b,0x55,0x99,0x4f,0xaa,0x77,0x1e, /* .....9..e.U.O.w. */ \
	0x63,0x3d,0xe2,0xc9,0x85,0x22,0x48,0xed,0x6f,0x01,0xed,0x55,0xb8,0x63,0xa4,0x56, /* c=..."H.o..U.c.V */ \
	0xbd,0xee,0x31,0x8f,0xe3,0x1d,0x4f,0x4e,0x15,0x3b,0x41,0x62,0x5a,0xcd,0x72,0x47, /* ..1...ON.;AbZ.rG */ \
	0x25,0x63,0xc5,0x4f,0xc8,0xf2,0x14,0x34,0xa6,0x17,0xf9,0xd5,0xc8,0xfc,0x31,0x4a, /* %c.O...4......1J */ \
	0xcf,0x8b,0x77,0xf9,0x6c,0x9b,0xb9,0x44,0xff,0xf0,0xc6,0x92,0xd7,0xd3,0xa2,0x89, /* ..w.l..D........ */ \
	0x28,0xf7,0xf3,0xfc,0x61,0x80,0xbf,0xf2,0x96,0x8a,0x11,0x14,0x67,0x8f,0x5f,0xe5, /* (...a.......g._. */ \
	0xc3,0x3d,0xa7,0x9a,0xf2,0x89,0xd5,0x2b,0xe3,0xbc,0xae,0xab,0xda,0x23,0x58,0x07, /* .=.....+.....#X. */ \
	0x44,0x8f,0x47,0x43,0x64,0x64,0x5e,0x86,0xfa,0x79,0xb8,0xe3,0xd8,0xc8,0x8a,0xfd, /* D.GCdd^..y...... */ \
	0xa7,0x32,0xa6,0xae,0x28,0x65,0xcd,0xdc,0xa3,0xb9,0x95,0x04,0x1d,0x9e,0xf3,0x5e, /* .2..(e.........^ */ \
	0x3a,0x06,0xc9,0xd3,0x18,0xde,0xfc,0xab,0xdd,0xf4,0x66,0xce,0x58,0x94,0xae,0x6a, /* :.........f.X..j */ \
	0xbc,0xef,0x00,0x9c,0x17,0x79,0x39,0x6b,0xf2,0xd6,0x23,0xc6,0x37,0xc0,0x3d,0x03, /* .....y9k..#.7.=. */ \
	0x8c,0x62,0x3b,0x9b,0x15,0x97,0xa1,0xa4,0x82,0x7e,0xe8,0x0b,0x3f,0x8d,0xe1,0xeb, /* .b;......~..?... */ \
	0xbf,0x52,0x66,0x93,0xbc,0xec,0x4f,0xdb,0xb6,0xb5,0x79,0x81,0x02,0xdb,0x93,0xcf, /* .Rf...O...y..... */ \
	0x8c,0x42,0xba,0x67,0x14,0x52,0xcc,0xa2,0xad,0xaa,0xa6,0x10,0xe9,0xca,0x26,0x34, /* .B.g.R........&4 */ \
	0x8f,0xeb,0xd6,0x4a,0x98,0x45,0xa0,0x58,0xae,0xd6,0x81,0x25,0xda,0x8b,0xe2,0xc9, /* ...J.E.X...%.... */ \
	0xcd,0xc6,0xcd,0xc2,0x6f,0xe9,0x9c,0x42,0xaf,0x21,0xe6,0x29,0xab,0xf3,0xc0,0x78, /* ....o..B.!.)...x */ \
	0x07,0x20,0xc7,0x75,0xde,0xac,0xcb,0xf6,0x37,0x4e,0xbc,0xa9,0x71,0x33,0x72,0xfb, /* . .u....7N..q3r. */ \
	0xb9,0x09,0x1d,0xb6,0xb8,0x55,0x88,0x9b,0x79,0x9f,0xeb,0xf3,0xdc,0x92,0xe4,0xc7, /* .....U..y....... */ \
	0xc6,0xd5,0x5b,0xc6,0xda,0x30,0xb4,0x35,0x3c,0x13,0x56,0xd3,0x9d,0x17,0xcf,0xd9, /* ..[..0.5<.V..... */ \
	0xb1,0xa0,0x37,0x7f,0x0c,0xaf,0x9e,0x67,0x45,0x19,0x7d,0x79,0xf2,0x69,0xe4,0xe5, /* ..7....gE.}y.i.. */ \
	0xf3,0x3c,0x78,0x79,0xbd,0x8c,0x77,0x3c,0x9d,0xc6,0xde,0x3d,0x9f,0xe9,0xbb,0xff, /* .<xy..w<...=.... */ \
	0x0f,0x31,0x7c,0xd6,0xd0,0x66,0x0c,0x00,0x00,0x47,0x49,0x46,0x38,0x39,0x61,0x98, /* .1|..f...GIF89a. */ \
	0x00,0x2a,0x00,0xd5,0x24,0x00,0x7f,0x7f,0x7f,0xbf,0xbf,0xbf,0xfe,0x10,0x1b,0xff, /* ....$........... */ \
	0xef,0xf0,0xff,0xcf,0xd1,0xef,0xef,0xef,0x70,0x70,0x70,0xcf,0xcf,0xcf,0xff,0xdf, /* ........ppp..... */ \
	0xe1,0x10,0x10,0x10,0xfe,0x20,0x2a,0xfe,0x30,0x3a,0x9f,0x9f,0x9f,0x50,0x50,0x50, /* ..... ..0:...PPP */ \
	0xfe,0x40,0x49,0x60,0x60,0x60,0x20,0x20,0x20,0x8f,0x8f,0x8f,0xdf,0xdf,0xdf,0xff, /* .@I```   ....... */ \
	0x80,0x86,0xaf,0xaf,0xaf,0x30,0x30,0x30,0xfe,0x7f,0x85,0xff,0x9f,0xa4,0xff,0xbf, /* .....000........ */ \
	0xc2,0xfe,0x50,0x58,0xfe,0x70,0x76,0xfe,0x60,0x67,0xff,0x8f,0x94,0xff,0x8f,0x95, /* ..PX.pv.`g...... */ \
	0xff,0xaf,0xb3,0xfe,0x70,0x77,0x40,0x40,0x40,0xfe,0x00,0x0c,0xff,0xff,0xff,0x00, /* ....pw@@@....... */ \
	0x00,0x00,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, /* ................ */ \
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, /* ................ */ \
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, /* ................ */ \
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, /* ................ */ \
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, /* ................ */ \
	0x00,0x00,0x00,0x00,0x00,0x00,0x21,0xf9,0x04,0x01,0x00,0x00,0x24,0x00,0x2c,0x00, /* ......!.....$.,. */ \
	0x00,0x00,0x00,0x98,0x00,0x2a,0x00,0x00,0x06,0xff,0x40,0x92,0x70,0x48,0x2c,0x1a, /* ..........@.pH,. */ \
	0x8f,0xc8,0xa4,0x72,0xc9,0x6c,0x3a,0x9f,0xd0,0xa8,0x74,0x4a,0xad,0x5a,0xaf,0xd8, /* ...r.l:...tJ.Z.. */ \
	0xac,0x76,0xcb,0xed,0x7a,0x87,0x04,0x8b,0x43,0x10,0x2a,0x97,0x05,0x0e,0x0e,0xe2, /* .v..z...C....... */ \
	0xcb,0x6e,0xbb,0x8d,0x03,0x8b,0xc2,0x4c,0xaf,0x87,0x1c,0x04,0x21,0x00,0x62,0x78, /* .n.....L....!.bx */ \
	0xfb,0xff,0x54,0x16,0x64,0x76,0x84,0x65,0x0a,0x03,0x24,0x06,0x09,0x0d,0x80,0x8d, /* ..T.dv.e..$..... */ \
	0x8e,0x49,0x08,0x0b,0x85,0x93,0x65,0x16,0x24,0x0d,0x15,0x20,0x8f,0x9b,0x9b,0x04, /* .I....e.$.. .... */ \
	0x83,0x94,0x93,0x79,0x01,0x05,0x9c,0xa5,0x7f,0x9e,0xa0,0xa0,0x0b,0xa6,0xac,0x6f, /* ...y...........o */ \
	0xa8,0xa9,0xa0,0x1c,0x4d,0x05,0x20,0x23,0x20,0x07,0x47,0x05,0x0d,0xb6,0xa4,0xad, /* ....M. # .G..... */ \
	0xac,0x03,0x73,0x76,0x17,0x22,0x1b,0x93,0x0b,0x08,0xaf,0x02,0x6b,0x4b,0x11,0x23, /* ..sv."......kK.# */ \
	0xce,0x9a,0x46,0x0f,0xce,0x23,0x7d,0xbe,0xa6,0x1f,0x84,0x13,0x22,0xdb,0x92,0x76, /* ..F..#}....."..v */ \
	0xca,0xdb,0x18,0x66,0x0e,0x4c,0x06,0xd3,0x23,0x12,0x45,0x05,0xe6,0xd0,0xd6,0x9b, /* ...f.L..#.E..... */ \
	0x08,0x84,0x0b,0xdb,0xdb,0x04,0x84,0xc3,0xf2,0x19,0x66,0x1e,0x4b,0xb5,0xd3,0xd5, /* ..........f.K... */ \
	0x43,0xcd,0xd3,0xd8,0xb5,0x73,0x54,0xac,0xce,0x37,0x79,0x22,0x26,0xd4,0xc9,0x80, /* C....sT..7y"&... */ \
	0x50,0xc4,0x80,0x41,0x02,0x10,0x25,0xe1,0xe7,0x2c,0x41,0x11,0x08,0xe6,0x46,0x08, /* P..A..%..,A...F. */ \
	0x39,0x00,0xa2,0xe3,0xbf,0x8e,0x20,0x41,0x3e,0x20,0x15,0xb2,0x64,0x03,0x06,0x43, /* 9..... A> ..d..C */ \
	0x0a,0x18,0x28,0xd9,0xb1,0x41,0x80,0x94,0x2b,0x59,0x82,0x88,0x40,0x82,0x23,0x08  /* ..(..A..+Y..@.#. */
#define DATACHUNK000011 \
	0x7f,0x42,0x18,0x74,0x44,0x19,0x13,0xa5,0xcc,0xff,0x8e,0x0f,0x28,0x90,0x18,0x50, /* .B.tD.......(..P */ \
	0xaf,0xa1,0xc3,0x60,0x21,0x22,0x1a,0xbd,0x60,0x66,0x83,0x92,0x8c,0x23,0x50,0x0a, /* ...`!"..`f...#P. */ \
	0x09,0x00,0x75,0xea,0x34,0x21,0xbb,0xa0,0x4e,0x43,0xa9,0xd5,0x1c,0xca,0x02,0x15, /* ..u.4!..NC...... */ \
	0xba,0x3a,0x7b,0x59,0x00,0xa3,0xd8,0x02,0x54,0x6d,0x15,0x01,0xe0,0x0c,0x00,0x09, /* .:{Y....Tm...... */ \
	0x7e,0x6e,0xc5,0x3a,0xa3,0xc0,0xd4,0xa0,0x51,0x70,0x66,0x3a,0xdc,0x15,0xe1,0xc0, /* ~n.:....Qpf:.... */ \
	0x0c,0x86,0x24,0x50,0xd9,0x49,0xcb,0x88,0x2b,0xad,0x46,0x09,0x72,0x47,0xc4,0x95, /* ..$P.I..+.F.rG.. */ \
	0xab,0x89,0x41,0x62,0x46,0x8e,0xe5,0x06,0x48,0x2b,0x90,0x04,0x5b,0xc5,0x6f,0xdb, /* ..AbF...H+..[.o. */ \
	0x92,0x48,0x0c,0x01,0x9f,0x1d,0x6d,0x77,0x0b,0x2a,0x35,0x8a,0x60,0xd0,0xa1,0x23, /* .H....mw..5.`..# */ \
	0x07,0xa6,0x25,0x98,0x86,0x4e,0x9d,0x33,0xb3,0x23,0x5e,0x1a,0x26,0x41,0x21,0xf1, /* ..%..N.3.#^.&A!. */ \
	0x62,0x5b,0x21,0x55,0x5b,0x56,0x0d,0x32,0xec,0xd5,0xc1,0x62,0x27,0x3f,0x5b,0xab, /* b[!U[V.2...b'?[. */ \
	0x19,0xee,0xe6,0x67,0xb9,0xa7,0x21,0xad,0x43,0xe0,0xee,0xc3,0x32,0x0c,0xef,0x2a, /* ...g..!.C...2... */ \
	0xac,0x74,0xc4,0x30,0x40,0x6a,0x24,0xae,0x5f,0x17,0x3a,0xfb,0x72,0x02,0x74,0x48, /* .t.0@j$._.:.r.tH */ \
	0xae,0x12,0x41,0xec,0x2c,0xb3,0x5a,0x22,0xd7,0xcd,0x83,0xe8,0x65,0x84,0x32,0x71, /* ..A.,.Z"....e.2q */ \
	0xcc,0xc6,0xc5,0x0f,0x21,0x3f,0xa2,0xce,0x84,0xbe,0x77,0xf6,0x7a,0xf0,0xbb,0xb7, /* ....!?....w.z... */ \
	0x5b,0x88,0x3c,0x45,0xd4,0x56,0x9e,0x59,0x16,0xc1,0x06,0x96,0x66,0xdd,0x0d,0x07, /* [.<E.V.Y....f... */ \
	0x58,0x79,0x45,0x5c,0x65,0xdc,0x78,0x0e,0x6a,0x86,0x84,0x61,0x5d,0xb9,0x15,0x1f, /* XyE\e.x.j..a]... */ \
	0x83,0x44,0x4c,0x43,0x47,0x3c,0xa5,0x95,0xa1,0xff,0xd7,0x5d,0xf8,0x1d,0x72,0x17, /* .DLCG<.....]..r. */ \
	0x3d,0x65,0xac,0xf2,0x9e,0x46,0xe5,0x38,0x03,0xdc,0x03,0xe6,0xb9,0x95,0xe0,0x79, /* =e...F.8.......y */ \
	0xe1,0x8d,0x35,0xd9,0x64,0x00,0x55,0xd0,0xa2,0x11,0x11,0x62,0x36,0xa1,0x6d,0x37, /* ..5.d.U....b6.m7 */ \
	0xca,0xb7,0x91,0x86,0x67,0x20,0xb0,0xcd,0x74,0x07,0x35,0xd4,0x61,0x08,0x1a,0xec, /* ....g ..t.5.a... */ \
	0xa5,0x81,0x19,0xb2,0x10,0x71,0x19,0x04,0x24,0xd0,0x67,0x8e,0x50,0xfc,0x68,0xf2, /* .....q..$.g.P.h. */ \
	0x62,0x65,0x0d,0xca,0xc5,0xe2,0x83,0x19,0x96,0xc7,0x65,0x7b,0x3c,0x5e,0x28,0x97, /* be........e{<^(. */ \
	0x19,0xf6,0x70,0x03,0xdd,0x5e,0x1d,0x98,0xd1,0x9c,0x51,0xc0,0x04,0x49,0x44,0x95, /* ..p..^....Q..ID. */ \
	0x42,0x50,0xf4,0x9a,0x10,0x29,0x5a,0x79,0xd5,0x65,0x58,0x76,0xd9,0xd5,0x77,0x37, /* BP...)Zy.eXv..w7 */ \
	0x12,0xe1,0x9a,0x46,0x5f,0x16,0x91,0x56,0x02,0x25,0x99,0x65,0xa1,0x66,0x89,0x55, /* ...F_..V.%.e.f.U */ \
	0x50,0xc6,0x06,0x0d,0x91,0x18,0x82,0x07,0xfd,0x95,0xb8,0x57,0x38,0x65,0xfc,0x35, /* P..........W8e.5 */ \
	0x04,0x9c,0x24,0x44,0x36,0x8d,0x5b,0xbb,0x8d,0x60,0xd1,0x8b,0x50,0x2e,0x28,0xd6, /* ..$D6.[..`..P.(. */ \
	0x96,0x2a,0x06,0x98,0x23,0x8b,0x3b,0xc2,0xa8,0x47,0x71,0x88,0xca,0x45,0x81,0x02, /* ....#.;..Gq..E.. */ \
	0x22,0x36,0x44,0xe4,0x00,0x23,0x9a,0x01,0x9a,0x51,0x9e,0x49,0x24,0xc4,0x6a,0xd8, /* "6D..#...Q.I$.j. */ \
	0x91,0x50,0x00,0xaf,0xce,0x80,0x77,0x99,0x46,0xb3,0x69,0x9a,0x09,0x4b,0x7d,0x6c, /* .P....w.F.i..K}l */ \
	0x0a,0xc0,0xb2,0x00,0x64,0xa5,0x49,0x8a,0x23,0x1c,0xdb,0x11,0xb0,0x97,0x04,0x24, /* ....d.I.#......$ */ \
	0xd3,0x01,0xee,0x39,0xc9,0x2a,0x66,0xca,0x32,0xbb,0xec,0x4b,0x19,0xac,0x69,0xa4, /* ...9..f.2..K..i. */ \
	0x19,0x49,0x4a,0x17,0xa4,0x73,0x02,0x28,0x90,0xff,0xa5,0x8e,0x24,0x00,0xc7,0x48, /* .IJ..s.(....$..H */ \
	0x4e,0xd3,0xa0,0x75,0x55,0x6a,0x72,0x25,0x8b,0xa1,0x55,0x6a,0x5d,0xd7,0x95,0x26, /* N..uUjr%..Uj]..& */ \
	0xfa,0x6a,0x25,0x9c,0xaa,0x9d,0x1e,0xca,0xed,0xbd,0x45,0xd0,0x7a,0x57,0x9a,0xfc, /* .j%.......E.zW.. */ \
	0xb1,0x19,0x8c,0x03,0x7b,0x5d,0x70,0x81,0x9f,0x9b,0xa6,0x14,0x16,0x04,0xb8,0xe0, /* ....{]p......... */ \
	0x1b,0xdb,0x6c,0xe6,0x55,0x78,0x9c,0x46,0x44,0xb8,0xf7,0xab,0xab,0x51,0x02,0xab, /* ..l.Ux.FD....Q.. */ \
	0x15,0xb6,0x0a,0x0e,0x71,0x99,0xc0,0xb7,0x25,0xb1,0xd7,0x91,0x86,0x8c,0xf8,0x49, /* ....q...%......I */ \
	0x99,0x46,0x11,0x61,0xd3,0x2d,0x4b,0xcc,0x7c,0xc0,0xcc,0x42,0x14,0xf0,0x80,0xc8, /* .F.a.-K.|..B.... */ \
	0xd3,0x34,0x40,0x92,0x47,0x32,0x77,0x54,0xcd,0x01,0x59,0x65,0x54,0x81,0x50,0x1b, /* .4@.G2wT..YeT.P. */ \
	0x15,0x6d,0x4e,0x02,0x7d,0xd8,0x84,0x53,0xa6,0x3b,0x25,0x12,0x35,0x48,0x4a,0xdc, /* .mN.}..S.;%.5HJ. */ \
	0xe5,0x9f,0xad,0x46,0x5d,0x3d,0x5a,0x43,0x03,0x75,0xed,0x84,0x51,0x4b,0x12,0x22, /* ...F]=ZC.u..QK." */ \
	0x6e,0x42,0x76,0x44,0xc7,0xb5,0xd7,0x68,0x57,0x2d,0x0f,0xa5,0xf0,0xc8,0xe3,0x68, /* nBvD...hW-.....h */ \
	0x1d,0x18,0x9c,0x9d,0xf6,0xdc,0x47,0x6c,0xf3,0xdc,0x24,0x7a,0xb5,0x49,0x48,0xac, /* ......Gl..$z.IH. */ \
	0x22,0xd0,0xed,0xb7,0x11,0xdb,0xe0,0x47,0x89,0x06,0x57,0xdb,0x51,0x6e,0xdf,0x7f, /* "......G..W.Qn.. */ \
	0x27,0x2e,0x04,0xcb,0xb0,0x84,0x82,0xb8,0xe2,0x8a,0xbf,0xd2,0x38,0x21,0x02,0x00, /* '...........8!.. */ \
	0x08,0x39,0xe4,0x91,0x4c,0x6e,0x87,0x03,0xba,0x5e,0x7e,0x39,0x07,0x9f,0x34,0x2e, /* .9..Ln...^~9..4. */ \
	0x40,0x93,0x9e,0x97,0x3e,0x94,0x1c,0xb0,0x28,0x60,0x41,0xe7,0xa6,0x9b,0x1e,0xc6, /* @...>...(`A..... */ \
	0x18,0x06,0x39,0x60,0x81,0xe5,0xad,0xd7,0x6e,0x0c,0xfb,0xed,0xb8,0xe7,0xae,0xfb, /* ..9`....n....... */ \
	0xee,0xbc,0xf7,0x1e,0x45,0x10,0x00,0x3b,0x1f,0x8b,0x08,0x00,0x00,0x00,0x00,0x00, /* ....E..;........ */ \
	0x04,0x00,0xed,0xbd,0x07,0x60,0x1c,0x49,0x96,0x25,0x26,0x2f,0x6d,0xca,0x7b,0x7f, /* .....`.I.%&/m.{. */ \
	0x4a,0xf5,0x4a,0xd7,0xe0,0x74,0xa1,0x08,0x80,0x60,0x13,0x24,0xd8,0x90,0x40,0x10, /* J.J..t...`.$..@. */ \
	0xec,0xc1,0x88,0xcd,0xe6,0x92,0xec,0x1d,0x69,0x47,0x23,0x29,0xab,0x2a,0x81,0xca, /* ........iG#).... */ \
	0x65,0x56,0x65,0x5d,0x66,0x16,0x40,0xcc,0xed,0x9d,0xbc,0xf7,0xde,0x7b,0xef,0xbd, /* eVe]f.@......{.. */ \
	0xf7,0xde,0x7b,0xef,0xbd,0xf7,0xba,0x3b,0x9d,0x4e,0x27,0xf7,0xdf,0xff,0x3f,0x5c, /* ..{....;.N'...?\ */ \
	0x66,0x64,0x01,0x6c,0xf6,0xce,0x4a,0xda,0xc9,0x9e,0x21,0x80,0xaa,0xc8,0x1f,0x3f, /* fd.l..J...!....? */ \
	0x7e,0x7c,0x1f,0x3f,0x22,0xee,0x7e,0xeb,0x9b,0x78,0x7e,0xe3,0x24,0xfd,0x56,0xfa, /* ~|.?".~..x~.$.V. */ \
	0x45,0x31,0xad,0xab,0xe9,0xbc,0x58,0xa5,0x6f,0x4e,0x5e,0xde,0x3d,0x7b,0x99,0xbe, /* E1....X.oN^.={.. */ \
	0x6e,0xb3,0xe9,0xdb,0xf4,0x3b,0xd9,0x65,0xd6,0x4c,0xeb,0x62,0xd5,0xa6,0xcf,0x8b, /* n....;.e.L.b.... */ \
	0x49,0x9d,0xd5,0xd7,0x68,0xfd,0x8d,0x3c,0x00,0xc4,0x5d,0xbf,0xae,0xce,0xdb,0xab, /* I...h..<..]..... */ \
	0xac,0xce,0xa9,0x87,0x69,0xbe,0x6c,0xf2,0xf4,0xf8,0xa2,0xce,0xf3,0x45,0xbe,0x6c, /* ....i.l......E.l */ \
	0x6d,0x93,0x93,0x6a,0x75,0x5d,0x17,0x17,0xf3,0x36,0xfd,0xab,0xd3,0xbd,0x9d,0x9d, /* m..ju]...6...... */ \
	0xbd,0x6d,0xfa,0xe7,0x81,0x8f,0x73,0x3e,0x9d,0x2f,0xab,0xb2,0xba,0xb8,0x4e,0xcf, /* .m....s>./....N. */ \
	0x96,0xd3,0x71,0x9a,0x1e,0x97,0x65,0xca,0x2f,0x34,0x29,0x03,0xa8,0xf3,0x26,0xaf  /* ..q...e./4)...&. */
#define DATACHUNK000012 \
	0x2f,0xf3,0xd9,0xd8,0x82,0x74,0x2f,0x97,0xd2,0x6d,0x93,0xb6,0x55,0x7a,0x5d,0xad, /* /....t/..m..Uz]. */ \
	0xd3,0x76,0x9e,0xcb,0xbb,0xf8,0x60,0xdd,0xe4,0xa3,0x74,0x51,0xcd,0x8a,0xf3,0xeb, /* .v....`...tQ.... */ \
	0x51,0x3a,0x25,0x34,0x46,0x69,0xb6,0x9c,0x09,0xd0,0x59,0xd1,0xb4,0x75,0x31,0x59, /* Q:%4Fi....Y..u1Y */ \
	0xb7,0xf9,0x23,0xf9,0x60,0xab,0xb8,0x93,0xf2,0xeb,0x76,0x48,0x57,0xf3,0x7c,0x99, /* ..#.`.....vHW.|. */ \
	0xe6,0x8b,0x49,0x3e,0x9b,0xe5,0xb3,0xb4,0x5a,0xa6,0x99,0xd7,0xf1,0x82,0x7f,0xab, /* ..I>....Z....... */ \
	0x96,0x6d,0x5d,0x95,0x65,0x5e,0xa7,0x55,0x2d,0x60,0xf8,0x99,0x15,0x17,0x45,0x9b, /* .m].e^.U-`....E. */ \
	0x95,0x69,0x53,0x5c,0x2c,0xe9,0x87,0xd7,0x6c,0x55,0x57,0xb3,0xf5,0xb4,0x4d,0xb7, /* .iS\,...lUW...M. */ \
	0xfe,0xd4,0xa7,0xf9,0x25,0xe1,0xfe,0xa7,0xdd,0xa1,0x6e,0x8a,0xe9,0x3c,0x2d,0x74, /* ....%.....n..<-t */ \
	0xb0,0xfc,0x14,0xcb,0x36,0xbf,0xa8,0xb3,0x96,0xba,0xa5,0x5f,0x2b,0x43,0xdc,0xfc, /* ....6......_+C.. */ \
	0x4f,0x69,0x0c,0x80,0x43,0xea,0x50,0xd1,0x26,0xbc,0xbf,0x7c,0xf1,0xfc,0xf7,0x09, /* Oi..C.P.&..|.... */ \
	0x71,0x9f,0xd5,0xc5,0x25,0x75,0xd7,0x54,0xeb,0x7a,0x9a,0xa7,0xe7,0x45,0x49,0x24, /* q...%u.T.z...EI$ */ \
	0x3a,0x7d,0x71,0xb2,0x77,0xf0,0x9d,0x4f,0x77,0xc6,0x53,0x47,0x06,0x7e,0xec,0x17, /* :}q.w..Ow.SG.~.. */ \
	0xf3,0x74,0x55,0xd5,0xe8,0x95,0xfa,0xcc,0xd2,0x65,0xb5,0xdc,0x76,0x03,0x9e,0x31, /* .tU......e..v..1 */ \
	0xbe,0xa0,0x29,0x90,0xf2,0xde,0xa6,0xd1,0xfd,0xf4,0x7a,0x39,0x6d,0x0b,0xa2,0xd0, /* ..).......z9m... */ \
	0x55,0xd1,0xce,0x03,0x32,0xe5,0x84,0x55,0xbd,0xcc,0x5b,0x9f,0x06,0xe7,0x44,0x2b, /* U...2..U..[...D+ */ \
	0x20,0xeb,0x40,0x34,0x55,0x99,0xa7,0xab,0x75,0xbd,0xaa,0x88,0x83,0xaa,0x73,0x1e, /*  .@4U...u.....s. */ \
	0x7f,0x7d,0x9e,0x4d,0x8b,0xe5,0x85,0x80,0x44,0xf3,0x08,0xa8,0x31,0xc3,0x60,0x38, /* .}.M....D...1.`8 */ \
	0xbf,0x0f,0x4d,0x7e,0x33,0xaf,0xd6,0xe5,0x8c,0xf8,0xe5,0x9c,0x7a,0xa1,0x21,0xe0, /* ..M~3.......z.!. */ \
	0x2d,0x65,0x90,0x34,0x33,0x7c,0x99,0x66,0xd3,0x69,0xb5,0x58,0x65,0xcb,0x6b,0x40, /* -e.43|.f.i.Xe.k@ */ \
	0x6f,0xe7,0x86,0xf0,0x96,0x74,0x40,0x2f,0x9b,0xcd,0x0a,0x0c,0x88,0x26,0xaf,0x58, /* o....t@/.....&.X */ \
	0xd2,0x07,0x8b,0x8c,0x87,0x57,0xe7,0x17,0x59,0x3d,0xc3,0x7b,0xc4,0x6b,0xb5,0x61, /* .....W..Y=.{.k.a */ \
	0x52,0x4b,0xcc,0x6a,0x52,0x16,0x17,0xdc,0xb2,0x71,0xbc,0xfa,0xe6,0xdb,0xa7,0xe9, /* RK.jR....q...... */ \
	0xeb,0x2f,0x9f,0xbd,0xf9,0xee,0xf1,0xab,0xd3,0xf4,0xf8,0xc5,0xd3,0xf4,0xe9,0x97, /* ./.............. */ \
	0x27,0x5f,0x7d,0x71,0xfa,0xe2,0xcd,0xf1,0x9b,0xb3,0x2f,0x5f,0xa4,0xf8,0xf4,0xe5, /* '_}q....../_.... */ \
	0xab,0x2f,0x7f,0xf2,0xec,0xe9,0xe9,0xd3,0xf4,0x4f,0x3d,0x7e,0x9d,0x9e,0xbd,0xfe, /* ./.......O=~.... */ \
	0xd3,0xd2,0xef,0x9e,0xbd,0xf9,0xf6,0x97,0x5f,0xbd,0x11,0xa8,0xf4,0xe2,0xab,0xe3, /* ........_....... */ \
	0x17,0x6f,0x7e,0x9f,0xf4,0xcb,0x67,0xf4,0xfe,0xef,0x93,0xfe,0x5e,0x67,0x2f,0x9e, /* .o~...g.....^g/. */ \
	0x8e,0xd2,0x53,0x6a,0x72,0xfa,0x2a,0x3d,0xfd,0xbd,0x5f,0xbe,0x3a,0x7d,0xfd,0x3a, /* ..Sjr..=.._.:}.: */ \
	0xfd,0xf2,0x55,0x7a,0xf6,0xc5,0xcb,0xe7,0x67,0xa7,0xf4,0xd5,0xd9,0x8b,0x93,0xe7, /* ..Uz....g....... */ \
	0x5f,0x3d,0x3d,0x7b,0xf1,0x79,0x08,0xe7,0xf9,0xd9,0x17,0x67,0xd2,0xe9,0x88,0xe1, /* _=={.y.....g.... */ \
	0xf8,0x70,0xbf,0x38,0x7d,0x75,0xf2,0x6d,0xfa,0xe3,0xf8,0xc9,0xd9,0xf3,0xb3,0x37, /* .p.8}u.m.......7 */ \
	0xbf,0xcf,0x28,0x7d,0x76,0xf6,0xe6,0x05,0xe0,0x3e,0x23,0xc0,0xc7,0xf2,0xfe,0xcb, /* ..(}v....>#..... */ \
	0xe3,0x57,0x6f,0xce,0x4e,0xbe,0x7a,0x7e,0xfc,0x2a,0x7d,0xf9,0xd5,0xab,0x97,0x5f, /* .Wo.N.z~..}...._ */ \
	0xbe,0x3e,0x1d,0xa5,0x6f,0xce,0xde,0x3c,0x97,0x51,0xbd,0xf8,0xf2,0xc5,0xf6,0xd9, /* .>..o..<.Q...... */ \
	0x8b,0x67,0xaf,0xa8,0xdb,0x53,0x8c,0x6e,0x4c,0x68,0xd0,0x87,0xe9,0xe9,0x4f,0xd2, /* .g...S.nLh....O. */ \
	0x1f,0xe9,0xeb,0x6f,0x1f,0x3f,0x7f,0x2e,0x60,0xbe,0x38,0x3b,0x79,0xf5,0xe5,0xc9, /* ...o.?..`.8;y... */ \
	0xb7,0x49,0x4b,0x3d,0x39,0x25,0x9c,0x8e,0x9f,0x10,0x00,0xee,0x85,0x50,0x22,0xcc, /* .IK=9%.......P". */ \
	0x89,0x0e,0x84,0xc6,0xf3,0x51,0xfa,0xfa,0xe5,0xe9,0xc9,0x19,0x7e,0xa1,0xe1,0x9e, /* .....Q......~... */ \
	0xbd,0x3a,0x3d,0x79,0x83,0x31,0x8a,0x42,0xf9,0xf2,0xc5,0xeb,0xd3,0x9f,0xf8,0x8a, /* .:=y.1.B........ */ \
	0xda,0xd1,0xf7,0xe9,0xd3,0xe3,0x2f,0x8e,0x3f,0x3f,0x7d,0x3d,0x4a,0x9f,0x7f,0xf9, /* ....../.??}=J... */ \
	0xfa,0x0d,0x48,0x49,0xa8,0x33,0x3d,0xf8,0xef,0xa7,0xc7,0x6f,0x8e,0x47,0xf4,0x06, /* ..HI.3=....o.G.. */ \
	0xfd,0x4a,0xc3,0x94,0x71,0x50,0xf7,0x5f,0xbd,0x62,0x24,0xf1,0xd9,0xeb,0xaf,0x9e, /* .J..qP._.b$..... */ \
	0xbc,0xa6,0x61,0x7c,0xf5,0xe6,0x34,0xfd,0xfc,0xcb,0x2f,0x9f,0x12,0xa0,0x37,0xa7, /* ..a|..4.../...7. */ \
	0x27,0xdf,0x7e,0xf1,0xe5,0xf3,0x2f,0x3f,0xff,0x7d,0x00,0xe6,0xf5,0xe9,0xab,0x9f, /* '.~.../?.}...... */ \
	0x3c,0x3b,0x41,0x07,0xc0,0xf0,0xe4,0xf9,0xf1,0xd9,0x17,0xaf,0x05,0xd0,0x93,0xdf, /* <;A............. */ \
	0x87,0x26,0xf7,0xec,0xd5,0x53,0xa1,0xcc,0xe9,0xeb,0x74,0xcb,0x51,0xfe,0x09,0x51, /* .&...S....t.Q..Q */ \
	0xfd,0xc5,0x97,0x6f,0x84,0xe8,0x34,0xb3,0x6f,0xbe,0xe4,0xd7,0x9f,0x9e,0x3e,0x3b, /* ...o..4.o.....>; */ \
	0x25,0xe4,0xe5,0x7d,0x4c,0xe0,0xe9,0x97,0xcf,0xee,0x04,0x90,0x41,0x0a,0x1a,0xf1, /* %..}L.......A... */ \
	0xe9,0x17,0x2f,0xce,0x30,0x35,0xaf,0x30,0xda,0x37,0xaf,0xce,0x08,0x1e,0x4f,0x1c, /* ../.05.0.7....O. */ \
	0x7d,0xf0,0x25,0x4f,0xbc,0xf0,0x2c,0x41,0xc7,0x7c,0x60,0x7c,0x84,0xe0,0x77,0xbf, /* }.%O..,A.|`|..w. */ \
	0x7d,0xca,0xdf,0x1d,0xbf,0x26,0xa4,0xd1,0x2b,0xf1,0x17,0xd8,0xef,0xc9,0xf1,0xeb, /* }....&..+....... */ \
	0xb3,0xd7,0x18,0x2b,0xc3,0x3a,0x3e,0x79,0x43,0x63,0xfc,0xf2,0x95,0xb2,0x85,0x87, /* ...+.:>yCc...... */ \
	0xf4,0x8b,0xd3,0xcf,0x9f,0x9f,0x7d,0x4e,0xda,0xe0,0x94,0x70,0x7a,0xf2,0xea,0xf4, /* ......}N...pz... */ \
	0xf8,0xe4,0xdb,0x78,0xcb,0x30,0x8a,0xeb,0xfd,0xbb,0x67,0xaf,0x4f,0x2d,0x87,0x33, /* ...x.0....g.O-.3 */ \
	0x94,0xe3,0x75,0x3b,0x27,0xb9,0x09,0x9f,0xa7,0xa4,0xc1,0xcc,0xef,0x27,0xd5,0xc2, /* ..u;'........'.. */ \
	0x58,0x85,0x5f,0xfa,0x0d,0x3c,0xdc,0xe9,0x69,0x59,0x16,0x55,0xdb,0xa6,0xdf,0xad, /* X._..<..iY.U.... */ \
	0xaa,0xd9,0x8f,0xfd,0xd8,0x8f,0x7d,0x7a,0x77,0xef,0xfe,0xdd,0x9d,0x07,0x3f,0xf6, /* ......}zw.....?. */ \
	0x63,0x5f,0x92,0x60,0x16,0x24,0xbb,0xb1,0x46,0xbb,0x7b,0x77,0xa5,0xd1,0x57,0xab, /* c_.`.$..F.{w..W. */ \
	0x19,0x2b,0xd8,0x65,0x7e,0x75,0xfc,0x9d,0xe3,0xdf,0x1b,0xf8,0x91,0x20,0xe3,0x95, /* .+.e~u....... .. */ \
	0x6f,0xe0,0xb9,0xfb,0x1b,0x27,0xbf,0x71,0x72,0x57,0xcd,0xf3,0xd3,0x9c,0xb4,0xd9, /* o....'.qrW...... */ \
	0xa2,0x58,0x92,0x0a,0x66,0x93,0x92,0x91,0x1e,0xf9,0x45,0xeb,0xbc,0x69,0xa1,0xf4, /* .X..f.....E..i.. */ \
	0x49,0x99,0x35,0xc5,0x2c,0xaf,0x09,0x93,0x8f,0xda,0x62,0x01,0x43,0xb3,0x6e,0x3f, /* I.5.,.....b.C.n? */ \
	0xc2,0x7b,0x04,0xe3,0x32,0x23,0x3d,0x46,0x1f,0x7e,0xb9,0x6e,0x89,0x35,0x3e,0x4b, /* .{..2#=F.~.n.5>K */ \
	0xef,0xef,0xec,0xec,0x1c,0xa6,0x77,0xef,0x2e,0x1a,0x6a,0xe0,0x3a,0x78,0xdd,0x56  /* ......w...j.:x.V */
#define DATACHUNK000013 \
	0x64,0x23,0x09,0x2e,0x41,0x5d,0xb3,0x02,0xc5,0x88,0xd2,0xfc,0x92,0x08,0xce,0x96, /* d#..A].......... */ \
	0x91,0x8c,0xc6,0x34,0x6f,0x1a,0x0f,0x6a,0xf6,0xd3,0xd9,0xbb,0xe7,0x64,0x02,0x09, /* ...4o..j.....d.. */ \
	0x28,0x11,0x20,0x3d,0xae,0xeb,0xec,0x7a,0xeb,0xce,0xa1,0x8f,0xf6,0xd9,0x92,0x54, /* (. =...z.......T */ \
	0x20,0x91,0x08,0x80,0xb9,0x0d,0x60,0x4e,0x1d,0x99,0xb8,0xd1,0xef,0xb9,0xca,0xea, /*  .....`N........ */ \
	0x6c,0x91,0x8a,0xe5,0x5c,0xd7,0x25,0x5b,0x8e,0xa9,0xe9,0x2c,0xfc,0x7a,0x56,0x4d, /* l...\.%[...,.zVM */ \
	0xd7,0xac,0x81,0xcf,0x9e,0xa2,0x19,0x19,0xa5,0x72,0x04,0xbb,0x99,0xa5,0xe7,0xc6, /* .........r...... */ \
	0x7e,0xd0,0xc7,0xd3,0x8c,0xcc,0x3f,0x2b,0x7d,0x1a,0xd3,0xaa,0x82,0xee,0xfe,0xbd, /* ~.....?+}....... */ \
	0xbf,0x78,0x9e,0x6e,0x55,0x2b,0x51,0xc8,0x77,0x3c,0xc0,0x3f,0xd6,0xd6,0x34,0x5e, /* .x.nU+Q.w<.?..4^ */ \
	0x7a,0xa9,0xce,0x57,0x79,0xd6,0x8a,0x36,0x67,0x00,0xc5,0x72,0x96,0x9f,0x17,0x34, /* z..Wy..6g..r...4 */ \
	0x82,0xbc,0xbc,0x8e,0xbf,0x4b,0x48,0x65,0xe9,0x57,0xaf,0x9e,0xa7,0xf9,0x72,0x5a, /* .....KHe.W....rZ */ \
	0xc1,0xc0,0xc3,0x1f,0x80,0x45,0xa8,0xd2,0x49,0x9e,0x36,0xeb,0xc9,0xa2,0x68,0xc1, /* .....E..I.6...h. */ \
	0x1f,0x59,0x93,0xbe,0x84,0xfa,0x20,0x6e,0xc9,0x3a,0x90,0x88,0x96,0x16,0xf3,0x90, /* .Y.... n.:...... */ \
	0x8d,0xb6,0x88,0x14,0x23,0x36,0x54,0x19,0xcd,0x7b,0x3d,0x52,0x04,0x47,0x0c,0x85, /* ....#6T..{=R.G.. */ \
	0xde,0xfd,0xc5,0xbf,0x71,0xf2,0x63,0x77,0xef,0xa6,0xaf,0xc9,0x9a,0xad,0x57,0x29, /* ....q.cw......W) */ \
	0x6c,0x49,0x35,0xf9,0xe9,0x7c,0x4a,0xe2,0xf1,0x63,0x98,0x1d,0x00,0xa3,0x09,0xd2, /* lI5..|J..c...... */ \
	0xc9,0xf9,0x92,0xbf,0xe2,0xd9,0xe1,0x6f,0x89,0x96,0x6f,0x88,0x29,0x6a,0xfd,0x1a, /* .......o..o.)j.. */ \
	0x52,0x26,0x5f,0xea,0x6b,0x63,0xcc,0xc3,0x67,0x98,0x0d,0xff,0x43,0x8b,0x0c,0x7d, /* R&_.kc..g...C..} */ \
	0x65,0x7f,0xf7,0x1b,0x28,0x0d,0x3f,0x53,0x5c,0xfd,0xaf,0xc0,0x2d,0xaf,0xf2,0x5f, /* e...(.?S\...-.._ */ \
	0x84,0x0e,0xd7,0x25,0x43,0x15,0xfc,0x4f,0xea,0x1c,0x22,0x0e,0x03,0xd8,0xe4,0xf4, /* ...%C..O.."..... */ \
	0x0f,0x7b,0x5f,0xc2,0xdb,0xd4,0xa0,0x38,0xdf,0xba,0xa2,0x79,0xa8,0xae,0xc6,0x34, /* .{_....8...y...4 */ \
	0x81,0xdf,0x6e,0xdb,0xd5,0x2b,0xf9,0xea,0x4e,0x4a,0xc3,0x37,0x7a,0x21,0xd2,0x05, /* ..n..+..NJ.7z!.. */ \
	0x8d,0x29,0x7c,0x81,0x47,0x37,0xf0,0xc2,0xb8,0x5a,0xe5,0xcb,0xad,0x2d,0xd0,0xf5, /* .)|.G7...Z...-.. */ \
	0xb3,0xcf,0x80,0xdd,0x9d,0xdf,0xe3,0xa3,0xcf,0x4f,0xdf,0x7c,0xf4,0xe8,0x23,0xcc, /* .........O.|..#. */ \
	0xda,0x47,0x23,0xdb,0x9e,0x67,0x04,0xfc,0xb2,0x09,0x18,0x46,0xc1,0xb0,0x4c,0x23, /* .G#..g.....F..L# */ \
	0x1a,0xe4,0xd9,0x79,0x7a,0x95,0x7f,0x5c,0xc3,0xf5,0x01,0x7f,0x9c,0x9d,0x7e,0x4a, /* ...yz..\......~J */ \
	0xac,0x72,0x4d,0x0e,0xcb,0xd6,0x22,0xbb,0x26,0x56,0xb9,0x3f,0xbe,0x9f,0xb2,0x47, /* .rM...".&V.?...G */ \
	0xd1,0x16,0x93,0x12,0xdc,0x58,0xdd,0x91,0x77,0x7f,0x49,0x9a,0x97,0xc4,0xbd,0x8e, /* .....X..w.I..... */ \
	0x0c,0xc7,0xc4,0x2a,0x97,0xf9,0xef,0x2d,0xf3,0x79,0x0b,0x2a,0x04,0xed,0xb7,0x3e, /* .......-.y.....> */ \
	0x62,0xaf,0xaa,0x21,0x37,0x85,0xe9,0xf9,0xe6,0xcd,0xcb,0x8f,0xfc,0xa1,0x50,0x37, /* b..!7.........P7 */ \
	0x1d,0x28,0x41,0x0f,0xdf,0x38,0xe9,0x62,0x00,0x7b,0xe4,0xc3,0xf3,0x4b,0x94,0x1a, /* .(A..8.b.{...K.. */ \
	0xf2,0x43,0xfe,0x35,0x2f,0x96,0x59,0xd3,0x9e,0x90,0xbc,0x92,0x9c,0x7d,0x66,0xf9, /* .C.5/.Y......}f. */ \
	0x7a,0x7c,0x91,0xb7,0xf8,0xc5,0x4e,0xbb,0x9d,0x0a,0x56,0x74,0xf0,0x3e,0x21,0x31, /* z|....N...Vt.>!1 */ \
	0x19,0x74,0x96,0x7c,0x65,0xb4,0xd9,0x78,0xb5,0x6e,0xe6,0x86,0x0c,0x78,0xfb,0x97, /* .t.|e..x.n...x.. */ \
	0xf8,0x0a,0xed,0x79,0x55,0xad,0x9a,0xb4,0x82,0x5f,0x0c,0x15,0x41,0x83,0x67,0x57, /* ...yU...._..A.gW */ \
	0xae,0xa3,0x2b,0x67,0x46,0x5b,0xf3,0x3b,0xc5,0x39,0x71,0xf7,0x35,0xa9,0x34,0x16, /* ..+gF[.;.9q.5.4. */ \
	0x72,0xd2,0x2e,0x60,0xef,0x82,0xb4,0x75,0x57,0xfe,0x57,0xe4,0x90,0x02,0xd2,0x16, /* r..`...uW.W..... */ \
	0x53,0x1d,0xf2,0x01,0x51,0x9d,0xae,0xeb,0xaf,0x23,0xc8,0xf8,0x32,0x2f,0xb3,0x15, /* S...Q....#..2/.. */ \
	0xf9,0xda,0x4e,0xd8,0x5e,0xe5,0x19,0x19,0x87,0xf3,0x73,0x96,0x32,0xab,0xbf,0x45, /* ..N.^.....s.2..E */ \
	0x6f,0xd0,0xb0,0x96,0x79,0x3a,0xb9,0xc6,0x0f,0x6a,0x4d,0x1e,0xeb,0x56,0x41,0x50, /* o...y:...jM..VAP */ \
	0x2d,0x5d,0xca,0x7c,0x79,0xd1,0xce,0x0f,0xd3,0x22,0x3d,0x4a,0xc9,0x82,0x14,0xdb, /* -].|y...."=J.... */ \
	0xdb,0xc4,0xa3,0x3f,0x06,0x44,0x7f,0xcc,0xa1,0x68,0x5b,0x37,0xf3,0xe2,0x5c,0xd1, /* ...?.D...h[7..\. */ \
	0x84,0x10,0xff,0xae,0xda,0x04,0xaf,0x50,0x7b,0xd2,0x1d,0xc5,0x72,0x9d,0xf3,0xb7, /* .......P{...r... */ \
	0x8a,0x64,0x74,0xf2,0xd2,0x6d,0x33,0x7c,0x6f,0x9a,0xf9,0xad,0x1f,0xc3,0x88,0x7e, /* .dt..m3|o......~ */ \
	0xcc,0x88,0x16,0xe9,0xda,0x69,0x9e,0xcf,0x40,0x52,0xee,0xce,0xbc,0x64,0x98,0x8a, /* .....i..@R...d.. */ \
	0x74,0xcc,0xec,0x9a,0x22,0x5a,0x52,0x34,0x9f,0x7d,0x96,0xee,0xa7,0xbf,0xf0,0x17, /* t..."ZR4.}...... */ \
	0x5a,0xb8,0x96,0xef,0xe8,0xdb,0x75,0x83,0xaf,0x29,0xb6,0x94,0x09,0x30,0xf0,0x8b, /* Z.....u..)...0.. */ \
	0x36,0x9d,0x67,0x30,0x61,0x9e,0x32,0xbe,0xaa,0xc9,0x2e,0xa8,0xb2,0x6a,0xd6,0x65, /* 6.g0a.2......j.e */ \
	0xcb,0xcd,0xa9,0xe7,0xf6,0x7a,0x95,0x57,0x0e,0x01,0xfb,0xc6,0x1d,0x40,0xfe,0xd8, /* .....z.W.....@.. */ \
	0x4c,0xf5,0xc7,0x77,0x04,0xbe,0xa1,0x9c,0x6b,0x17,0x41,0x5d,0x2c,0x18,0xc9,0xeb, /* L..w....k.A],... */ \
	0xd8,0x58,0xbf,0xd3,0x92,0xc3,0x10,0xa1,0xee,0x8f,0x39,0x1d,0xb1,0xb9,0x73,0x31, /* .X........9...s1 */ \
	0x4e,0x1f,0x9b,0xb1,0xfd,0x98,0x81,0x06,0x72,0x2b,0xc4,0x27,0xd7,0x67,0xb3,0xc8, /* N.......r+.'.g.. */ \
	0xeb,0xe3,0x62,0x49,0x3f,0xbe,0xfd,0x86,0x6c,0xe8,0x67,0x3d,0xc2,0x19,0x04,0xdf, /* ..bI?...l.g=.... */ \
	0xe4,0xef,0x5a,0x83,0x10,0xd1,0x6d,0xab,0x42,0xac,0x75,0x55,0x34,0x30,0xda,0x14, /* ..Z...m.B.uU40.. */ \
	0x07,0x92,0x5d,0x25,0x41,0x41,0x60,0x04,0x35,0x91,0x5e,0x66,0x25,0xa9,0x65,0x61, /* ..]%AA`.5.^f%.ea */ \
	0x07,0xfa,0x07,0x12,0x68,0x89,0x61,0x20,0x67,0x13,0x8a,0x24,0x85,0x87,0x62,0xdf, /* ....h.a g..$..b. */ \
	0x3b,0x53,0x12,0xcc,0xd5,0xc7,0x0d,0x7b,0x47,0xb0,0x3f,0x19,0x94,0xa9,0x1a,0x93, /* ;S.....{G.?..... */ \
	0x11,0x26,0x6b,0x09,0x5c,0x9a,0xca,0x4c,0x96,0x01,0x28,0xad,0x05,0x19,0x36,0x58, /* .&k.\..L..(...6X */ \
	0x9e,0x15,0x36,0x6d,0xc4,0x1a,0x77,0x49,0xe3,0x3e,0x52,0x18,0x42,0x81,0x80,0xc1, /* ..6m..wI.>R.B... */ \
	0x7f,0x09,0xfe,0xf1,0xb9,0xf5,0xe3,0x4b,0x4a,0x0c,0x64,0x05,0x3c,0x03,0xd6,0x24, /* .......KJ.d.<..$ */ \
	0xbb,0x64,0xf9,0xe8,0x8d,0x99,0xa2,0x48,0xec,0x6c,0xbd,0x38,0xe5,0x67,0x23,0x23, /* .d.....H.l.8.g## */ \
	0x47,0xce,0x95,0xf3,0x59,0x74,0x79,0x59,0xbd,0x15,0x66,0xa4,0xd0,0xba,0x76,0xae, /* G...YtyY..f...v. */ \
	0x10,0xbb,0x40,0x4c,0xee,0x62,0xb9,0x5a,0x7f,0x73,0x3c,0xca,0x8a,0x3e,0x60,0x3e, /* ..@L.b.Z.s<..>`> */ \
	0x6d,0x4a,0xc8,0x1c,0x53,0x4c,0xdd,0x5a,0x5c,0xe4,0xe3,0x0c,0x9f,0x6d,0x7d,0xa4, /* mJ..SL.Z\....m}. */ \
	0x24,0x4d,0xcf,0x33,0xca,0x25,0xcc,0xc6,0xbf,0xef,0xf2,0xa4,0x22,0xbe,0xb2,0x5e  /* $M.3.%......"..^ */
#define DATACHUNK000014 \
	0x1b,0x65,0x07,0xf2,0xb2,0x5a,0xb1,0x7b,0x37,0xa9,0x28,0x48,0x26,0x22,0x35,0x69, /* .e...Z.{7.(H&"5i */ \
	0x59,0x91,0x36,0xf9,0xc8,0xf4,0xc6,0x73,0xfd,0x61,0xcc,0xa2,0xaa,0xe3,0xff,0x1b, /* Y.6....s.a...... */ \
	0xfc,0xf2,0xa5,0x11,0xa2,0x51,0xfa,0xd3,0x6b,0x52,0xd5,0x6f,0xf3,0x7c,0xc5,0xbc, /* .....Q..kR.o.|.. */ \
	0x43,0xc2,0x84,0x26,0x18,0x9d,0xb3,0x5a,0x46,0xc9,0x02,0x0c,0xa0,0xfc,0xc6,0xe2, /* C..&...ZF....... */ \
	0x61,0xc1,0x52,0x91,0xb5,0x6b,0xf2,0xf2,0x12,0x9e,0xf8,0x05,0x61,0x02,0x03,0xb8, /* a.R..k......a... */ \
	0xbb,0x83,0x18,0xe0,0xc7,0x1a,0x51,0xb6,0xc4,0x6c,0x5b,0x1f,0x39,0x0b,0xf4,0xd1, /* ......Q..l[.9... */ \
	0x68,0x77,0x87,0xe1,0x90,0x01,0x24,0x18,0xa7,0x34,0x6d,0xfc,0x25,0x81,0x57,0x12, /* hw....$..4m.%.W. */ \
	0x1a,0x93,0xf8,0x32,0xab,0x39,0x79,0x46,0x33,0xfe,0x6e,0x51,0xbe,0x32,0x0e,0x77, /* ...2.9yF3.nQ.2.w */ \
	0x9d,0xb7,0x6b,0x4a,0xb5,0xcc,0x60,0x51,0xb2,0x65,0xaa,0xee,0x86,0x7a,0x63,0xd6, /* ..kJ..`Q.e...zc. */ \
	0x55,0x0d,0x42,0x80,0x1f,0x53,0x18,0x4f,0xe1,0x26,0x9b,0xf7,0xbb,0xdf,0x9f,0x17, /* U.B..S.O.&...... */ \
	0x79,0xc9,0xc9,0xa5,0x26,0xcf,0x6a,0x4a,0x7a,0x9d,0x4b,0x12,0xcb,0xb7,0xa3,0xa4, /* y...&.jJz.K..... */ \
	0xcf,0xa8,0xbb,0x9f,0x84,0x86,0xd9,0x52,0x70,0x23,0x79,0x4f,0x84,0xa6,0xad,0xaf, /* .......Rp#yO.... */ \
	0x85,0x61,0x69,0x4a,0xf5,0x7b,0x4f,0x07,0x36,0x4f,0xae,0xdf,0x64,0x17,0x2f,0x32, /* .aiJ.{O.6O..d./2 */ \
	0xb2,0x3f,0xf2,0xce,0xf7,0x76,0xbe,0x3f,0x3e,0x2f,0x6a,0x32,0x3f,0xf3,0xa2,0x9c, /* .?...v.?>/j2?... */ \
	0x8d,0x97,0xe4,0xe9,0x33,0x6c,0x99,0x7f,0xc1,0xd3,0xa0,0xfd,0x75,0xe0,0xa8,0x15, /* ....3l......u... */ \
	0x6c,0x72,0x1f,0x9e,0x61,0xd6,0x5f,0x42,0xb1,0x48,0x3b,0x9d,0x6f,0xe5,0x35,0x89, /* lr..a._B.H;.o.5. */ \
	0xe7,0x2f,0x56,0xaa,0xc8,0xb7,0x70,0x87,0xc4,0x39,0xb9,0xfb,0xb6,0xa0,0x5c,0xad, /* ./V...p..9....\. */ \
	0xb1,0xeb,0xec,0x8c,0x48,0x68,0x4a,0xa4,0x19,0x9a,0x5e,0x8a,0x03,0x25,0x56,0xfb, /* ....HhJ...^..%V. */ \
	0x7f,0x00,0x8a,0xb4,0xf6,0x78,0x45,0x16,0x00,0x00,0x2b,0x10,0x06,0x10,0x01,0x10, /* .....xE...+..... */ \
	0x02,0x18,0x59,0x00,0x01,0x10,0x01,0x10,0x01,0x0a,0x17,0x00,0x03,0x03,0x50,0x49, /* ..Y...........PI */ \
	0x43,0x02,0xca,0xff,0x26,0x00,0x09,0x08,0x2b,0x06,0x01,0x04,0x01,0x81,0x85,0x47, /* C...&...+......G */ \
	0x03,0x88,0xfa,0x2c,0x00,0x07,0x04,0x0a,0x37,0x00,0x03,0x05,0x61,0x64,0x6d,0x69, /* ...,....7...admi */ \
	0x6e,0x05,0x0a,0x46,0x00,0x03,0x09,0x4d,0x69,0x63,0x72,0x6f,0x63,0x68,0x69,0x70, /* n..F...Microchip */ \
	0x06,0x0a,0x52,0x00,0x03,0x06,0x6f,0x66,0x66,0x69,0x63,0x65,0x07,0x03,0x67,0x00, /* ..R...office..g. */ \
	0x00,0x01,0x07,0x04,0x10,0x01,0x10,0x81,0x10,0x85,0x10,0x47,0x10,0x01,0x18,0x92, /* ...........G.... */ \
	0x00,0x01,0x0a,0x7a,0x00,0x03,0x0d,0x53,0x4e,0x4d,0x50,0x76,0x32,0x63,0x20,0x41, /* ...z...SNMPv2c A */ \
	0x67,0x65,0x6e,0x74,0x02,0x0a,0x84,0x00,0x03,0x04,0x76,0x35,0x2e,0x30,0x03,0x03, /* gent......v5.0.. */ \
	0x9a,0x00,0x03,0x08,0x41,0x70,0x72,0x20,0x32,0x30,0x30,0x39,0x02,0x18,0xc2,0x00, /* ....Apr 2009.... */ \
	0x01,0x10,0x01,0x10,0x01,0xac,0x01,0xa4,0x00,0x00,0x01,0x01,0x01,0x00,0x02,0xac, /* ................ */ \
	0x02,0xae,0x00,0x00,0x01,0x01,0x01,0x00,0x03,0xac,0x03,0xb8,0x00,0x05,0x01,0x01, /* ................ */ \
	0x01,0x00,0x04,0xa5,0x04,0xc4,0x00,0x04,0x01,0x01,0x01,0x00,0x03,0x10,0x01,0xa8, /* ................ */ \
	0x05,0xca,0x00,0x00,0x02,0xa8,0x06,0xd0,0x00,0x00,0x03,0x88,0x07,0xd6,0x00,0x00, /* ................ */ \
	0x04,0x88,0x08,0xdc,0x00,0x01,0x06,0xa0,0x0a,0x04,0x3c,0x72,0x65,0x73,0x70,0x6f, /* ..........<respo */ \
	0x6e,0x73,0x65,0x3e,0x0d,0x0a,0x3c,0x6c,0x65,0x64,0x30,0x3e,0x7e,0x6c,0x65,0x64, /* nse>..<led0>~led */ \
	0x28,0x30,0x29,0x7e,0x3c,0x2f,0x6c,0x65,0x64,0x30,0x3e,0x0d,0x0a,0x3c,0x6c,0x65, /* (0)~</led0>..<le */ \
	0x64,0x31,0x3e,0x7e,0x6c,0x65,0x64,0x28,0x31,0x29,0x7e,0x3c,0x2f,0x6c,0x65,0x64, /* d1>~led(1)~</led */ \
	0x31,0x3e,0x0d,0x0a,0x3c,0x6c,0x65,0x64,0x32,0x3e,0x7e,0x6c,0x65,0x64,0x28,0x32, /* 1>..<led2>~led(2 */ \
	0x29,0x7e,0x3c,0x2f,0x6c,0x65,0x64,0x32,0x3e,0x0d,0x0a,0x3c,0x6c,0x65,0x64,0x33, /* )~</led2>..<led3 */ \
	0x3e,0x7e,0x6c,0x65,0x64,0x28,0x33,0x29,0x7e,0x3c,0x2f,0x6c,0x65,0x64,0x33,0x3e, /* >~led(3)~</led3> */ \
	0x0d,0x0a,0x3c,0x6c,0x65,0x64,0x34,0x3e,0x7e,0x6c,0x65,0x64,0x28,0x34,0x29,0x7e, /* ..<led4>~led(4)~ */ \
	0x3c,0x2f,0x6c,0x65,0x64,0x34,0x3e,0x0d,0x0a,0x3c,0x6c,0x65,0x64,0x35,0x3e,0x7e, /* </led4>..<led5>~ */ \
	0x6c,0x65,0x64,0x28,0x35,0x29,0x7e,0x3c,0x2f,0x6c,0x65,0x64,0x35,0x3e,0x0d,0x0a, /* led(5)~</led5>.. */ \
	0x3c,0x6c,0x65,0x64,0x36,0x3e,0x7e,0x6c,0x65,0x64,0x28,0x36,0x29,0x7e,0x3c,0x2f, /* <led6>~led(6)~</ */ \
	0x6c,0x65,0x64,0x36,0x3e,0x0d,0x0a,0x3c,0x6c,0x65,0x64,0x37,0x3e,0x7e,0x6c,0x65, /* led6>..<led7>~le */ \
	0x64,0x28,0x37,0x29,0x7e,0x3c,0x2f,0x6c,0x65,0x64,0x37,0x3e,0x0d,0x0a,0x3c,0x62, /* d(7)~</led7>..<b */ \
	0x74,0x6e,0x30,0x3e,0x7e,0x62,0x74,0x6e,0x28,0x30,0x29,0x7e,0x3c,0x2f,0x62,0x74, /* tn0>~btn(0)~</bt */ \
	0x6e,0x30,0x3e,0x0d,0x0a,0x3c,0x62,0x74,0x6e,0x31,0x3e,0x7e,0x62,0x74,0x6e,0x28, /* n0>..<btn1>~btn( */ \
	0x31,0x29,0x7e,0x3c,0x2f,0x62,0x74,0x6e,0x31,0x3e,0x0d,0x0a,0x3c,0x62,0x74,0x6e, /* 1)~</btn1>..<btn */ \
	0x32,0x3e,0x7e,0x62,0x74,0x6e,0x28,0x32,0x29,0x7e,0x3c,0x2f,0x62,0x74,0x6e,0x32, /* 2>~btn(2)~</btn2 */ \
	0x3e,0x0d,0x0a,0x3c,0x62,0x74,0x6e,0x33,0x3e,0x7e,0x62,0x74,0x6e,0x28,0x33,0x29, /* >..<btn3>~btn(3) */ \
	0x7e,0x3c,0x2f,0x62,0x74,0x6e,0x33,0x3e,0x0d,0x0a,0x3c,0x70,0x6f,0x74,0x30,0x3e, /* ~</btn3>..<pot0> */ \
	0x7e,0x70,0x6f,0x74,0x7e,0x3c,0x2f,0x70,0x6f,0x74,0x30,0x3e,0x0d,0x0a,0x3c,0x2f, /* ~pot~</pot0>..</ */ \
	0x72,0x65,0x73,0x70,0x6f,0x6e,0x73,0x65,0x3e,0x0d,0x0a,0x12,0x00,0x00,0x00,0x17, /* response>....... */ \
	0x00,0x00,0x00,0x29,0x00,0x00,0x00,0x0c,0x00,0x00,0x00,0x40,0x00,0x00,0x00,0x0b, /* ...).......@.... */ \
	0x00,0x00,0x00,0x57,0x00,0x00,0x00,0x0a,0x00,0x00,0x00,0x6e,0x00,0x00,0x00,0x09, /* ...W.......n.... */ \
	0x00,0x00,0x00,0x85,0x00,0x00,0x00,0x08,0x00,0x00,0x00,0x9c,0x00,0x00,0x00,0x07, /* ................ */ \
	0x00,0x00,0x00,0xb3,0x00,0x00,0x00,0x06,0x00,0x00,0x00,0xca,0x00,0x00,0x00,0x18, /* ................ */ \
	0x00,0x00,0x00,0xe1,0x00,0x00,0x00,0x19,0x00,0x00,0x00,0xf8,0x00,0x00,0x00,0x1a, /* ................ */ \
	0x00,0x00,0x00,0x0f,0x01,0x00,0x00,0x1b,0x00,0x00,0x00,0x26,0x01,0x00,0x00,0x1c, /* ...........&.... */ \
	0x00,0x00,0x00,0x7e,0x69,0x6e,0x63,0x3a,0x68,0x65,0x61,0x64,0x65,0x72,0x2e,0x69, /* ...~inc:header.i */ \
	0x6e,0x63,0x7e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x20,0x69,0x64,0x3d,0x22,0x63,0x6f, /* nc~..<div id="co */ \
	0x6e,0x74,0x65,0x6e,0x74,0x22,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x68,0x31,0x3e,0x46, /* ntent">....<h1>F */ \
	0x69,0x6c,0x65,0x20,0x55,0x70,0x6c,0x6f,0x61,0x64,0x73,0x3c,0x2f,0x68,0x31,0x3e, /* ile Uploads</h1> */ \
	0x0d,0x0a,0x0d,0x0a,0x3c,0x70,0x3e,0x54,0x68,0x65,0x20,0x48,0x54,0x54,0x50,0x20  /* ....<p>The HTTP  */
#define DATACHUNK000015 \
	0x73,0x65,0x72,0x76,0x65,0x72,0x20,0x63,0x61,0x6e,0x20,0x61,0x63,0x63,0x65,0x70, /* server can accep */ \
	0x74,0x20,0x66,0x69,0x6c,0x65,0x20,0x75,0x70,0x6c,0x6f,0x61,0x64,0x73,0x20,0x76, /* t file uploads v */ \
	0x69,0x61,0x20,0x50,0x4f,0x53,0x54,0x2e,0x20,0x20,0x54,0x68,0x69,0x73,0x20,0x63, /* ia POST.  This c */ \
	0x61,0x6e,0x20,0x62,0x65,0x20,0x75,0x73,0x65,0x64,0x20,0x66,0x6f,0x72,0x20,0x0d, /* an be used for . */ \
	0x0a,0x6d,0x61,0x6e,0x79,0x20,0x61,0x70,0x70,0x6c,0x69,0x63,0x61,0x74,0x69,0x6f, /* .many applicatio */ \
	0x6e,0x73,0x20,0x73,0x75,0x63,0x68,0x20,0x61,0x73,0x20,0x61,0x6c,0x6c,0x6f,0x77, /* ns such as allow */ \
	0x69,0x6e,0x67,0x20,0x75,0x73,0x65,0x72,0x73,0x20,0x74,0x6f,0x20,0x75,0x70,0x6c, /* ing users to upl */ \
	0x6f,0x61,0x64,0x20,0x63,0x6f,0x6e,0x66,0x69,0x67,0x75,0x72,0x61,0x74,0x69,0x6f, /* oad configuratio */ \
	0x6e,0x20,0x73,0x65,0x74,0x74,0x69,0x6e,0x67,0x73,0x20,0x66,0x69,0x6c,0x65,0x73, /* n settings files */ \
	0x2e,0x0d,0x0a,0x45,0x61,0x63,0x68,0x20,0x61,0x70,0x70,0x6c,0x69,0x63,0x61,0x74, /* ...Each applicat */ \
	0x69,0x6f,0x6e,0x20,0x6d,0x75,0x73,0x74,0x20,0x69,0x6d,0x70,0x6c,0x65,0x6d,0x65, /* ion must impleme */ \
	0x6e,0x74,0x20,0x69,0x74,0x73,0x20,0x6f,0x77,0x6e,0x20,0x66,0x69,0x6c,0x65,0x20, /* nt its own file  */ \
	0x70,0x72,0x6f,0x63,0x65,0x73,0x73,0x6f,0x72,0x2e,0x20,0x20,0x54,0x68,0x69,0x73, /* processor.  This */ \
	0x20,0x65,0x78,0x61,0x6d,0x70,0x6c,0x65,0x20,0x0d,0x0a,0x63,0x61,0x6c,0x63,0x75, /*  example ..calcu */ \
	0x6c,0x61,0x74,0x65,0x73,0x20,0x74,0x68,0x65,0x20,0x4d,0x44,0x35,0x20,0x68,0x61, /* lates the MD5 ha */ \
	0x73,0x68,0x20,0x6f,0x66,0x20,0x61,0x6e,0x79,0x20,0x66,0x69,0x6c,0x65,0x2e,0x3c, /* sh of any file.< */ \
	0x2f,0x70,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x66,0x6f,0x72,0x6d,0x20,0x61,0x63,0x74, /* /p>....<form act */ \
	0x69,0x6f,0x6e,0x3d,0x22,0x75,0x70,0x6c,0x6f,0x61,0x64,0x2e,0x68,0x74,0x6d,0x22, /* ion="upload.htm" */ \
	0x20,0x6d,0x65,0x74,0x68,0x6f,0x64,0x3d,0x22,0x70,0x6f,0x73,0x74,0x22,0x20,0x65, /*  method="post" e */ \
	0x6e,0x63,0x74,0x79,0x70,0x65,0x3d,0x22,0x6d,0x75,0x6c,0x74,0x69,0x70,0x61,0x72, /* nctype="multipar */ \
	0x74,0x2f,0x66,0x6f,0x72,0x6d,0x2d,0x64,0x61,0x74,0x61,0x22,0x3e,0x0d,0x0a,0x3c, /* t/form-data">..< */ \
	0x64,0x69,0x76,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x65,0x78,0x61,0x6d,0x70, /* div class="examp */ \
	0x6c,0x65,0x62,0x6f,0x78,0x22,0x3e,0x0d,0x0a,0x7e,0x75,0x70,0x6c,0x6f,0x61,0x64, /* lebox">..~upload */ \
	0x65,0x64,0x6d,0x64,0x35,0x7e,0x0d,0x0a,0x3c,0x70,0x20,0x73,0x74,0x79,0x6c,0x65, /* edmd5~..<p style */ \
	0x3d,0x22,0x6d,0x61,0x72,0x67,0x69,0x6e,0x2d,0x62,0x6f,0x74,0x74,0x6f,0x6d,0x3a, /* ="margin-bottom: */ \
	0x20,0x32,0x70,0x78,0x22,0x3e,0x3c,0x62,0x3e,0x46,0x69,0x6c,0x65,0x3a,0x20,0x3c, /*  2px"><b>File: < */ \
	0x2f,0x62,0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75, /* /b>&nbsp;..<inpu */ \
	0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x66,0x69,0x6c,0x65,0x22,0x20,0x6e,0x61, /* t type="file" na */ \
	0x6d,0x65,0x3d,0x22,0x6d,0x64,0x35,0x66,0x69,0x6c,0x65,0x22,0x20,0x73,0x69,0x7a, /* me="md5file" siz */ \
	0x65,0x3d,0x22,0x33,0x30,0x22,0x20,0x2f,0x3e,0x20,0x26,0x6e,0x62,0x73,0x70,0x3b, /* e="30" /> &nbsp; */ \
	0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x73, /* ..<input type="s */ \
	0x75,0x62,0x6d,0x69,0x74,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x47,0x65, /* ubmit" value="Ge */ \
	0x74,0x20,0x4d,0x44,0x35,0x22,0x20,0x2f,0x3e,0x0d,0x0a,0x3c,0x2f,0x70,0x3e,0x0d, /* t MD5" />..</p>. */ \
	0x0a,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x2f,0x66,0x6f,0x72,0x6d,0x3e, /* .</div>..</form> */ \
	0x0d,0x0a,0x0d,0x0a,0x3c,0x70,0x3e,0x54,0x68,0x69,0x73,0x20,0x69,0x73,0x20,0x61, /* ....<p>This is a */ \
	0x6e,0x20,0x61,0x64,0x76,0x61,0x6e,0x63,0x65,0x64,0x20,0x66,0x65,0x61,0x74,0x75, /* n advanced featu */ \
	0x72,0x65,0x2e,0x20,0x20,0x46,0x6f,0x72,0x20,0x6d,0x6f,0x72,0x65,0x20,0x69,0x6e, /* re.  For more in */ \
	0x66,0x6f,0x72,0x6d,0x61,0x74,0x69,0x6f,0x6e,0x2c,0x20,0x70,0x6c,0x65,0x61,0x73, /* formation, pleas */ \
	0x65,0x20,0x72,0x65,0x66,0x65,0x72,0x20,0x74,0x6f,0x20,0x74,0x68,0x65,0x20,0x0d, /* e refer to the . */ \
	0x0a,0x69,0x6d,0x70,0x6c,0x65,0x6d,0x65,0x6e,0x74,0x61,0x74,0x69,0x6f,0x6e,0x20, /* .implementation  */ \
	0x69,0x6e,0x20,0x3c,0x63,0x6f,0x64,0x65,0x3e,0x43,0x75,0x73,0x74,0x6f,0x6d,0x48, /* in <code>CustomH */ \
	0x54,0x54,0x50,0x41,0x70,0x70,0x2e,0x63,0x3c,0x2f,0x63,0x6f,0x64,0x65,0x3e,0x20, /* TTPApp.c</code>  */ \
	0x66,0x6f,0x72,0x20,0x63,0x6f,0x6d,0x6d,0x65,0x6e,0x74,0x73,0x20,0x61,0x6e,0x64, /* for comments and */ \
	0x20,0x65,0x78,0x70,0x6c,0x61,0x69,0x6e,0x61,0x74,0x69,0x6f,0x6e,0x2e,0x3c,0x2f, /*  explaination.</ */ \
	0x70,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x0d,0x0a, /* p>....</div>.... */ \
	0x3c,0x73,0x63,0x72,0x69,0x70,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65, /* <script type="te */ \
	0x78,0x74,0x2f,0x6a,0x61,0x76,0x61,0x73,0x63,0x72,0x69,0x70,0x74,0x22,0x3e,0x0d, /* xt/javascript">. */ \
	0x0a,0x3c,0x21,0x2d,0x2d,0x0d,0x0a,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e, /* .<!--..document. */ \
	0x67,0x65,0x74,0x45,0x6c,0x65,0x6d,0x65,0x6e,0x74,0x42,0x79,0x49,0x64,0x28,0x27, /* getElementById(' */ \
	0x68,0x65,0x6c,0x6c,0x6f,0x27,0x29,0x2e,0x69,0x6e,0x6e,0x65,0x72,0x48,0x54,0x4d, /* hello').innerHTM */ \
	0x4c,0x20,0x3d,0x20,0x22,0x7e,0x68,0x65,0x6c,0x6c,0x6f,0x6d,0x73,0x67,0x7e,0x22, /* L = "~hellomsg~" */ \
	0x3b,0x0d,0x0a,0x2d,0x2d,0x3e,0x0d,0x0a,0x3c,0x2f,0x73,0x63,0x72,0x69,0x70,0x74, /* ;..-->..</script */ \
	0x3e,0x0d,0x0a,0x7e,0x69,0x6e,0x63,0x3a,0x66,0x6f,0x6f,0x74,0x65,0x72,0x2e,0x69, /* >..~inc:footer.i */ \
	0x6e,0x63,0x7e,0x00,0x00,0x00,0x00,0x33,0x00,0x00,0x00,0xb6,0x01,0x00,0x00,0x1d, /* nc~....3........ */ \
	0x00,0x00,0x00,0x72,0x03,0x00,0x00,0x01,0x00,0x00,0x00,0x90,0x03,0x00,0x00,0x02, /* ...r............ */ \
	0x00,0x00,0x00,0x7e,0x69,0x6e,0x63,0x3a,0x68,0x65,0x61,0x64,0x65,0x72,0x2e,0x69, /* ...~inc:header.i */ \
	0x6e,0x63,0x7e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x20,0x69,0x64,0x3d,0x22,0x63,0x6f, /* nc~..<div id="co */ \
	0x6e,0x74,0x65,0x6e,0x74,0x22,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x68,0x31,0x3e,0x44, /* ntent">....<h1>D */ \
	0x79,0x6e,0x61,0x6d,0x69,0x63,0x20,0x44,0x4e,0x53,0x3c,0x2f,0x68,0x31,0x3e,0x0d, /* ynamic DNS</h1>. */ \
	0x0a,0x3c,0x64,0x69,0x76,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x72,0x65,0x73, /* .<div class="res */ \
	0x75,0x6c,0x74,0x20,0x6f,0x6b,0x22,0x20,0x73,0x74,0x79,0x6c,0x65,0x3d,0x22,0x64, /* ult ok" style="d */ \
	0x69,0x73,0x70,0x6c,0x61,0x79,0x3a,0x7e,0x73,0x74,0x61,0x74,0x75,0x73,0x5f,0x6f, /* isplay:~status_o */ \
	0x6b,0x7e,0x22,0x3e,0x0d,0x0a,0x59,0x6f,0x75,0x72,0x20,0x73,0x65,0x74,0x74,0x69, /* k~">..Your setti */ \
	0x6e,0x67,0x73,0x20,0x68,0x61,0x76,0x65,0x20,0x62,0x65,0x65,0x6e,0x20,0x73,0x61  /* ngs have been sa */
#define DATACHUNK000016 \
	0x76,0x65,0x64,0x2e,0x0d,0x0a,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x0d,0x0a, /* ved...</div>.... */ \
	0x3c,0x64,0x69,0x76,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x72,0x65,0x73,0x75, /* <div class="resu */ \
	0x6c,0x74,0x20,0x7e,0x64,0x64,0x6e,0x73,0x5f,0x73,0x74,0x61,0x74,0x75,0x73,0x7e, /* lt ~ddns_status~ */ \
	0x22,0x3e,0x0d,0x0a,0x7e,0x64,0x64,0x6e,0x73,0x5f,0x73,0x74,0x61,0x74,0x75,0x73, /* ">..~ddns_status */ \
	0x5f,0x6d,0x73,0x67,0x7e,0x0d,0x0a,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x0d, /* _msg~..</div>... */ \
	0x0a,0x3c,0x70,0x3e,0x54,0x68,0x65,0x20,0x44,0x79,0x6e,0x61,0x6d,0x69,0x63,0x20, /* .<p>The Dynamic  */ \
	0x44,0x4e,0x53,0x20,0x6d,0x6f,0x64,0x75,0x6c,0x65,0x20,0x61,0x6c,0x6c,0x6f,0x77, /* DNS module allow */ \
	0x73,0x20,0x74,0x68,0x65,0x20,0x73,0x74,0x61,0x63,0x6b,0x20,0x74,0x6f,0x20,0x75, /* s the stack to u */ \
	0x70,0x64,0x61,0x74,0x65,0x20,0x74,0x68,0x65,0x20,0x62,0x6f,0x61,0x72,0x64,0x27, /* pdate the board' */ \
	0x73,0x20,0x67,0x6c,0x6f,0x62,0x61,0x6c,0x20,0x49,0x50,0x20,0x0d,0x0a,0x61,0x64, /* s global IP ..ad */ \
	0x64,0x72,0x65,0x73,0x73,0x20,0x74,0x6f,0x20,0x76,0x61,0x72,0x69,0x6f,0x75,0x73, /* dress to various */ \
	0x20,0x44,0x79,0x6e,0x61,0x6d,0x69,0x63,0x20,0x44,0x4e,0x53,0x20,0x73,0x65,0x72, /*  Dynamic DNS ser */ \
	0x76,0x69,0x63,0x65,0x73,0x2e,0x20,0x20,0x54,0x68,0x69,0x73,0x20,0x66,0x65,0x61, /* vices.  This fea */ \
	0x74,0x75,0x72,0x65,0x2c,0x20,0x61,0x6c,0x6f,0x6e,0x67,0x20,0x77,0x69,0x74,0x68, /* ture, along with */ \
	0x20,0x70,0x72,0x6f,0x70,0x65,0x72,0x0d,0x0a,0x70,0x6f,0x72,0x74,0x20,0x66,0x6f, /*  proper..port fo */ \
	0x72,0x77,0x61,0x72,0x64,0x69,0x6e,0x67,0x20,0x69,0x6e,0x20,0x70,0x6c,0x61,0x63, /* rwarding in plac */ \
	0x65,0x20,0x61,0x74,0x20,0x74,0x68,0x65,0x20,0x72,0x6f,0x75,0x74,0x65,0x72,0x2c, /* e at the router, */ \
	0x20,0x63,0x61,0x6e,0x20,0x65,0x6e,0x61,0x62,0x6c,0x65,0x20,0x67,0x6c,0x6f,0x62, /*  can enable glob */ \
	0x61,0x6c,0x20,0x61,0x63,0x63,0x65,0x73,0x73,0x20,0x74,0x6f,0x20,0x61,0x20,0x0d, /* al access to a . */ \
	0x0a,0x64,0x65,0x76,0x69,0x63,0x65,0x20,0x62,0x65,0x68,0x69,0x6e,0x64,0x20,0x61, /* .device behind a */ \
	0x20,0x4e,0x41,0x54,0x20,0x72,0x6f,0x75,0x74,0x65,0x72,0x20,0x6f,0x72,0x20,0x66, /*  NAT router or f */ \
	0x69,0x72,0x65,0x77,0x61,0x6c,0x6c,0x2e,0x3c,0x2f,0x70,0x3e,0x0d,0x0a,0x0d,0x0a, /* irewall.</p>.... */ \
	0x3c,0x70,0x3e,0x45,0x6e,0x74,0x65,0x72,0x20,0x74,0x68,0x65,0x20,0x73,0x65,0x74, /* <p>Enter the set */ \
	0x74,0x69,0x6e,0x67,0x73,0x20,0x69,0x6e,0x20,0x74,0x68,0x65,0x20,0x66,0x69,0x65, /* tings in the fie */ \
	0x6c,0x64,0x73,0x20,0x62,0x65,0x6c,0x6f,0x77,0x3a,0x3c,0x2f,0x70,0x3e,0x0d,0x0a, /* lds below:</p>.. */ \
	0x0d,0x0a,0x3c,0x66,0x6f,0x72,0x6d,0x20,0x6d,0x65,0x74,0x68,0x6f,0x64,0x3d,0x22, /* ..<form method=" */ \
	0x70,0x6f,0x73,0x74,0x22,0x20,0x61,0x63,0x74,0x69,0x6f,0x6e,0x3d,0x22,0x2f,0x64, /* post" action="/d */ \
	0x79,0x6e,0x64,0x6e,0x73,0x2f,0x69,0x6e,0x64,0x65,0x78,0x2e,0x68,0x74,0x6d,0x22, /* yndns/index.htm" */ \
	0x3e,0x0d,0x0a,0x3c,0x66,0x69,0x65,0x6c,0x64,0x73,0x65,0x74,0x3e,0x0d,0x0a,0x3c, /* >..<fieldset>..< */ \
	0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x44,0x44,0x4e,0x53,0x20, /* div><label>DDNS  */ \
	0x53,0x65,0x72,0x76,0x69,0x63,0x65,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e, /* Service:</label> */ \
	0x0d,0x0a,0x3c,0x73,0x65,0x6c,0x65,0x63,0x74,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22, /* ..<select name=" */ \
	0x73,0x65,0x72,0x76,0x69,0x63,0x65,0x22,0x3e,0x0d,0x0a,0x3c,0x6f,0x70,0x74,0x69, /* service">..<opti */ \
	0x6f,0x6e,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x30,0x22,0x20,0x7e,0x64,0x64, /* on value="0" ~dd */ \
	0x6e,0x73,0x5f,0x73,0x65,0x72,0x76,0x69,0x63,0x65,0x28,0x30,0x29,0x7e,0x3e,0x44, /* ns_service(0)~>D */ \
	0x79,0x6e,0x44,0x4e,0x53,0x20,0x28,0x77,0x77,0x77,0x2e,0x64,0x79,0x6e,0x64,0x6e, /* ynDNS (www.dyndn */ \
	0x73,0x2e,0x63,0x6f,0x6d,0x29,0x3c,0x2f,0x6f,0x70,0x74,0x69,0x6f,0x6e,0x3e,0x0d, /* s.com)</option>. */ \
	0x0a,0x3c,0x6f,0x70,0x74,0x69,0x6f,0x6e,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22, /* .<option value=" */ \
	0x31,0x22,0x20,0x7e,0x64,0x64,0x6e,0x73,0x5f,0x73,0x65,0x72,0x76,0x69,0x63,0x65, /* 1" ~ddns_service */ \
	0x28,0x31,0x29,0x7e,0x3e,0x4e,0x6f,0x2d,0x49,0x50,0x20,0x28,0x77,0x77,0x77,0x2e, /* (1)~>No-IP (www. */ \
	0x6e,0x6f,0x2d,0x69,0x70,0x2e,0x63,0x6f,0x6d,0x29,0x3c,0x2f,0x6f,0x70,0x74,0x69, /* no-ip.com)</opti */ \
	0x6f,0x6e,0x3e,0x0d,0x0a,0x3c,0x6f,0x70,0x74,0x69,0x6f,0x6e,0x20,0x76,0x61,0x6c, /* on>..<option val */ \
	0x75,0x65,0x3d,0x22,0x32,0x22,0x20,0x7e,0x64,0x64,0x6e,0x73,0x5f,0x73,0x65,0x72, /* ue="2" ~ddns_ser */ \
	0x76,0x69,0x63,0x65,0x28,0x32,0x29,0x7e,0x3e,0x44,0x4e,0x53,0x2d,0x4f,0x2d,0x4d, /* vice(2)~>DNS-O-M */ \
	0x61,0x74,0x69,0x63,0x20,0x28,0x77,0x77,0x77,0x2e,0x64,0x6e,0x73,0x6f,0x6d,0x61, /* atic (www.dnsoma */ \
	0x74,0x69,0x63,0x2e,0x63,0x6f,0x6d,0x29,0x3c,0x2f,0x6f,0x70,0x74,0x69,0x6f,0x6e, /* tic.com)</option */ \
	0x3e,0x0d,0x0a,0x3c,0x2f,0x73,0x65,0x6c,0x65,0x63,0x74,0x3e,0x0d,0x0a,0x3c,0x2f, /* >..</select>..</ */ \
	0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65, /* div>..<div><labe */ \
	0x6c,0x3e,0x55,0x73,0x65,0x72,0x20,0x4e,0x61,0x6d,0x65,0x3a,0x3c,0x2f,0x6c,0x61, /* l>User Name:</la */ \
	0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70, /* bel>..<input typ */ \
	0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x75, /* e="text" name="u */ \
	0x73,0x65,0x72,0x22,0x20,0x6d,0x61,0x78,0x6c,0x65,0x6e,0x67,0x74,0x68,0x3d,0x22, /* ser" maxlength=" */ \
	0x34,0x30,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x7e,0x64,0x64,0x6e,0x73, /* 40" value="~ddns */ \
	0x5f,0x75,0x73,0x65,0x72,0x7e,0x22,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d, /* _user~"/></div>. */ \
	0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x50,0x61,0x73, /* .<div><label>Pas */ \
	0x73,0x77,0x6f,0x72,0x64,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a, /* sword:</label>.. */ \
	0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x70,0x61,0x73, /* <input type="pas */ \
	0x73,0x77,0x6f,0x72,0x64,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x70,0x61,0x73, /* sword" name="pas */ \
	0x73,0x22,0x20,0x6d,0x61,0x78,0x6c,0x65,0x6e,0x67,0x74,0x68,0x3d,0x22,0x32,0x34, /* s" maxlength="24 */ \
	0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x7e,0x64,0x64,0x6e,0x73,0x5f,0x70, /* " value="~ddns_p */ \
	0x61,0x73,0x73,0x7e,0x22,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c, /* ass~"/></div>..< */ \
	0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x48,0x6f,0x73,0x74,0x3a, /* div><label>Host: */ \
	0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74, /* </label>..<input */ \
	0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x22,0x20,0x6e,0x61,0x6d  /*  type="text" nam */
#define DATACHUNK000017 \
	0x65,0x3d,0x22,0x68,0x6f,0x73,0x74,0x22,0x20,0x6d,0x61,0x78,0x6c,0x65,0x6e,0x67, /* e="host" maxleng */ \
	0x74,0x68,0x3d,0x22,0x34,0x38,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x7e, /* th="48" value="~ */ \
	0x64,0x64,0x6e,0x73,0x5f,0x68,0x6f,0x73,0x74,0x7e,0x22,0x20,0x2f,0x3e,0x3c,0x2f, /* ddns_host~" /></ */ \
	0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x69,0x6e,0x70,0x75, /* div>..<div><inpu */ \
	0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x73,0x75,0x62,0x6d,0x69,0x74,0x22,0x20, /* t type="submit"  */ \
	0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x73,0x6d,0x22,0x20,0x76,0x61,0x6c,0x75,0x65, /* class="sm" value */ \
	0x3d,0x22,0x53,0x65,0x74,0x20,0x44,0x44,0x4e,0x53,0x20,0x43,0x6f,0x6e,0x66,0x69, /* ="Set DDNS Confi */ \
	0x67,0x75,0x72,0x61,0x74,0x69,0x6f,0x6e,0x22,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76, /* guration"/></div */ \
	0x3e,0x0d,0x0a,0x3c,0x2f,0x66,0x69,0x65,0x6c,0x64,0x73,0x65,0x74,0x3e,0x0d,0x0a, /* >..</fieldset>.. */ \
	0x3c,0x2f,0x66,0x6f,0x72,0x6d,0x3e,0x0d,0x0a,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d, /* </form>..</div>. */ \
	0x0a,0x0d,0x0a,0x3c,0x73,0x63,0x72,0x69,0x70,0x74,0x20,0x74,0x79,0x70,0x65,0x3d, /* ...<script type= */ \
	0x22,0x74,0x65,0x78,0x74,0x2f,0x6a,0x61,0x76,0x61,0x73,0x63,0x72,0x69,0x70,0x74, /* "text/javascript */ \
	0x22,0x3e,0x0d,0x0a,0x3c,0x21,0x2d,0x2d,0x0d,0x0a,0x64,0x6f,0x63,0x75,0x6d,0x65, /* ">..<!--..docume */ \
	0x6e,0x74,0x2e,0x67,0x65,0x74,0x45,0x6c,0x65,0x6d,0x65,0x6e,0x74,0x42,0x79,0x49, /* nt.getElementByI */ \
	0x64,0x28,0x27,0x68,0x65,0x6c,0x6c,0x6f,0x27,0x29,0x2e,0x69,0x6e,0x6e,0x65,0x72, /* d('hello').inner */ \
	0x48,0x54,0x4d,0x4c,0x20,0x3d,0x20,0x22,0x7e,0x68,0x65,0x6c,0x6c,0x6f,0x6d,0x73, /* HTML = "~helloms */ \
	0x67,0x7e,0x22,0x3b,0x0d,0x0a,0x2d,0x2d,0x3e,0x0d,0x0a,0x3c,0x2f,0x73,0x63,0x72, /* g~";..-->..</scr */ \
	0x69,0x70,0x74,0x3e,0x0d,0x0a,0x7e,0x69,0x6e,0x63,0x3a,0x66,0x6f,0x6f,0x74,0x65, /* ipt>..~inc:foote */ \
	0x72,0x2e,0x69,0x6e,0x63,0x7e,0x0d,0x0a,0x00,0x00,0x00,0x00,0x33,0x00,0x00,0x00, /* r.inc~......3... */ \
	0x64,0x00,0x00,0x00,0x1e,0x00,0x00,0x00,0xb0,0x00,0x00,0x00,0x1f,0x00,0x00,0x00, /* d............... */ \
	0xc1,0x00,0x00,0x00,0x20,0x00,0x00,0x00,0xaa,0x02,0x00,0x00,0x2f,0x00,0x00,0x00, /* .... ......./... */ \
	0xf0,0x02,0x00,0x00,0x30,0x00,0x00,0x00,0x34,0x03,0x00,0x00,0x31,0x00,0x00,0x00, /* ....0...4...1... */ \
	0xd8,0x03,0x00,0x00,0x21,0x00,0x00,0x00,0x46,0x04,0x00,0x00,0x22,0x00,0x00,0x00, /* ....!...F..."... */ \
	0xac,0x04,0x00,0x00,0x23,0x00,0x00,0x00,0x85,0x05,0x00,0x00,0x01,0x00,0x00,0x00, /* ....#........... */ \
	0xa3,0x05,0x00,0x00,0x02,0x00,0x00,0x00,0x7e,0x69,0x6e,0x63,0x3a,0x68,0x65,0x61, /* ........~inc:hea */ \
	0x64,0x65,0x72,0x2e,0x69,0x6e,0x63,0x7e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x20,0x69, /* der.inc~..<div i */ \
	0x64,0x3d,0x22,0x63,0x6f,0x6e,0x74,0x65,0x6e,0x74,0x22,0x3e,0x0d,0x0a,0x0d,0x0a, /* d="content">.... */ \
	0x3c,0x68,0x31,0x3e,0x53,0x65,0x6e,0x64,0x20,0x45,0x2d,0x4d,0x61,0x69,0x6c,0x3c, /* <h1>Send E-Mail< */ \
	0x2f,0x68,0x31,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x20,0x63,0x6c,0x61, /* /h1>....<div cla */ \
	0x73,0x73,0x3d,0x22,0x72,0x65,0x73,0x75,0x6c,0x74,0x20,0x6f,0x6b,0x22,0x20,0x73, /* ss="result ok" s */ \
	0x74,0x79,0x6c,0x65,0x3d,0x22,0x64,0x69,0x73,0x70,0x6c,0x61,0x79,0x3a,0x7e,0x73, /* tyle="display:~s */ \
	0x74,0x61,0x74,0x75,0x73,0x5f,0x6f,0x6b,0x7e,0x22,0x3e,0x0d,0x0a,0x59,0x6f,0x75, /* tatus_ok~">..You */ \
	0x72,0x20,0x6d,0x65,0x73,0x73,0x61,0x67,0x65,0x20,0x68,0x61,0x73,0x20,0x62,0x65, /* r message has be */ \
	0x65,0x6e,0x20,0x73,0x65,0x6e,0x74,0x2e,0x0d,0x0a,0x3c,0x2f,0x64,0x69,0x76,0x3e, /* en sent...</div> */ \
	0x0d,0x0a,0x3c,0x64,0x69,0x76,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x72,0x65, /* ..<div class="re */ \
	0x73,0x75,0x6c,0x74,0x20,0x66,0x61,0x69,0x6c,0x22,0x20,0x73,0x74,0x79,0x6c,0x65, /* sult fail" style */ \
	0x3d,0x22,0x64,0x69,0x73,0x70,0x6c,0x61,0x79,0x3a,0x7e,0x73,0x74,0x61,0x74,0x75, /* ="display:~statu */ \
	0x73,0x5f,0x66,0x61,0x69,0x6c,0x7e,0x22,0x3e,0x0d,0x0a,0x45,0x52,0x52,0x4f,0x52, /* s_fail~">..ERROR */ \
	0x3a,0x20,0x59,0x6f,0x75,0x72,0x20,0x6d,0x65,0x73,0x73,0x61,0x67,0x65,0x20,0x63, /* : Your message c */ \
	0x6f,0x75,0x6c,0x64,0x20,0x6e,0x6f,0x74,0x20,0x62,0x65,0x20,0x73,0x65,0x6e,0x74, /* ould not be sent */ \
	0x2e,0x3c,0x62,0x72,0x20,0x2f,0x3e,0x0d,0x0a,0x43,0x68,0x65,0x63,0x6b,0x20,0x79, /* .<br />..Check y */ \
	0x6f,0x75,0x72,0x20,0x53,0x4d,0x54,0x50,0x20,0x73,0x65,0x72,0x76,0x65,0x72,0x20, /* our SMTP server  */ \
	0x73,0x65,0x74,0x74,0x69,0x6e,0x67,0x73,0x20,0x61,0x6e,0x64,0x20,0x74,0x72,0x79, /* settings and try */ \
	0x20,0x61,0x67,0x61,0x69,0x6e,0x2e,0x0d,0x0a,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d, /*  again...</div>. */ \
	0x0a,0x0d,0x0a,0x3c,0x70,0x3e,0x42,0x79,0x20,0x63,0x6f,0x6d,0x62,0x69,0x6e,0x69, /* ...<p>By combini */ \
	0x6e,0x67,0x20,0x74,0x68,0x65,0x20,0x53,0x4d,0x54,0x50,0x20,0x63,0x6c,0x69,0x65, /* ng the SMTP clie */ \
	0x6e,0x74,0x20,0x69,0x6e,0x74,0x6f,0x20,0x61,0x6e,0x20,0x48,0x54,0x54,0x50,0x32, /* nt into an HTTP2 */ \
	0x20,0x50,0x4f,0x53,0x54,0x20,0x63,0x61,0x6c,0x6c,0x62,0x61,0x63,0x6b,0x2c,0x20, /*  POST callback,  */ \
	0x61,0x20,0x66,0x6f,0x72,0x6d,0x20,0x0d,0x0a,0x63,0x61,0x6e,0x20,0x62,0x65,0x20, /* a form ..can be  */ \
	0x64,0x65,0x76,0x65,0x6c,0x6f,0x70,0x65,0x64,0x20,0x74,0x68,0x61,0x74,0x20,0x73, /* developed that s */ \
	0x65,0x6e,0x64,0x73,0x20,0x61,0x6e,0x20,0x65,0x2d,0x6d,0x61,0x69,0x6c,0x20,0x74, /* ends an e-mail t */ \
	0x6f,0x20,0x61,0x6e,0x20,0x61,0x64,0x6d,0x69,0x6e,0x69,0x73,0x74,0x72,0x61,0x74, /* o an administrat */ \
	0x6f,0x72,0x2e,0x20,0x20,0x46,0x6f,0x72,0x20,0x6d,0x6f,0x72,0x65,0x0d,0x0a,0x64, /* or.  For more..d */ \
	0x65,0x74,0x61,0x69,0x6c,0x73,0x20,0x6f,0x6e,0x20,0x74,0x68,0x65,0x20,0x53,0x4d, /* etails on the SM */ \
	0x54,0x50,0x20,0x43,0x6c,0x69,0x65,0x6e,0x74,0x20,0x6d,0x6f,0x64,0x75,0x6c,0x65, /* TP Client module */ \
	0x2c,0x20,0x70,0x6c,0x65,0x61,0x73,0x65,0x20,0x73,0x65,0x65,0x20,0x74,0x68,0x65, /* , please see the */ \
	0x20,0x54,0x43,0x50,0x49,0x50,0x20,0x53,0x74,0x61,0x63,0x6b,0x20,0x55,0x73,0x65, /*  TCPIP Stack Use */ \
	0x72,0x27,0x73,0x0d,0x0a,0x47,0x75,0x69,0x64,0x65,0x2e,0x3c,0x2f,0x70,0x3e,0x0d, /* r's..Guide.</p>. */ \
	0x0a,0x0d,0x0a,0x3c,0x70,0x3e,0x45,0x6e,0x74,0x65,0x72,0x20,0x74,0x68,0x65,0x20, /* ...<p>Enter the  */ \
	0x61,0x70,0x70,0x72,0x6f,0x70,0x72,0x69,0x61,0x74,0x65,0x20,0x73,0x65,0x74,0x74, /* appropriate sett */ \
	0x69,0x6e,0x67,0x73,0x20,0x69,0x6e,0x20,0x74,0x68,0x65,0x20,0x66,0x69,0x65,0x6c, /* ings in the fiel */ \
	0x64,0x73,0x20,0x62,0x65,0x6c,0x6f,0x77,0x3a,0x0d,0x0a,0x3c,0x62,0x72,0x20,0x2f, /* ds below:..<br / */ \
	0x3e,0x28,0x59,0x6f,0x75,0x72,0x20,0x53,0x4d,0x54,0x50,0x20,0x73,0x65,0x72,0x76, /* >(Your SMTP serv */ \
	0x65,0x72,0x20,0x6d,0x61,0x79,0x20,0x6e,0x6f,0x74,0x20,0x72,0x65,0x71,0x75,0x69  /* er may not requi */
#define DATACHUNK000018 \
	0x72,0x65,0x20,0x61,0x20,0x75,0x73,0x65,0x72,0x20,0x6e,0x61,0x6d,0x65,0x20,0x6f, /* re a user name o */ \
	0x72,0x20,0x70,0x61,0x73,0x73,0x77,0x6f,0x72,0x64,0x2e,0x29,0x3c,0x2f,0x70,0x3e, /* r password.)</p> */ \
	0x0d,0x0a,0x0d,0x0a,0x3c,0x66,0x6f,0x72,0x6d,0x20,0x6d,0x65,0x74,0x68,0x6f,0x64, /* ....<form method */ \
	0x3d,0x22,0x70,0x6f,0x73,0x74,0x22,0x20,0x61,0x63,0x74,0x69,0x6f,0x6e,0x3d,0x22, /* ="post" action=" */ \
	0x2f,0x65,0x6d,0x61,0x69,0x6c,0x2f,0x69,0x6e,0x64,0x65,0x78,0x2e,0x68,0x74,0x6d, /* /email/index.htm */ \
	0x22,0x20,0x6f,0x6e,0x73,0x75,0x62,0x6d,0x69,0x74,0x3d,0x22,0x62,0x74,0x6e,0x3d, /* " onsubmit="btn= */ \
	0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e,0x67,0x65,0x74,0x45,0x6c,0x65,0x6d, /* document.getElem */ \
	0x65,0x6e,0x74,0x42,0x79,0x49,0x64,0x28,0x27,0x62,0x74,0x6e,0x53,0x75,0x62,0x6d, /* entById('btnSubm */ \
	0x69,0x74,0x27,0x29,0x3b,0x20,0x62,0x74,0x6e,0x2e,0x76,0x61,0x6c,0x75,0x65,0x3d, /* it'); btn.value= */ \
	0x27,0x28,0x70,0x6c,0x65,0x61,0x73,0x65,0x20,0x77,0x61,0x69,0x74,0x29,0x27,0x3b, /* '(please wait)'; */ \
	0x20,0x62,0x74,0x6e,0x2e,0x64,0x69,0x73,0x61,0x62,0x6c,0x65,0x64,0x20,0x3d,0x20, /*  btn.disabled =  */ \
	0x74,0x72,0x75,0x65,0x3b,0x22,0x3e,0x0d,0x0a,0x3c,0x66,0x69,0x65,0x6c,0x64,0x73, /* true;">..<fields */ \
	0x65,0x74,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c, /* et>..<div><label */ \
	0x3e,0x53,0x4d,0x54,0x50,0x20,0x53,0x65,0x72,0x76,0x65,0x72,0x3a,0x3c,0x2f,0x6c, /* >SMTP Server:</l */ \
	0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79, /* abel>..<input ty */ \
	0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22, /* pe="text" name=" */ \
	0x73,0x65,0x72,0x76,0x65,0x72,0x22,0x20,0x73,0x74,0x79,0x6c,0x65,0x3d,0x22,0x77, /* server" style="w */ \
	0x69,0x64,0x74,0x68,0x3a,0x31,0x36,0x35,0x70,0x78,0x22,0x2f,0x3e,0x0d,0x0a,0x26, /* idth:165px"/>..& */ \
	0x6e,0x62,0x73,0x70,0x3b,0x3c,0x62,0x3e,0x50,0x6f,0x72,0x74,0x3a,0x3c,0x2f,0x62, /* nbsp;<b>Port:</b */ \
	0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20, /* >&nbsp;..<input  */ \
	0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x22,0x20,0x6e,0x61,0x6d,0x65, /* type="text" name */ \
	0x3d,0x22,0x70,0x6f,0x72,0x74,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x32, /* ="port" value="2 */ \
	0x35,0x22,0x20,0x73,0x74,0x79,0x6c,0x65,0x3d,0x22,0x77,0x69,0x64,0x74,0x68,0x3a, /* 5" style="width: */ \
	0x32,0x35,0x70,0x78,0x3b,0x22,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a, /* 25px;"/></div>.. */ \
	0x3c,0x64,0x69,0x76,0x20,0x73,0x74,0x79,0x6c,0x65,0x3d,0x22,0x64,0x69,0x73,0x70, /* <div style="disp */ \
	0x6c,0x61,0x79,0x3a,0x7e,0x73,0x6d,0x74,0x70,0x73,0x5f,0x65,0x6e,0x7e,0x22,0x3e, /* lay:~smtps_en~"> */ \
	0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x63,0x68,0x65, /* <input type="che */ \
	0x63,0x6b,0x62,0x6f,0x78,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x73,0x73,0x6c, /* ckbox" name="ssl */ \
	0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x31,0x22,0x20,0x63,0x6c,0x61,0x73, /* " value="1" clas */ \
	0x73,0x3d,0x22,0x73,0x6d,0x22,0x2f,0x3e,0x20,0x55,0x73,0x65,0x20,0x53,0x53,0x4c, /* s="sm"/> Use SSL */ \
	0x20,0x28,0x75,0x73,0x75,0x61,0x6c,0x6c,0x79,0x20,0x70,0x6f,0x72,0x74,0x20,0x34, /*  (usually port 4 */ \
	0x36,0x35,0x29,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e, /* 65)</div>..<div> */ \
	0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x55,0x73,0x65,0x72,0x20,0x4e,0x61,0x6d,0x65, /* <label>User Name */ \
	0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75, /* :</label>..<inpu */ \
	0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x22,0x20,0x6e,0x61, /* t type="text" na */ \
	0x6d,0x65,0x3d,0x22,0x75,0x73,0x65,0x72,0x22,0x20,0x2f,0x3e,0x3c,0x2f,0x64,0x69, /* me="user" /></di */ \
	0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e, /* v>..<div><label> */ \
	0x50,0x61,0x73,0x73,0x77,0x6f,0x72,0x64,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c, /* Password:</label */ \
	0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22, /* >..<input type=" */ \
	0x70,0x61,0x73,0x73,0x77,0x6f,0x72,0x64,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22, /* password" name=" */ \
	0x70,0x61,0x73,0x73,0x22,0x20,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a, /* pass" /></div>.. */ \
	0x3c,0x64,0x69,0x76,0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x3c,0x2f,0x64,0x69,0x76, /* <div>&nbsp;</div */ \
	0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c, /* >....<div><label */ \
	0x3e,0x54,0x6f,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x69, /* >To:</label>..<i */ \
	0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x22, /* nput type="text" */ \
	0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x74,0x6f,0x22,0x20,0x2f,0x3e,0x3c,0x2f,0x64, /*  name="to" /></d */ \
	0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c, /* iv>..<div><label */ \
	0x3e,0x4d,0x65,0x73,0x73,0x61,0x67,0x65,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c, /* >Message:</label */ \
	0x3e,0x0d,0x0a,0x3c,0x74,0x65,0x78,0x74,0x61,0x72,0x65,0x61,0x20,0x6e,0x61,0x6d, /* >..<textarea nam */ \
	0x65,0x3d,0x22,0x6d,0x73,0x67,0x22,0x20,0x72,0x6f,0x77,0x73,0x3d,0x22,0x36,0x22, /* e="msg" rows="6" */ \
	0x3e,0x54,0x68,0x69,0x73,0x20,0x6d,0x65,0x73,0x73,0x61,0x67,0x65,0x20,0x77,0x61, /* >This message wa */ \
	0x73,0x20,0x73,0x65,0x6e,0x74,0x20,0x62,0x79,0x20,0x74,0x68,0x65,0x20,0x4d,0x69, /* s sent by the Mi */ \
	0x63,0x72,0x6f,0x63,0x68,0x69,0x70,0x20,0x54,0x43,0x50,0x2f,0x49,0x50,0x20,0x53, /* crochip TCP/IP S */ \
	0x74,0x61,0x63,0x6b,0x2e,0x20,0x20,0x53,0x65,0x65,0x20,0x74,0x68,0x65,0x20,0x61, /* tack.  See the a */ \
	0x74,0x74,0x61,0x63,0x68,0x65,0x64,0x20,0x66,0x69,0x6c,0x65,0x20,0x66,0x6f,0x72, /* ttached file for */ \
	0x20,0x63,0x75,0x72,0x72,0x65,0x6e,0x74,0x20,0x73,0x79,0x73,0x74,0x65,0x6d,0x20, /*  current system  */ \
	0x73,0x74,0x61,0x74,0x75,0x73,0x20,0x69,0x6e,0x66,0x6f,0x72,0x6d,0x61,0x74,0x69, /* status informati */ \
	0x6f,0x6e,0x2e,0x20,0x20,0x54,0x68,0x65,0x20,0x61,0x74,0x74,0x61,0x63,0x68,0x65, /* on.  The attache */ \
	0x64,0x20,0x43,0x53,0x56,0x20,0x66,0x69,0x6c,0x65,0x20,0x77,0x69,0x6c,0x6c,0x20, /* d CSV file will  */ \
	0x6f,0x70,0x65,0x6e,0x20,0x69,0x6e,0x20,0x61,0x6e,0x79,0x20,0x73,0x70,0x72,0x65, /* open in any spre */ \
	0x61,0x64,0x73,0x68,0x65,0x65,0x74,0x20,0x70,0x72,0x6f,0x67,0x72,0x61,0x6d,0x2e, /* adsheet program. */ \
	0x3c,0x2f,0x74,0x65,0x78,0x74,0x61,0x72,0x65,0x61,0x3e,0x0d,0x0a,0x3c,0x2f,0x64, /* </textarea>..</d */ \
	0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x69,0x6e,0x70,0x75,0x74, /* iv>..<div><input */ \
	0x20,0x69,0x64,0x3d,0x22,0x62,0x74,0x6e,0x53,0x75,0x62,0x6d,0x69,0x74,0x22,0x20  /*  id="btnSubmit"  */
#define DATACHUNK000019 \
	0x74,0x79,0x70,0x65,0x3d,0x22,0x73,0x75,0x62,0x6d,0x69,0x74,0x22,0x20,0x63,0x6c, /* type="submit" cl */ \
	0x61,0x73,0x73,0x3d,0x22,0x73,0x6d,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22, /* ass="sm" value=" */ \
	0x53,0x65,0x6e,0x64,0x20,0x4d,0x65,0x73,0x73,0x61,0x67,0x65,0x22,0x2f,0x3e,0x3c, /* Send Message"/>< */ \
	0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x2f,0x66,0x69,0x65,0x6c,0x64,0x73,0x65, /* /div>..</fieldse */ \
	0x74,0x3e,0x0d,0x0a,0x3c,0x2f,0x66,0x6f,0x72,0x6d,0x3e,0x0d,0x0a,0x3c,0x2f,0x64, /* t>..</form>..</d */ \
	0x69,0x76,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x73,0x63,0x72,0x69,0x70,0x74,0x20,0x74, /* iv>....<script t */ \
	0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x2f,0x6a,0x61,0x76,0x61,0x73,0x63, /* ype="text/javasc */ \
	0x72,0x69,0x70,0x74,0x22,0x3e,0x0d,0x0a,0x3c,0x21,0x2d,0x2d,0x0d,0x0a,0x64,0x6f, /* ript">..<!--..do */ \
	0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e,0x67,0x65,0x74,0x45,0x6c,0x65,0x6d,0x65,0x6e, /* cument.getElemen */ \
	0x74,0x42,0x79,0x49,0x64,0x28,0x27,0x68,0x65,0x6c,0x6c,0x6f,0x27,0x29,0x2e,0x69, /* tById('hello').i */ \
	0x6e,0x6e,0x65,0x72,0x48,0x54,0x4d,0x4c,0x20,0x3d,0x20,0x22,0x7e,0x68,0x65,0x6c, /* nnerHTML = "~hel */ \
	0x6c,0x6f,0x6d,0x73,0x67,0x7e,0x22,0x3b,0x0d,0x0a,0x2d,0x2d,0x3e,0x0d,0x0a,0x3c, /* lomsg~";..-->..< */ \
	0x2f,0x73,0x63,0x72,0x69,0x70,0x74,0x3e,0x0d,0x0a,0x7e,0x69,0x6e,0x63,0x3a,0x66, /* /script>..~inc:f */ \
	0x6f,0x6f,0x74,0x65,0x72,0x2e,0x69,0x6e,0x63,0x7e,0x0d,0x0a,0x00,0x00,0x00,0x00, /* ooter.inc~...... */ \
	0x33,0x00,0x00,0x00,0x66,0x00,0x00,0x00,0x1e,0x00,0x00,0x00,0xc2,0x00,0x00,0x00, /* 3...f........... */ \
	0x24,0x00,0x00,0x00,0x0c,0x04,0x00,0x00,0x48,0x00,0x00,0x00,0x24,0x07,0x00,0x00, /* $.......H...$... */ \
	0x01,0x00,0x00,0x00,0x42,0x07,0x00,0x00,0x02,0x00,0x00,0x00,0x7e,0x69,0x6e,0x63, /* ....B.......~inc */ \
	0x3a,0x68,0x65,0x61,0x64,0x65,0x72,0x2e,0x69,0x6e,0x63,0x7e,0x0d,0x0a,0x3c,0x64, /* :header.inc~..<d */ \
	0x69,0x76,0x20,0x69,0x64,0x3d,0x22,0x63,0x6f,0x6e,0x74,0x65,0x6e,0x74,0x22,0x3e, /* iv id="content"> */ \
	0x0d,0x0a,0x0d,0x0a,0x3c,0x68,0x31,0x3e,0x42,0x6f,0x61,0x72,0x64,0x20,0x43,0x6f, /* ....<h1>Board Co */ \
	0x6e,0x66,0x69,0x67,0x75,0x72,0x61,0x74,0x69,0x6f,0x6e,0x3c,0x2f,0x68,0x31,0x3e, /* nfiguration</h1> */ \
	0x0d,0x0a,0x3c,0x70,0x3e,0x54,0x68,0x69,0x73,0x20,0x70,0x61,0x67,0x65,0x20,0x61, /* ..<p>This page a */ \
	0x6c,0x6c,0x6f,0x77,0x73,0x20,0x74,0x68,0x65,0x20,0x63,0x6f,0x6e,0x66,0x69,0x67, /* llows the config */ \
	0x75,0x72,0x61,0x74,0x69,0x6f,0x6e,0x20,0x6f,0x66,0x20,0x74,0x68,0x65,0x20,0x62, /* uration of the b */ \
	0x6f,0x61,0x72,0x64,0x27,0x73,0x20,0x6e,0x65,0x74,0x77,0x6f,0x72,0x6b,0x20,0x73, /* oard's network s */ \
	0x65,0x74,0x74,0x69,0x6e,0x67,0x73,0x2e,0x3c,0x2f,0x70,0x3e,0x0d,0x0a,0x3c,0x64, /* ettings.</p>..<d */ \
	0x69,0x76,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x72,0x65,0x73,0x75,0x6c,0x74, /* iv class="result */ \
	0x20,0x66,0x61,0x69,0x6c,0x22,0x20,0x73,0x74,0x79,0x6c,0x65,0x3d,0x22,0x64,0x69, /*  fail" style="di */ \
	0x73,0x70,0x6c,0x61,0x79,0x3a,0x7e,0x73,0x74,0x61,0x74,0x75,0x73,0x5f,0x66,0x61, /* splay:~status_fa */ \
	0x69,0x6c,0x7e,0x22,0x3e,0x0d,0x0a,0x45,0x52,0x52,0x4f,0x52,0x3a,0x20,0x41,0x20, /* il~">..ERROR: A  */ \
	0x66,0x69,0x65,0x6c,0x64,0x20,0x77,0x61,0x73,0x20,0x75,0x6e,0x70,0x61,0x72,0x73, /* field was unpars */ \
	0x61,0x62,0x6c,0x65,0x20,0x6f,0x72,0x20,0x74,0x6f,0x6f,0x20,0x6d,0x75,0x63,0x68, /* able or too much */ \
	0x20,0x64,0x61,0x74,0x61,0x20,0x77,0x61,0x73,0x20,0x50,0x4f,0x53,0x54,0x65,0x64, /*  data was POSTed */ \
	0x2e,0x20,0x20,0x54,0x72,0x79,0x20,0x61,0x67,0x61,0x69,0x6e,0x2e,0x0d,0x0a,0x3c, /* .  Try again...< */ \
	0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x70,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d, /* /div>..<p class= */ \
	0x22,0x65,0x72,0x72,0x6f,0x72,0x22,0x3e,0x0d,0x0a,0x3c,0x62,0x3e,0x43,0x41,0x55, /* "error">..<b>CAU */ \
	0x54,0x49,0x4f,0x4e,0x3a,0x3c,0x2f,0x62,0x3e,0x20,0x49,0x6e,0x63,0x6f,0x72,0x72, /* TION:</b> Incorr */ \
	0x65,0x63,0x74,0x20,0x73,0x65,0x74,0x74,0x69,0x6e,0x67,0x73,0x20,0x6d,0x61,0x79, /* ect settings may */ \
	0x20,0x63,0x61,0x75,0x73,0x65,0x20,0x74,0x68,0x65,0x20,0x62,0x6f,0x61,0x72,0x64, /*  cause the board */ \
	0x20,0x74,0x6f,0x20,0x6c,0x6f,0x73,0x65,0x20,0x6e,0x65,0x74,0x77,0x6f,0x72,0x6b, /*  to lose network */ \
	0x20,0x0d,0x0a,0x63,0x6f,0x6e,0x6e,0x65,0x63,0x74,0x69,0x76,0x69,0x74,0x79,0x2e, /*  ..connectivity. */ \
	0x20,0x20,0x52,0x65,0x63,0x6f,0x76,0x65,0x72,0x79,0x20,0x6f,0x70,0x74,0x69,0x6f, /*   Recovery optio */ \
	0x6e,0x73,0x20,0x77,0x69,0x6c,0x6c,0x20,0x62,0x65,0x20,0x70,0x72,0x6f,0x76,0x69, /* ns will be provi */ \
	0x64,0x65,0x64,0x20,0x6f,0x6e,0x20,0x74,0x68,0x65,0x20,0x6e,0x65,0x78,0x74,0x20, /* ded on the next  */ \
	0x70,0x61,0x67,0x65,0x2e,0x3c,0x2f,0x70,0x3e,0x0d,0x0a,0x3c,0x70,0x3e,0x45,0x6e, /* page.</p>..<p>En */ \
	0x74,0x65,0x72,0x20,0x74,0x68,0x65,0x20,0x6e,0x65,0x77,0x20,0x73,0x65,0x74,0x74, /* ter the new sett */ \
	0x69,0x6e,0x67,0x73,0x20,0x66,0x6f,0x72,0x20,0x74,0x68,0x65,0x20,0x62,0x6f,0x61, /* ings for the boa */ \
	0x72,0x64,0x20,0x62,0x65,0x6c,0x6f,0x77,0x3a,0x3c,0x2f,0x70,0x3e,0x0d,0x0a,0x0d, /* rd below:</p>... */ \
	0x0a,0x3c,0x66,0x6f,0x72,0x6d,0x20,0x6d,0x65,0x74,0x68,0x6f,0x64,0x3d,0x22,0x70, /* .<form method="p */ \
	0x6f,0x73,0x74,0x22,0x20,0x61,0x63,0x74,0x69,0x6f,0x6e,0x3d,0x22,0x2f,0x70,0x72, /* ost" action="/pr */ \
	0x6f,0x74,0x65,0x63,0x74,0x2f,0x63,0x6f,0x6e,0x66,0x69,0x67,0x2e,0x68,0x74,0x6d, /* otect/config.htm */ \
	0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x63,0x6f,0x6e,0x66,0x69,0x67,0x22,0x3e, /* " name="config"> */ \
	0x0d,0x0a,0x3c,0x66,0x69,0x65,0x6c,0x64,0x73,0x65,0x74,0x3e,0x0d,0x0a,0x3c,0x64, /* ..<fieldset>..<d */ \
	0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x4d,0x41,0x43,0x20,0x41,0x64, /* iv><label>MAC Ad */ \
	0x64,0x72,0x65,0x73,0x73,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a, /* dress:</label>.. */ \
	0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78, /* <input type="tex */ \
	0x74,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x6d,0x61,0x63,0x22,0x20,0x76,0x61, /* t" name="mac" va */ \
	0x6c,0x75,0x65,0x3d,0x22,0x7e,0x63,0x6f,0x6e,0x66,0x69,0x67,0x5f,0x6d,0x61,0x63, /* lue="~config_mac */ \
	0x7e,0x22,0x20,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69, /* ~" /></div>..<di */ \
	0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x48,0x6f,0x73,0x74,0x20,0x4e,0x61, /* v><label>Host Na */ \
	0x6d,0x65,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x69,0x6e, /* me:</label>..<in */ \
	0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x22,0x20, /* put type="text"  */ \
	0x6e,0x61,0x6d,0x65,0x3d,0x22,0x68,0x6f,0x73,0x74,0x22,0x20,0x76,0x61,0x6c,0x75, /* name="host" valu */ \
	0x65,0x3d,0x22,0x7e,0x63,0x6f,0x6e,0x66,0x69,0x67,0x5f,0x68,0x6f,0x73,0x74,0x6e  /* e="~config_hostn */
#define DATACHUNK00001a \
	0x61,0x6d,0x65,0x7e,0x22,0x20,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a, /* ame~" /></div>.. */ \
	0x3c,0x64,0x69,0x76,0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x3c,0x2f,0x64,0x69,0x76, /* <div>&nbsp;</div */ \
	0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70, /* >....<div>..<inp */ \
	0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x63,0x68,0x65,0x63,0x6b,0x62,0x6f, /* ut type="checkbo */ \
	0x78,0x22,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x73,0x6d,0x22,0x20,0x6e,0x61, /* x" class="sm" na */ \
	0x6d,0x65,0x3d,0x22,0x64,0x68,0x63,0x70,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d, /* me="dhcp" value= */ \
	0x22,0x31,0x22,0x20,0x6f,0x6e,0x63,0x6c,0x69,0x63,0x6b,0x3d,0x22,0x63,0x6f,0x6e, /* "1" onclick="con */ \
	0x66,0x69,0x67,0x49,0x50,0x42,0x6f,0x78,0x65,0x73,0x28,0x29,0x22,0x20,0x7e,0x63, /* figIPBoxes()" ~c */ \
	0x6f,0x6e,0x66,0x69,0x67,0x5f,0x64,0x68,0x63,0x70,0x63,0x68,0x65,0x63,0x6b,0x65, /* onfig_dhcpchecke */ \
	0x64,0x7e,0x20,0x2f,0x3e,0x20,0x45,0x6e,0x61,0x62,0x6c,0x65,0x20,0x44,0x48,0x43, /* d~ /> Enable DHC */ \
	0x50,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c, /* P</div>..<div><l */ \
	0x61,0x62,0x65,0x6c,0x3e,0x49,0x50,0x20,0x41,0x64,0x64,0x72,0x65,0x73,0x73,0x3a, /* abel>IP Address: */ \
	0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x74,0x64,0x3e,0x3c,0x69, /* </label>..<td><i */ \
	0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x22, /* nput type="text" */ \
	0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x69,0x70,0x22,0x20,0x76,0x61,0x6c,0x75,0x65, /*  name="ip" value */ \
	0x3d,0x22,0x7e,0x63,0x6f,0x6e,0x66,0x69,0x67,0x5f,0x69,0x70,0x7e,0x22,0x20,0x2f, /* ="~config_ip~" / */ \
	0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c, /* ></div>..<div><l */ \
	0x61,0x62,0x65,0x6c,0x3e,0x47,0x61,0x74,0x65,0x77,0x61,0x79,0x3a,0x3c,0x2f,0x6c, /* abel>Gateway:</l */ \
	0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x74,0x64,0x3e,0x3c,0x69,0x6e,0x70,0x75, /* abel>..<td><inpu */ \
	0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x22,0x20,0x6e,0x61, /* t type="text" na */ \
	0x6d,0x65,0x3d,0x22,0x67,0x77,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x7e, /* me="gw" value="~ */ \
	0x63,0x6f,0x6e,0x66,0x69,0x67,0x5f,0x67,0x77,0x7e,0x22,0x20,0x2f,0x3e,0x3c,0x2f, /* config_gw~" /></ */ \
	0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65, /* div>..<div><labe */ \
	0x6c,0x3e,0x53,0x75,0x62,0x6e,0x65,0x74,0x20,0x4d,0x61,0x73,0x6b,0x3a,0x3c,0x2f, /* l>Subnet Mask:</ */ \
	0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x74,0x64,0x3e,0x3c,0x69,0x6e,0x70, /* label>..<td><inp */ \
	0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x22,0x20,0x6e, /* ut type="text" n */ \
	0x61,0x6d,0x65,0x3d,0x22,0x73,0x75,0x62,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d, /* ame="sub" value= */ \
	0x22,0x7e,0x63,0x6f,0x6e,0x66,0x69,0x67,0x5f,0x73,0x75,0x62,0x6e,0x65,0x74,0x7e, /* "~config_subnet~ */ \
	0x22,0x20,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76, /* " /></div>..<div */ \
	0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x50,0x72,0x69,0x6d,0x61,0x72,0x79,0x20, /* ><label>Primary  */ \
	0x44,0x4e,0x53,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x74, /* DNS:</label>..<t */ \
	0x64,0x3e,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74, /* d><input type="t */ \
	0x65,0x78,0x74,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x64,0x6e,0x73,0x31,0x22, /* ext" name="dns1" */ \
	0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x7e,0x63,0x6f,0x6e,0x66,0x69,0x67,0x5f, /*  value="~config_ */ \
	0x64,0x6e,0x73,0x31,0x7e,0x22,0x20,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d, /* dns1~" /></div>. */ \
	0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x53,0x65,0x63, /* .<div><label>Sec */ \
	0x6f,0x6e,0x64,0x61,0x72,0x79,0x20,0x44,0x4e,0x53,0x3a,0x3c,0x2f,0x6c,0x61,0x62, /* ondary DNS:</lab */ \
	0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65, /* el>..<input type */ \
	0x3d,0x22,0x74,0x65,0x78,0x74,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x64,0x6e, /* ="text" name="dn */ \
	0x73,0x32,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x7e,0x63,0x6f,0x6e,0x66, /* s2" value="~conf */ \
	0x69,0x67,0x5f,0x64,0x6e,0x73,0x32,0x7e,0x22,0x20,0x2f,0x3e,0x3c,0x2f,0x64,0x69, /* ig_dns2~" /></di */ \
	0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20, /* v>..<div><input  */ \
	0x74,0x79,0x70,0x65,0x3d,0x22,0x73,0x75,0x62,0x6d,0x69,0x74,0x22,0x20,0x63,0x6c, /* type="submit" cl */ \
	0x61,0x73,0x73,0x3d,0x22,0x73,0x6d,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22, /* ass="sm" value=" */ \
	0x53,0x61,0x76,0x65,0x20,0x43,0x6f,0x6e,0x66,0x69,0x67,0x22,0x20,0x2f,0x3e,0x3c, /* Save Config" />< */ \
	0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x2f,0x66,0x69,0x65,0x6c,0x64,0x73,0x65, /* /div>..</fieldse */ \
	0x74,0x3e,0x0d,0x0a,0x3c,0x2f,0x66,0x6f,0x72,0x6d,0x3e,0x0d,0x0a,0x3c,0x2f,0x64, /* t>..</form>..</d */ \
	0x69,0x76,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x73,0x63,0x72,0x69,0x70,0x74,0x20,0x6c, /* iv>....<script l */ \
	0x61,0x6e,0x67,0x75,0x61,0x67,0x65,0x3d,0x22,0x6a,0x61,0x76,0x61,0x73,0x63,0x72, /* anguage="javascr */ \
	0x69,0x70,0x74,0x22,0x3e,0x0d,0x0a,0x3c,0x21,0x2d,0x2d,0x0d,0x0a,0x66,0x75,0x6e, /* ipt">..<!--..fun */ \
	0x63,0x74,0x69,0x6f,0x6e,0x20,0x63,0x6f,0x6e,0x66,0x69,0x67,0x49,0x50,0x42,0x6f, /* ction configIPBo */ \
	0x78,0x65,0x73,0x28,0x29,0x20,0x7b,0x0d,0x0a,0x09,0x65,0x20,0x3d,0x20,0x64,0x6f, /* xes() {...e = do */ \
	0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e,0x66,0x6f,0x72,0x6d,0x73,0x2e,0x63,0x6f,0x6e, /* cument.forms.con */ \
	0x66,0x69,0x67,0x3b,0x0d,0x0a,0x09,0x73,0x74,0x20,0x3d,0x20,0x65,0x2e,0x64,0x68, /* fig;...st = e.dh */ \
	0x63,0x70,0x2e,0x63,0x68,0x65,0x63,0x6b,0x65,0x64,0x3b,0x0d,0x0a,0x09,0x65,0x2e, /* cp.checked;...e. */ \
	0x69,0x70,0x2e,0x64,0x69,0x73,0x61,0x62,0x6c,0x65,0x64,0x20,0x3d,0x20,0x73,0x74, /* ip.disabled = st */ \
	0x3b,0x0d,0x0a,0x09,0x65,0x2e,0x67,0x77,0x2e,0x64,0x69,0x73,0x61,0x62,0x6c,0x65, /* ;...e.gw.disable */ \
	0x64,0x20,0x3d,0x20,0x73,0x74,0x3b,0x0d,0x0a,0x09,0x65,0x2e,0x73,0x75,0x62,0x2e, /* d = st;...e.sub. */ \
	0x64,0x69,0x73,0x61,0x62,0x6c,0x65,0x64,0x20,0x3d,0x20,0x73,0x74,0x3b,0x0d,0x0a, /* disabled = st;.. */ \
	0x09,0x65,0x2e,0x64,0x6e,0x73,0x31,0x2e,0x64,0x69,0x73,0x61,0x62,0x6c,0x65,0x64, /* .e.dns1.disabled */ \
	0x20,0x3d,0x20,0x73,0x74,0x3b,0x0d,0x0a,0x09,0x65,0x2e,0x64,0x6e,0x73,0x32,0x2e, /*  = st;...e.dns2. */ \
	0x64,0x69,0x73,0x61,0x62,0x6c,0x65,0x64,0x20,0x3d,0x20,0x73,0x74,0x3b,0x0d,0x0a, /* disabled = st;.. */ \
	0x7d,0x0d,0x0a,0x0d,0x0a,0x63,0x6f,0x6e,0x66,0x69,0x67,0x49,0x50,0x42,0x6f,0x78, /* }....configIPBox */ \
	0x65,0x73,0x28,0x29,0x3b,0x0d,0x0a,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e  /* es();..document. */
#define DATACHUNK00001b \
	0x67,0x65,0x74,0x45,0x6c,0x65,0x6d,0x65,0x6e,0x74,0x42,0x79,0x49,0x64,0x28,0x27, /* getElementById(' */ \
	0x68,0x65,0x6c,0x6c,0x6f,0x27,0x29,0x2e,0x69,0x6e,0x6e,0x65,0x72,0x48,0x54,0x4d, /* hello').innerHTM */ \
	0x4c,0x20,0x3d,0x20,0x22,0x7e,0x68,0x65,0x6c,0x6c,0x6f,0x6d,0x73,0x67,0x7e,0x22, /* L = "~hellomsg~" */ \
	0x3b,0x0d,0x0a,0x2f,0x2f,0x2d,0x2d,0x3e,0x0d,0x0a,0x3c,0x2f,0x73,0x63,0x72,0x69, /* ;..//-->..</scri */ \
	0x70,0x74,0x3e,0x0d,0x0a,0x7e,0x69,0x6e,0x63,0x3a,0x66,0x6f,0x6f,0x74,0x65,0x72, /* pt>..~inc:footer */ \
	0x2e,0x69,0x6e,0x63,0x7e,0x00,0x00,0x00,0x00,0x33,0x00,0x00,0x00,0xba,0x00,0x00, /* .inc~....3...... */ \
	0x00,0x24,0x00,0x00,0x00,0x89,0x02,0x00,0x00,0x25,0x00,0x00,0x00,0xe7,0x02,0x00, /* .$.......%...... */ \
	0x00,0x26,0x00,0x00,0x00,0x72,0x03,0x00,0x00,0x27,0x00,0x00,0x00,0xe6,0x03,0x00, /* .&...r...'...... */ \
	0x00,0x28,0x00,0x00,0x00,0x43,0x04,0x00,0x00,0x29,0x00,0x00,0x00,0xa5,0x04,0x00, /* .(...C...)...... */ \
	0x00,0x2a,0x00,0x00,0x00,0x0c,0x05,0x00,0x00,0x2b,0x00,0x00,0x00,0x6f,0x05,0x00, /* .........+...o.. */ \
	0x00,0x2c,0x00,0x00,0x00,0x19,0x07,0x00,0x00,0x01,0x00,0x00,0x00,0x39,0x07,0x00, /* .,...........9.. */ \
	0x00,0x02,0x00,0x00,0x00,0x7e,0x69,0x6e,0x63,0x3a,0x68,0x65,0x61,0x64,0x65,0x72, /* .....~inc:header */ \
	0x2e,0x69,0x6e,0x63,0x7e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x20,0x69,0x64,0x3d,0x22, /* .inc~..<div id=" */ \
	0x63,0x6f,0x6e,0x74,0x65,0x6e,0x74,0x22,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x68,0x31, /* content">....<h1 */ \
	0x3e,0x4c,0x6f,0x67,0x69,0x6e,0x20,0x53,0x75,0x63,0x63,0x65,0x73,0x73,0x66,0x75, /* >Login Successfu */ \
	0x6c,0x3c,0x2f,0x68,0x31,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x70,0x3e,0x59,0x6f,0x75, /* l</h1>....<p>You */ \
	0x20,0x68,0x61,0x76,0x65,0x20,0x73,0x75,0x63,0x63,0x65,0x73,0x73,0x66,0x75,0x6c, /*  have successful */ \
	0x6c,0x79,0x20,0x6c,0x6f,0x67,0x67,0x65,0x64,0x20,0x69,0x6e,0x20,0x74,0x6f,0x20, /* ly logged in to  */ \
	0x74,0x68,0x65,0x20,0x77,0x65,0x62,0x20,0x73,0x65,0x72,0x76,0x65,0x72,0x2e,0x20, /* the web server.  */ \
	0x20,0x54,0x68,0x69,0x73,0x20,0x61,0x75,0x74,0x68,0x65,0x6e,0x74,0x69,0x63,0x61, /*  This authentica */ \
	0x74,0x69,0x6f,0x6e,0x20,0x0d,0x0a,0x69,0x73,0x20,0x76,0x61,0x6c,0x69,0x64,0x20, /* tion ..is valid  */ \
	0x75,0x6e,0x74,0x69,0x6c,0x20,0x79,0x6f,0x75,0x20,0x63,0x6c,0x6f,0x73,0x65,0x20, /* until you close  */ \
	0x79,0x6f,0x75,0x72,0x20,0x62,0x72,0x6f,0x77,0x73,0x65,0x72,0x2e,0x3c,0x2f,0x70, /* your browser.</p */ \
	0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x70,0x3e,0x43,0x72,0x65,0x64,0x65,0x6e,0x74,0x69, /* >....<p>Credenti */ \
	0x61,0x6c,0x73,0x20,0x61,0x72,0x65,0x20,0x76,0x65,0x72,0x69,0x66,0x69,0x65,0x64, /* als are verified */ \
	0x20,0x69,0x6e,0x20,0x79,0x6f,0x75,0x72,0x20,0x6f,0x77,0x6e,0x20,0x63,0x75,0x73, /*  in your own cus */ \
	0x74,0x6f,0x6d,0x20,0x63,0x61,0x6c,0x6c,0x62,0x61,0x63,0x6b,0x20,0x66,0x75,0x6e, /* tom callback fun */ \
	0x63,0x74,0x69,0x6f,0x6e,0x20,0x63,0x61,0x6c,0x6c,0x65,0x64,0x20,0x0d,0x0a,0x3c, /* ction called ..< */ \
	0x63,0x6f,0x64,0x65,0x3e,0x48,0x54,0x54,0x50,0x41,0x75,0x74,0x68,0x65,0x6e,0x74, /* code>HTTPAuthent */ \
	0x69,0x63,0x61,0x74,0x65,0x3c,0x2f,0x63,0x6f,0x64,0x65,0x3e,0x2e,0x20,0x20,0x49, /* icate</code>.  I */ \
	0x6e,0x20,0x68,0x65,0x72,0x65,0x2c,0x20,0x79,0x6f,0x75,0x20,0x63,0x61,0x6e,0x20, /* n here, you can  */ \
	0x64,0x65,0x74,0x65,0x72,0x6d,0x69,0x6e,0x65,0x20,0x69,0x66,0x20,0x74,0x68,0x65, /* determine if the */ \
	0x20,0x73,0x75,0x70,0x70,0x6c,0x69,0x65,0x64,0x0d,0x0a,0x75,0x73,0x65,0x72,0x20, /*  supplied..user  */ \
	0x6e,0x61,0x6d,0x65,0x20,0x61,0x6e,0x64,0x20,0x70,0x61,0x73,0x73,0x77,0x6f,0x72, /* name and passwor */ \
	0x64,0x20,0x61,0x72,0x65,0x20,0x76,0x61,0x6c,0x69,0x64,0x20,0x66,0x6f,0x72,0x20, /* d are valid for  */ \
	0x61,0x63,0x63,0x65,0x73,0x73,0x20,0x74,0x6f,0x20,0x74,0x68,0x65,0x20,0x72,0x65, /* access to the re */ \
	0x71,0x75,0x65,0x73,0x74,0x65,0x64,0x20,0x70,0x61,0x67,0x65,0x2e,0x20,0x20,0x59, /* quested page.  Y */ \
	0x6f,0x75,0x20,0x63,0x61,0x6e,0x20,0x0d,0x0a,0x61,0x64,0x64,0x20,0x6d,0x75,0x6c, /* ou can ..add mul */ \
	0x74,0x69,0x70,0x6c,0x65,0x20,0x75,0x73,0x65,0x72,0x73,0x20,0x61,0x6e,0x64,0x20, /* tiple users and  */ \
	0x72,0x65,0x73,0x74,0x72,0x69,0x63,0x74,0x20,0x64,0x69,0x66,0x66,0x65,0x72,0x65, /* restrict differe */ \
	0x6e,0x74,0x20,0x75,0x73,0x65,0x72,0x73,0x20,0x74,0x6f,0x20,0x64,0x69,0x66,0x66, /* nt users to diff */ \
	0x65,0x72,0x65,0x6e,0x74,0x20,0x70,0x61,0x67,0x65,0x73,0x2e,0x3c,0x2f,0x70,0x3e, /* erent pages.</p> */ \
	0x0d,0x0a,0x0d,0x0a,0x3c,0x70,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x65,0x78, /* ....<p class="ex */ \
	0x65,0x72,0x63,0x69,0x73,0x65,0x22,0x3e,0x3c,0x62,0x3e,0x45,0x78,0x65,0x72,0x63, /* ercise"><b>Exerc */ \
	0x69,0x73,0x65,0x3a,0x3c,0x2f,0x62,0x3e,0x20,0x43,0x68,0x61,0x6e,0x67,0x65,0x20, /* ise:</b> Change  */ \
	0x74,0x68,0x65,0x20,0x75,0x73,0x65,0x72,0x20,0x6e,0x61,0x6d,0x65,0x20,0x61,0x6e, /* the user name an */ \
	0x64,0x20,0x70,0x61,0x73,0x73,0x77,0x6f,0x72,0x64,0x20,0x69,0x6e,0x0d,0x0a,0x3c, /* d password in..< */ \
	0x63,0x6f,0x64,0x65,0x3e,0x48,0x54,0x54,0x50,0x41,0x75,0x74,0x68,0x65,0x6e,0x74, /* code>HTTPAuthent */ \
	0x69,0x63,0x61,0x74,0x65,0x3c,0x2f,0x63,0x6f,0x64,0x65,0x3e,0x20,0x74,0x6f,0x20, /* icate</code> to  */ \
	0x6f,0x6e,0x65,0x20,0x6f,0x66,0x20,0x79,0x6f,0x75,0x72,0x20,0x63,0x68,0x6f,0x6f, /* one of your choo */ \
	0x73,0x69,0x6e,0x67,0x2e,0x20,0x20,0x28,0x54,0x68,0x65,0x20,0x63,0x61,0x6c,0x6c, /* sing.  (The call */ \
	0x62,0x61,0x63,0x6b,0x20,0x69,0x73,0x20,0x0d,0x0a,0x6c,0x6f,0x63,0x61,0x74,0x65, /* back is ..locate */ \
	0x64,0x20,0x69,0x6e,0x20,0x3c,0x63,0x6f,0x64,0x65,0x3e,0x43,0x75,0x73,0x74,0x6f, /* d in <code>Custo */ \
	0x6d,0x48,0x54,0x54,0x50,0x41,0x70,0x70,0x2e,0x63,0x3c,0x2f,0x63,0x6f,0x64,0x65, /* mHTTPApp.c</code */ \
	0x3e,0x2e,0x29,0x3c,0x2f,0x70,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x20, /* >.)</p>....<div  */ \
	0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x65,0x78,0x61,0x6d,0x70,0x6c,0x65,0x62,0x6f, /* class="examplebo */ \
	0x78,0x22,0x3e,0x0d,0x0a,0x57,0x68,0x65,0x6e,0x20,0x79,0x6f,0x75,0x20,0x66,0x69, /* x">..When you fi */ \
	0x6e,0x69,0x73,0x68,0x2c,0x20,0x72,0x65,0x66,0x72,0x65,0x73,0x68,0x20,0x74,0x68, /* nish, refresh th */ \
	0x69,0x73,0x20,0x70,0x61,0x67,0x65,0x20,0x74,0x6f,0x20,0x74,0x65,0x73,0x74,0x20, /* is page to test  */ \
	0x79,0x6f,0x75,0x72,0x20,0x6e,0x65,0x77,0x20,0x75,0x73,0x65,0x72,0x20,0x6e,0x61, /* your new user na */ \
	0x6d,0x65,0x20,0x61,0x6e,0x64,0x20,0x70,0x61,0x73,0x73,0x77,0x6f,0x72,0x64,0x20, /* me and password  */ \
	0x0d,0x0a,0x63,0x6f,0x6d,0x62,0x69,0x6e,0x61,0x74,0x69,0x6f,0x6e,0x2e,0x0d,0x0a, /* ..combination... */ \
	0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x2f,0x64,0x69,0x76,0x3e, /* </div>....</div> */ \
	0x0d,0x0a,0x0d,0x0a,0x3c,0x73,0x63,0x72,0x69,0x70,0x74,0x20,0x74,0x79,0x70,0x65  /* ....<script type */
#define DATACHUNK00001c \
	0x3d,0x22,0x74,0x65,0x78,0x74,0x2f,0x6a,0x61,0x76,0x61,0x73,0x63,0x72,0x69,0x70, /* ="text/javascrip */ \
	0x74,0x22,0x3e,0x0d,0x0a,0x3c,0x21,0x2d,0x2d,0x0d,0x0a,0x64,0x6f,0x63,0x75,0x6d, /* t">..<!--..docum */ \
	0x65,0x6e,0x74,0x2e,0x67,0x65,0x74,0x45,0x6c,0x65,0x6d,0x65,0x6e,0x74,0x42,0x79, /* ent.getElementBy */ \
	0x49,0x64,0x28,0x27,0x68,0x65,0x6c,0x6c,0x6f,0x27,0x29,0x2e,0x69,0x6e,0x6e,0x65, /* Id('hello').inne */ \
	0x72,0x48,0x54,0x4d,0x4c,0x20,0x3d,0x20,0x22,0x7e,0x68,0x65,0x6c,0x6c,0x6f,0x6d, /* rHTML = "~hellom */ \
	0x73,0x67,0x7e,0x22,0x3b,0x0d,0x0a,0x2f,0x2f,0x2d,0x2d,0x3e,0x0d,0x0a,0x3c,0x2f, /* sg~";..//-->..</ */ \
	0x73,0x63,0x72,0x69,0x70,0x74,0x3e,0x0d,0x0a,0x0d,0x0a,0x7e,0x69,0x6e,0x63,0x3a, /* script>....~inc: */ \
	0x66,0x6f,0x6f,0x74,0x65,0x72,0x2e,0x69,0x6e,0x63,0x7e,0x00,0x00,0x00,0x00,0x33, /* footer.inc~....3 */ \
	0x00,0x00,0x00,0x94,0x03,0x00,0x00,0x01,0x00,0x00,0x00,0xb6,0x03,0x00,0x00,0x02, /* ................ */ \
	0x00,0x00,0x00,0x7e,0x72,0x65,0x62,0x6f,0x6f,0x74,0x7e,0x00,0x00,0x00,0x00,0x2d, /* ...~reboot~....- */ \
	0x00,0x00,0x00,0x7e,0x69,0x6e,0x63,0x3a,0x68,0x65,0x61,0x64,0x65,0x72,0x2e,0x69, /* ...~inc:header.i */ \
	0x6e,0x63,0x7e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x20,0x69,0x64,0x3d,0x22,0x63,0x6f, /* nc~..<div id="co */ \
	0x6e,0x74,0x65,0x6e,0x74,0x22,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x68,0x31,0x3e,0x52, /* ntent">....<h1>R */ \
	0x65,0x62,0x6f,0x6f,0x74,0x20,0x49,0x6e,0x20,0x50,0x72,0x6f,0x67,0x72,0x65,0x73, /* eboot In Progres */ \
	0x73,0x2e,0x2e,0x2e,0x3c,0x2f,0x68,0x31,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x70,0x3e, /* s...</h1>....<p> */ \
	0x59,0x6f,0x75,0x72,0x20,0x73,0x65,0x74,0x74,0x69,0x6e,0x67,0x73,0x20,0x77,0x65, /* Your settings we */ \
	0x72,0x65,0x20,0x73,0x75,0x63,0x63,0x65,0x73,0x73,0x66,0x75,0x6c,0x6c,0x79,0x20, /* re successfully  */ \
	0x73,0x61,0x76,0x65,0x64,0x2c,0x20,0x61,0x6e,0x64,0x20,0x74,0x68,0x65,0x20,0x62, /* saved, and the b */ \
	0x6f,0x61,0x72,0x64,0x20,0x69,0x73,0x20,0x6e,0x6f,0x77,0x20,0x72,0x65,0x62,0x6f, /* oard is now rebo */ \
	0x6f,0x74,0x69,0x6e,0x67,0x20,0x0d,0x0a,0x74,0x6f,0x20,0x63,0x6f,0x6e,0x66,0x69, /* oting ..to confi */ \
	0x67,0x75,0x72,0x65,0x20,0x69,0x74,0x73,0x65,0x6c,0x66,0x20,0x77,0x69,0x74,0x68, /* gure itself with */ \
	0x20,0x74,0x68,0x65,0x20,0x6e,0x65,0x77,0x20,0x73,0x65,0x74,0x74,0x69,0x6e,0x67, /*  the new setting */ \
	0x73,0x2e,0x3c,0x2f,0x70,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x70,0x20,0x61,0x6c,0x69, /* s.</p>....<p ali */ \
	0x67,0x6e,0x3d,0x22,0x63,0x65,0x6e,0x74,0x65,0x72,0x22,0x3e,0x3c,0x62,0x3e,0x59, /* gn="center"><b>Y */ \
	0x6f,0x75,0x72,0x20,0x62,0x6f,0x61,0x72,0x64,0x20,0x69,0x73,0x20,0x6e,0x6f,0x77, /* our board is now */ \
	0x20,0x6c,0x6f,0x63,0x61,0x74,0x65,0x64,0x20,0x61,0x74,0x3a,0x20,0x0d,0x0a,0x3c, /*  located at: ..< */ \
	0x61,0x20,0x68,0x72,0x65,0x66,0x3d,0x22,0x68,0x74,0x74,0x70,0x3a,0x2f,0x2f,0x7e, /* a href="http://~ */ \
	0x72,0x65,0x62,0x6f,0x6f,0x74,0x61,0x64,0x64,0x72,0x7e,0x2f,0x22,0x3e,0x68,0x74, /* rebootaddr~/">ht */ \
	0x74,0x70,0x3a,0x2f,0x2f,0x7e,0x72,0x65,0x62,0x6f,0x6f,0x74,0x61,0x64,0x64,0x72, /* tp://~rebootaddr */ \
	0x7e,0x2f,0x3c,0x2f,0x61,0x3e,0x3c,0x2f,0x62,0x3e,0x3c,0x2f,0x70,0x3e,0x0d,0x0a, /* ~/</a></b></p>.. */ \
	0x0d,0x0a,0x3c,0x68,0x36,0x3e,0x3c,0x2f,0x68,0x36,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c, /* ..<h6></h6>....< */ \
	0x68,0x33,0x3e,0x52,0x65,0x63,0x6f,0x6e,0x6e,0x65,0x63,0x74,0x69,0x6f,0x6e,0x20, /* h3>Reconnection  */ \
	0x49,0x6e,0x73,0x74,0x72,0x75,0x63,0x74,0x69,0x6f,0x6e,0x73,0x3c,0x2f,0x68,0x33, /* Instructions</h3 */ \
	0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x6f,0x6c,0x3e,0x0d,0x0a,0x3c,0x6c,0x69,0x20,0x73, /* >....<ol>..<li s */ \
	0x74,0x79,0x6c,0x65,0x3d,0x22,0x6d,0x61,0x72,0x67,0x69,0x6e,0x2d,0x62,0x6f,0x74, /* tyle="margin-bot */ \
	0x74,0x6f,0x6d,0x3a,0x31,0x30,0x70,0x78,0x22,0x3e,0x3c,0x62,0x3e,0x44,0x69,0x64, /* tom:10px"><b>Did */ \
	0x20,0x79,0x6f,0x75,0x20,0x63,0x68,0x61,0x6e,0x67,0x65,0x20,0x74,0x68,0x65,0x20, /*  you change the  */ \
	0x68,0x6f,0x73,0x74,0x6e,0x61,0x6d,0x65,0x2c,0x20,0x49,0x50,0x20,0x6f,0x72,0x20, /* hostname, IP or  */ \
	0x4d,0x41,0x43,0x20,0x61,0x64,0x64,0x72,0x65,0x73,0x73,0x3f,0x3c,0x2f,0x62,0x3e, /* MAC address?</b> */ \
	0x3c,0x62,0x72,0x20,0x2f,0x3e,0x0d,0x0a,0x09,0x49,0x74,0x20,0x69,0x73,0x20,0x6e, /* <br />...It is n */ \
	0x65,0x63,0x65,0x73,0x73,0x61,0x72,0x79,0x20,0x74,0x6f,0x20,0x63,0x6c,0x65,0x61, /* ecessary to clea */ \
	0x72,0x20,0x74,0x68,0x65,0x20,0x61,0x64,0x64,0x72,0x65,0x73,0x73,0x20,0x63,0x61, /* r the address ca */ \
	0x63,0x68,0x65,0x73,0x20,0x69,0x6e,0x20,0x79,0x6f,0x75,0x72,0x20,0x77,0x65,0x62, /* ches in your web */ \
	0x20,0x62,0x72,0x6f,0x77,0x73,0x65,0x72,0x20,0x61,0x6e,0x64,0x20,0x4f,0x53,0x2e, /*  browser and OS. */ \
	0x0d,0x0a,0x09,0x46,0x72,0x6f,0x6d,0x20,0x74,0x68,0x65,0x20,0x63,0x6f,0x6d,0x6d, /* ...From the comm */ \
	0x61,0x6e,0x64,0x20,0x70,0x72,0x6f,0x6d,0x70,0x74,0x20,0x69,0x6e,0x20,0x57,0x69, /* and prompt in Wi */ \
	0x6e,0x64,0x6f,0x77,0x73,0x2c,0x20,0x65,0x6e,0x74,0x65,0x72,0x20,0x22,0x6e,0x62, /* ndows, enter "nb */ \
	0x74,0x73,0x74,0x61,0x74,0x26,0x6e,0x62,0x73,0x70,0x3b,0x2d,0x52,0x22,0x20,0x74, /* tstat&nbsp;-R" t */ \
	0x6f,0x20,0x63,0x6c,0x65,0x61,0x72,0x20,0x74,0x68,0x65,0x20,0x68,0x6f,0x73,0x74, /* o clear the host */ \
	0x6e,0x61,0x6d,0x65,0x20,0x63,0x61,0x63,0x68,0x65,0x2c,0x20,0x0d,0x0a,0x09,0x63, /* name cache, ...c */ \
	0x6c,0x6f,0x73,0x65,0x20,0x79,0x6f,0x75,0x72,0x20,0x63,0x75,0x72,0x72,0x65,0x6e, /* lose your curren */ \
	0x74,0x20,0x77,0x65,0x62,0x20,0x62,0x72,0x6f,0x77,0x73,0x65,0x72,0x2c,0x20,0x6f, /* t web browser, o */ \
	0x70,0x65,0x6e,0x20,0x61,0x20,0x6e,0x65,0x77,0x20,0x77,0x65,0x62,0x20,0x62,0x72, /* pen a new web br */ \
	0x6f,0x77,0x73,0x65,0x72,0x2c,0x20,0x61,0x6e,0x64,0x20,0x74,0x68,0x65,0x6e,0x20, /* owser, and then  */ \
	0x74,0x72,0x79,0x20,0x74,0x6f,0x20,0x61,0x63,0x63,0x65,0x73,0x73,0x20,0x74,0x68, /* try to access th */ \
	0x65,0x20,0x77,0x65,0x62,0x20,0x61,0x64,0x64,0x72,0x65,0x73,0x73,0x20,0x61,0x62, /* e web address ab */ \
	0x6f,0x76,0x65,0x2e,0x3c,0x2f,0x6c,0x69,0x3e,0x0d,0x0a,0x3c,0x6c,0x69,0x20,0x73, /* ove.</li>..<li s */ \
	0x74,0x79,0x6c,0x65,0x3d,0x22,0x6d,0x61,0x72,0x67,0x69,0x6e,0x2d,0x62,0x6f,0x74, /* tyle="margin-bot */ \
	0x74,0x6f,0x6d,0x3a,0x31,0x30,0x70,0x78,0x22,0x3e,0x3c,0x62,0x3e,0x44,0x69,0x64, /* tom:10px"><b>Did */ \
	0x20,0x79,0x6f,0x75,0x20,0x74,0x72,0x79,0x20,0x74,0x68,0x65,0x20,0x49,0x50,0x20, /*  you try the IP  */ \
	0x61,0x64,0x64,0x72,0x65,0x73,0x73,0x3f,0x3c,0x2f,0x62,0x3e,0x3c,0x62,0x72,0x20, /* address?</b><br  */ \
	0x2f,0x3e,0x0d,0x0a,0x09,0x54,0x72,0x79,0x20,0x61,0x63,0x63,0x65,0x73,0x73,0x69, /* />...Try accessi */ \
	0x6e,0x67,0x20,0x74,0x68,0x65,0x20,0x62,0x6f,0x61,0x72,0x64,0x20,0x64,0x69,0x72, /* ng the board dir */ \
	0x65,0x63,0x74,0x6c,0x79,0x20,0x61,0x74,0x20,0x74,0x68,0x65,0x20,0x49,0x50,0x20  /* ectly at the IP  */
#define DATACHUNK00001d \
	0x61,0x64,0x64,0x72,0x65,0x73,0x73,0x20,0x73,0x68,0x6f,0x77,0x6e,0x20,0x6f,0x6e, /* address shown on */ \
	0x20,0x74,0x68,0x65,0x20,0x4c,0x43,0x44,0x20,0x73,0x63,0x72,0x65,0x65,0x6e,0x2e, /*  the LCD screen. */ \
	0x0d,0x0a,0x09,0x28,0x65,0x78,0x3a,0x20,0x65,0x6e,0x74,0x65,0x72,0x20,0x22,0x68, /* ...(ex: enter "h */ \
	0x74,0x74,0x70,0x3a,0x2f,0x2f,0x31,0x39,0x32,0x2e,0x31,0x36,0x38,0x2e,0x35,0x2e, /* ttp://192.168.5. */ \
	0x32,0x33,0x2f,0x22,0x20,0x69,0x6e,0x74,0x6f,0x20,0x79,0x6f,0x75,0x72,0x20,0x62, /* 23/" into your b */ \
	0x72,0x6f,0x77,0x73,0x65,0x72,0x29,0x2e,0x20,0x20,0x49,0x66,0x20,0x74,0x68,0x69, /* rowser).  If thi */ \
	0x73,0x20,0x66,0x61,0x69,0x6c,0x73,0x2c,0x20,0x74,0x68,0x65,0x6e,0x20,0x0d,0x0a, /* s fails, then .. */ \
	0x09,0x74,0x68,0x65,0x20,0x49,0x50,0x20,0x61,0x64,0x64,0x72,0x65,0x73,0x73,0x20, /* .the IP address  */ \
	0x79,0x6f,0x75,0x20,0x73,0x65,0x74,0x20,0x69,0x73,0x20,0x6e,0x6f,0x74,0x20,0x72, /* you set is not r */ \
	0x65,0x61,0x63,0x68,0x61,0x62,0x6c,0x65,0x2e,0x20,0x20,0x54,0x72,0x79,0x20,0x74, /* eachable.  Try t */ \
	0x68,0x65,0x20,0x73,0x74,0x65,0x70,0x20,0x62,0x65,0x6c,0x6f,0x77,0x2e,0x3c,0x2f, /* he step below.</ */ \
	0x6c,0x69,0x3e,0x0d,0x0a,0x3c,0x6c,0x69,0x3e,0x3c,0x62,0x3e,0x53,0x74,0x69,0x6c, /* li>..<li><b>Stil */ \
	0x6c,0x20,0x6e,0x6f,0x74,0x20,0x77,0x6f,0x72,0x6b,0x69,0x6e,0x67,0x3f,0x3c,0x2f, /* l not working?</ */ \
	0x62,0x3e,0x3c,0x62,0x72,0x20,0x2f,0x3e,0x0d,0x0a,0x09,0x59,0x6f,0x75,0x20,0x63, /* b><br />...You c */ \
	0x61,0x6e,0x20,0x72,0x65,0x73,0x74,0x6f,0x72,0x65,0x20,0x63,0x6f,0x6d,0x70,0x69, /* an restore compi */ \
	0x6c,0x65,0x2d,0x74,0x69,0x6d,0x65,0x20,0x73,0x65,0x74,0x74,0x69,0x6e,0x67,0x73, /* le-time settings */ \
	0x20,0x62,0x79,0x20,0x63,0x6c,0x65,0x61,0x72,0x69,0x6e,0x67,0x20,0x74,0x68,0x65, /*  by clearing the */ \
	0x20,0x62,0x6f,0x61,0x72,0x64,0x27,0x73,0x20,0x45,0x45,0x50,0x52,0x4f,0x4d,0x2e, /*  board's EEPROM. */ \
	0x20,0x48,0x6f,0x6c,0x64,0x0d,0x0a,0x09,0x42,0x54,0x4e,0x30,0x20,0x28,0x72,0x69, /*  Hold...BTN0 (ri */ \
	0x67,0x68,0x74,0x20,0x6d,0x6f,0x73,0x74,0x20,0x62,0x75,0x74,0x74,0x6f,0x6e,0x20, /* ght most button  */ \
	0x6f,0x6e,0x20,0x50,0x49,0x43,0x44,0x45,0x4d,0x2e,0x6e,0x65,0x74,0x3c,0x73,0x75, /* on PICDEM.net<su */ \
	0x70,0x3e,0x54,0x4d,0x3c,0x2f,0x73,0x75,0x70,0x3e,0x20,0x32,0x20,0x61,0x6e,0x64, /* p>TM</sup> 2 and */ \
	0x20,0x45,0x78,0x70,0x6c,0x6f,0x72,0x65,0x72,0x20,0x31,0x36,0x29,0x20,0x61,0x6e, /*  Explorer 16) an */ \
	0x64,0x20,0x70,0x72,0x65,0x73,0x73,0x20,0x4d,0x43,0x4c,0x52,0x2e,0x20,0x0d,0x0a, /* d press MCLR. .. */ \
	0x09,0x43,0x6f,0x6e,0x74,0x69,0x6e,0x75,0x65,0x20,0x68,0x6f,0x6c,0x64,0x69,0x6e, /* .Continue holdin */ \
	0x67,0x20,0x42,0x54,0x4e,0x30,0x20,0x75,0x6e,0x74,0x69,0x6c,0x20,0x74,0x68,0x65, /* g BTN0 until the */ \
	0x20,0x4c,0x45,0x44,0x73,0x20,0x66,0x6c,0x61,0x73,0x68,0x2e,0x20,0x20,0x52,0x65, /*  LEDs flash.  Re */ \
	0x6c,0x65,0x61,0x73,0x65,0x20,0x42,0x54,0x4e,0x30,0x20,0x61,0x6e,0x64,0x20,0x70, /* lease BTN0 and p */ \
	0x72,0x65,0x73,0x73,0x20,0x4d,0x43,0x4c,0x52,0x20,0x61,0x67,0x61,0x69,0x6e,0x2e, /* ress MCLR again. */ \
	0x20,0x0d,0x0a,0x09,0x54,0x68,0x69,0x73,0x20,0x70,0x72,0x6f,0x63,0x65,0x64,0x75, /*  ...This procedu */ \
	0x72,0x65,0x20,0x72,0x65,0x73,0x74,0x6f,0x72,0x65,0x73,0x20,0x74,0x68,0x65,0x20, /* re restores the  */ \
	0x63,0x6f,0x6e,0x66,0x69,0x67,0x75,0x72,0x61,0x74,0x69,0x6f,0x6e,0x20,0x73,0x65, /* configuration se */ \
	0x74,0x74,0x69,0x6e,0x67,0x73,0x20,0x69,0x6e,0x20,0x3c,0x63,0x6f,0x64,0x65,0x3e, /* ttings in <code> */ \
	0x54,0x43,0x50,0x49,0x50,0x43,0x6f,0x6e,0x66,0x69,0x67,0x2e,0x68,0x3c,0x2f,0x63, /* TCPIPConfig.h</c */ \
	0x6f,0x64,0x65,0x3e,0x2e,0x20,0x0d,0x0a,0x09,0x59,0x6f,0x75,0x27,0x6c,0x6c,0x20, /* ode>. ...You'll  */ \
	0x62,0x65,0x20,0x61,0x62,0x6c,0x65,0x20,0x74,0x6f,0x20,0x61,0x63,0x63,0x65,0x73, /* be able to acces */ \
	0x73,0x20,0x74,0x68,0x65,0x20,0x62,0x6f,0x61,0x72,0x64,0x20,0x61,0x73,0x20,0x79, /* s the board as y */ \
	0x6f,0x75,0x20,0x64,0x69,0x64,0x20,0x77,0x68,0x65,0x6e,0x20,0x66,0x69,0x72,0x73, /* ou did when firs */ \
	0x74,0x20,0x63,0x6f,0x6e,0x6e,0x65,0x63,0x74,0x69,0x6e,0x67,0x2e,0x20,0x20,0x53, /* t connecting.  S */ \
	0x65,0x65,0x20,0x74,0x68,0x65,0x20,0x0d,0x0a,0x09,0x4d,0x69,0x63,0x72,0x6f,0x63, /* ee the ...Microc */ \
	0x68,0x69,0x70,0x20,0x54,0x43,0x50,0x2f,0x49,0x50,0x20,0x53,0x74,0x61,0x63,0x6b, /* hip TCP/IP Stack */ \
	0x20,0x48,0x65,0x6c,0x70,0x20,0x64,0x69,0x73,0x74,0x72,0x69,0x62,0x75,0x74,0x65, /*  Help distribute */ \
	0x64,0x20,0x77,0x69,0x74,0x68,0x20,0x74,0x68,0x65,0x20,0x73,0x74,0x61,0x63,0x6b, /* d with the stack */ \
	0x20,0x66,0x6f,0x72,0x20,0x69,0x6e,0x73,0x74,0x72,0x75,0x63,0x74,0x69,0x6f,0x6e, /*  for instruction */ \
	0x73,0x2e,0x0d,0x0a,0x09,0x28,0x49,0x66,0x20,0x79,0x6f,0x75,0x20,0x61,0x72,0x65, /* s....(If you are */ \
	0x20,0x75,0x73,0x69,0x6e,0x67,0x20,0x61,0x6e,0x20,0x4d,0x50,0x4c,0x41,0x42,0x20, /*  using an MPLAB  */ \
	0x49,0x43,0x44,0x20,0x33,0x20,0x6f,0x72,0x20,0x4d,0x50,0x4c,0x41,0x42,0x20,0x52, /* ICD 3 or MPLAB R */ \
	0x45,0x41,0x4c,0x20,0x49,0x43,0x45,0x3c,0x73,0x75,0x70,0x3e,0x54,0x4d,0x3c,0x2f, /* EAL ICE<sup>TM</ */ \
	0x73,0x75,0x70,0x3e,0x20,0x69,0x6e,0x20,0x64,0x65,0x62,0x75,0x67,0x20,0x6d,0x6f, /* sup> in debug mo */ \
	0x64,0x65,0x2c,0x20,0x0d,0x0a,0x09,0x4d,0x43,0x4c,0x52,0x20,0x77,0x69,0x6c,0x6c, /* de, ...MCLR will */ \
	0x20,0x6e,0x6f,0x74,0x20,0x77,0x6f,0x72,0x6b,0x20,0x61,0x6e,0x64,0x20,0x79,0x6f, /*  not work and yo */ \
	0x75,0x27,0x6c,0x6c,0x20,0x6e,0x65,0x65,0x64,0x20,0x74,0x6f,0x20,0x72,0x65,0x73, /* u'll need to res */ \
	0x65,0x74,0x20,0x74,0x68,0x65,0x20,0x62,0x6f,0x61,0x72,0x64,0x20,0x76,0x69,0x61, /* et the board via */ \
	0x20,0x74,0x68,0x65,0x20,0x4d,0x50,0x4c,0x41,0x42,0x20,0x49,0x44,0x45,0x2e,0x29, /*  the MPLAB IDE.) */ \
	0x3c,0x2f,0x6c,0x69,0x3e,0x0d,0x0a,0x3c,0x2f,0x6f,0x6c,0x3e,0x0d,0x0a,0x3c,0x2f, /* </li>..</ol>..</ */ \
	0x64,0x69,0x76,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x73,0x63,0x72,0x69,0x70,0x74,0x20, /* div>....<script  */ \
	0x6c,0x61,0x6e,0x67,0x75,0x61,0x67,0x65,0x3d,0x22,0x6a,0x61,0x76,0x61,0x73,0x63, /* language="javasc */ \
	0x72,0x69,0x70,0x74,0x22,0x3e,0x0d,0x0a,0x3c,0x21,0x2d,0x2d,0x0d,0x0a,0x66,0x75, /* ript">..<!--..fu */ \
	0x6e,0x63,0x74,0x69,0x6f,0x6e,0x20,0x72,0x65,0x62,0x6f,0x6f,0x74,0x44,0x75,0x6d, /* nction rebootDum */ \
	0x6d,0x79,0x28,0x78,0x29,0x7b,0x7d,0x0d,0x0a,0x73,0x65,0x74,0x54,0x69,0x6d,0x65, /* my(x){}..setTime */ \
	0x6f,0x75,0x74,0x28,0x22,0x6e,0x65,0x77,0x41,0x4a,0x41,0x58,0x43,0x6f,0x6d,0x6d, /* out("newAJAXComm */ \
	0x61,0x6e,0x64,0x28,0x27,0x2f,0x70,0x72,0x6f,0x74,0x65,0x63,0x74,0x2f,0x72,0x65, /* and('/protect/re */ \
	0x62,0x6f,0x6f,0x74,0x2e,0x63,0x67,0x69,0x27,0x2c,0x72,0x65,0x62,0x6f,0x6f,0x74, /* boot.cgi',reboot */ \
	0x44,0x75,0x6d,0x6d,0x79,0x2c,0x66,0x61,0x6c,0x73,0x65,0x29,0x3b,0x22,0x2c,0x35  /* Dummy,false);",5 */
#define DATACHUNK00001e \
	0x30,0x30,0x29,0x3b,0x0d,0x0a,0x2f,0x2f,0x2d,0x2d,0x3e,0x0d,0x0a,0x3c,0x2f,0x73, /* 00);..//-->..</s */ \
	0x63,0x72,0x69,0x70,0x74,0x3e,0x0d,0x0a,0x7e,0x69,0x6e,0x63,0x3a,0x66,0x6f,0x6f, /* cript>..~inc:foo */ \
	0x74,0x65,0x72,0x2e,0x69,0x6e,0x63,0x7e,0x00,0x00,0x00,0x00,0x33,0x00,0x00,0x00, /* ter.inc~....3... */ \
	0x0c,0x01,0x00,0x00,0x2e,0x00,0x00,0x00,0x22,0x01,0x00,0x00,0x2e,0x00,0x00,0x00, /* ........"....... */ \
	0x75,0x07,0x00,0x00,0x02,0x00,0x00,0x00,0x7e,0x69,0x6e,0x63,0x3a,0x68,0x65,0x61, /* u.......~inc:hea */ \
	0x64,0x65,0x72,0x2e,0x69,0x6e,0x63,0x7e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x20,0x69, /* der.inc~..<div i */ \
	0x64,0x3d,0x22,0x63,0x6f,0x6e,0x74,0x65,0x6e,0x74,0x22,0x3e,0x0d,0x0a,0x0d,0x0a, /* d="content">.... */ \
	0x3c,0x68,0x31,0x3e,0x53,0x4e,0x4d,0x50,0x20,0x43,0x6f,0x6d,0x6d,0x75,0x6e,0x69, /* <h1>SNMP Communi */ \
	0x74,0x79,0x20,0x43,0x6f,0x6e,0x66,0x69,0x67,0x75,0x72,0x61,0x74,0x69,0x6f,0x6e, /* ty Configuration */ \
	0x3c,0x2f,0x68,0x31,0x3e,0x0d,0x0a,0x3c,0x70,0x3e,0x52,0x65,0x61,0x64,0x2f,0x57, /* </h1>..<p>Read/W */ \
	0x72,0x69,0x74,0x65,0x20,0x43,0x6f,0x6d,0x6d,0x75,0x6e,0x69,0x74,0x79,0x20,0x53, /* rite Community S */ \
	0x74,0x72,0x69,0x6e,0x67,0x20,0x63,0x6f,0x6e,0x66,0x69,0x67,0x75,0x72,0x61,0x74, /* tring configurat */ \
	0x69,0x6f,0x6e,0x20,0x66,0x6f,0x72,0x20,0x53,0x4e,0x4d,0x50,0x76,0x32,0x63,0x20, /* ion for SNMPv2c  */ \
	0x41,0x67,0x65,0x6e,0x74,0x2e,0x3c,0x2f,0x70,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76, /* Agent.</p>..<div */ \
	0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x72,0x65,0x73,0x75,0x6c,0x74,0x20,0x66, /*  class="result f */ \
	0x61,0x69,0x6c,0x22,0x20,0x73,0x74,0x79,0x6c,0x65,0x3d,0x22,0x64,0x69,0x73,0x70, /* ail" style="disp */ \
	0x6c,0x61,0x79,0x3a,0x7e,0x73,0x6e,0x6d,0x70,0x5f,0x65,0x6e,0x7e,0x22,0x3e,0x0d, /* lay:~snmp_en~">. */ \
	0x0a,0x53,0x54,0x41,0x43,0x4b,0x5f,0x55,0x53,0x45,0x5f,0x53,0x4e,0x4d,0x50,0x5f, /* .STACK_USE_SNMP_ */ \
	0x53,0x45,0x52,0x56,0x45,0x52,0x20,0x69,0x73,0x20,0x75,0x6e,0x64,0x65,0x66,0x69, /* SERVER is undefi */ \
	0x6e,0x65,0x64,0x2e,0x20,0x20,0x53,0x4e,0x4d,0x50,0x20,0x69,0x73,0x20,0x75,0x6e, /* ned.  SNMP is un */ \
	0x61,0x76,0x61,0x69,0x6c,0x61,0x62,0x6c,0x65,0x2e,0x0d,0x0a,0x3c,0x2f,0x64,0x69, /* available...</di */ \
	0x76,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x70,0x3e,0x43,0x6f,0x6e,0x66,0x69,0x67,0x75, /* v>....<p>Configu */ \
	0x72,0x65,0x20,0x6d,0x75,0x6c,0x74,0x69,0x70,0x6c,0x65,0x20,0x63,0x6f,0x6d,0x6d, /* re multiple comm */ \
	0x75,0x6e,0x69,0x74,0x79,0x20,0x6e,0x61,0x6d,0x65,0x73,0x20,0x69,0x66,0x20,0x79, /* unity names if y */ \
	0x6f,0x75,0x20,0x77,0x61,0x6e,0x74,0x20,0x74,0x68,0x65,0x20,0x53,0x4e,0x4d,0x50, /* ou want the SNMP */ \
	0x20,0x61,0x67,0x65,0x6e,0x74,0x20,0x0d,0x0a,0x74,0x6f,0x20,0x72,0x65,0x73,0x70, /*  agent ..to resp */ \
	0x6f,0x6e,0x64,0x20,0x74,0x6f,0x20,0x74,0x68,0x65,0x20,0x4e,0x4d,0x53,0x2f,0x53, /* ond to the NMS/S */ \
	0x4e,0x4d,0x50,0x20,0x6d,0x61,0x6e,0x61,0x67,0x65,0x72,0x20,0x77,0x69,0x74,0x68, /* NMP manager with */ \
	0x20,0x64,0x69,0x66,0x66,0x65,0x72,0x65,0x6e,0x74,0x20,0x72,0x65,0x61,0x64,0x20, /*  different read  */ \
	0x61,0x6e,0x64,0x20,0x77,0x72,0x69,0x74,0x65,0x20,0x0d,0x0a,0x63,0x6f,0x6d,0x6d, /* and write ..comm */ \
	0x75,0x6e,0x69,0x74,0x79,0x20,0x6e,0x61,0x6d,0x65,0x73,0x2e,0x20,0x49,0x66,0x20, /* unity names. If  */ \
	0x6c,0x65,0x73,0x73,0x20,0x74,0x68,0x61,0x6e,0x20,0x74,0x68,0x72,0x65,0x65,0x20, /* less than three  */ \
	0x63,0x6f,0x6d,0x6d,0x75,0x6e,0x69,0x74,0x69,0x65,0x73,0x20,0x61,0x72,0x65,0x20, /* communities are  */ \
	0x6e,0x65,0x65,0x64,0x65,0x64,0x2c,0x20,0x6c,0x65,0x61,0x76,0x65,0x20,0x0d,0x0a, /* needed, leave .. */ \
	0x65,0x78,0x74,0x72,0x61,0x20,0x66,0x69,0x65,0x6c,0x64,0x73,0x20,0x62,0x6c,0x61, /* extra fields bla */ \
	0x6e,0x6b,0x20,0x74,0x6f,0x20,0x64,0x69,0x73,0x61,0x62,0x6c,0x65,0x20,0x74,0x68, /* nk to disable th */ \
	0x65,0x6d,0x2e,0x3c,0x2f,0x70,0x3e,0x0d,0x0a,0x0d,0x0a,0x0d,0x0a,0x3c,0x66,0x6f, /* em.</p>......<fo */ \
	0x72,0x6d,0x20,0x6d,0x65,0x74,0x68,0x6f,0x64,0x3d,0x22,0x70,0x6f,0x73,0x74,0x22, /* rm method="post" */ \
	0x20,0x61,0x63,0x74,0x69,0x6f,0x6e,0x3d,0x22,0x2f,0x73,0x6e,0x6d,0x70,0x2f,0x73, /*  action="/snmp/s */ \
	0x6e,0x6d,0x70,0x63,0x6f,0x6e,0x66,0x69,0x67,0x2e,0x68,0x74,0x6d,0x22,0x20,0x6e, /* nmpconfig.htm" n */ \
	0x61,0x6d,0x65,0x3d,0x22,0x63,0x6f,0x6e,0x66,0x69,0x67,0x22,0x3e,0x0d,0x0a,0x3c, /* ame="config">..< */ \
	0x66,0x69,0x65,0x6c,0x64,0x73,0x65,0x74,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x64,0x69, /* fieldset>....<di */ \
	0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x52,0x65,0x61,0x64,0x20,0x43,0x6f, /* v><label>Read Co */ \
	0x6d,0x6d,0x31,0x20,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c, /* mm1 :</label>..< */ \
	0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74, /* input type="text */ \
	0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x72,0x63,0x6d,0x30,0x22,0x20,0x76,0x61, /* " name="rcm0" va */ \
	0x6c,0x75,0x65,0x3d,0x22,0x7e,0x72,0x65,0x61,0x64,0x5f,0x63,0x6f,0x6d,0x6d,0x28, /* lue="~read_comm( */ \
	0x30,0x29,0x7e,0x22,0x20,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c, /* 0)~" /></div>..< */ \
	0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x52,0x65,0x61,0x64,0x20, /* div><label>Read  */ \
	0x43,0x6f,0x6d,0x6d,0x32,0x20,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d, /* Comm2 :</label>. */ \
	0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65, /* .<input type="te */ \
	0x78,0x74,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x72,0x63,0x6d,0x31,0x22,0x20, /* xt" name="rcm1"  */ \
	0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x7e,0x72,0x65,0x61,0x64,0x5f,0x63,0x6f,0x6d, /* value="~read_com */ \
	0x6d,0x28,0x31,0x29,0x7e,0x22,0x20,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d, /* m(1)~" /></div>. */ \
	0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x52,0x65,0x61, /* .<div><label>Rea */ \
	0x64,0x20,0x43,0x6f,0x6d,0x6d,0x33,0x20,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c, /* d Comm3 :</label */ \
	0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22, /* >..<input type=" */ \
	0x74,0x65,0x78,0x74,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x72,0x63,0x6d,0x32, /* text" name="rcm2 */ \
	0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x7e,0x72,0x65,0x61,0x64,0x5f,0x63, /* " value="~read_c */ \
	0x6f,0x6d,0x6d,0x28,0x32,0x29,0x7e,0x22,0x20,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76, /* omm(2)~" /></div */ \
	0x3e,0x0d,0x0a,0x0d,0x0a,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62, /* >......<div><lab */ \
	0x65,0x6c,0x3e,0x57,0x72,0x69,0x74,0x65,0x20,0x43,0x6f,0x6d,0x6d,0x31,0x3a,0x3c, /* el>Write Comm1:< */ \
	0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20, /* /label>..<input  */ \
	0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x22,0x20,0x6e,0x61,0x6d,0x65  /* type="text" name */
#define DATACHUNK00001f \
	0x3d,0x22,0x77,0x63,0x6d,0x30,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x7e, /* ="wcm0" value="~ */ \
	0x77,0x72,0x69,0x74,0x65,0x5f,0x63,0x6f,0x6d,0x6d,0x28,0x30,0x29,0x7e,0x22,0x20, /* write_comm(0)~"  */ \
	0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c, /* /></div>..<div>< */ \
	0x6c,0x61,0x62,0x65,0x6c,0x3e,0x57,0x72,0x69,0x74,0x65,0x20,0x43,0x6f,0x6d,0x6d, /* label>Write Comm */ \
	0x32,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70, /* 2:</label>..<inp */ \
	0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x22,0x20,0x6e, /* ut type="text" n */ \
	0x61,0x6d,0x65,0x3d,0x22,0x77,0x63,0x6d,0x31,0x22,0x20,0x76,0x61,0x6c,0x75,0x65, /* ame="wcm1" value */ \
	0x3d,0x22,0x7e,0x77,0x72,0x69,0x74,0x65,0x5f,0x63,0x6f,0x6d,0x6d,0x28,0x31,0x29, /* ="~write_comm(1) */ \
	0x7e,0x22,0x20,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69, /* ~" /></div>..<di */ \
	0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x57,0x72,0x69,0x74,0x65,0x20,0x43, /* v><label>Write C */ \
	0x6f,0x6d,0x6d,0x33,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c, /* omm3:</label>..< */ \
	0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74, /* input type="text */ \
	0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x77,0x63,0x6d,0x32,0x22,0x20,0x76,0x61, /* " name="wcm2" va */ \
	0x6c,0x75,0x65,0x3d,0x22,0x7e,0x77,0x72,0x69,0x74,0x65,0x5f,0x63,0x6f,0x6d,0x6d, /* lue="~write_comm */ \
	0x28,0x32,0x29,0x7e,0x22,0x20,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a, /* (2)~" /></div>.. */ \
	0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x3c,0x2f,0x64, /* ..<div>&nbsp;</d */ \
	0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x69,0x6e,0x70,0x75,0x74, /* iv>..<div><input */ \
	0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x73,0x75,0x62,0x6d,0x69,0x74,0x22,0x20,0x63, /*  type="submit" c */ \
	0x6c,0x61,0x73,0x73,0x3d,0x22,0x73,0x6d,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d, /* lass="sm" value= */ \
	0x22,0x53,0x61,0x76,0x65,0x20,0x43,0x6f,0x6e,0x66,0x69,0x67,0x22,0x20,0x2f,0x3e, /* "Save Config" /> */ \
	0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x2f,0x66,0x69,0x65,0x6c, /* </div>....</fiel */ \
	0x64,0x73,0x65,0x74,0x3e,0x0d,0x0a,0x3c,0x2f,0x66,0x6f,0x72,0x6d,0x3e,0x0d,0x0a, /* dset>..</form>.. */ \
	0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x2f,0x73,0x63,0x72,0x69, /* </div>....</scri */ \
	0x70,0x74,0x3e,0x0d,0x0a,0x7e,0x69,0x6e,0x63,0x3a,0x66,0x6f,0x6f,0x74,0x65,0x72, /* pt>..~inc:footer */ \
	0x2e,0x69,0x6e,0x63,0x7e,0x00,0x00,0x00,0x00,0x33,0x00,0x00,0x00,0xbc,0x00,0x00, /* .inc~....3...... */ \
	0x00,0x49,0x00,0x00,0x00,0x9d,0x02,0x00,0x00,0x42,0x00,0x00,0x00,0xff,0x02,0x00, /* .I.......B...... */ \
	0x00,0x43,0x00,0x00,0x00,0x61,0x03,0x00,0x00,0x44,0x00,0x00,0x00,0xc7,0x03,0x00, /* .C...a...D...... */ \
	0x00,0x45,0x00,0x00,0x00,0x2a,0x04,0x00,0x00,0x46,0x00,0x00,0x00,0x8d,0x04,0x00, /* .E.......F...... */ \
	0x00,0x47,0x00,0x00,0x00,0x2d,0x05,0x00,0x00,0x02,0x00,0x00,0x00                 /* .G...-.......    */


/**************************************
 * MPFS2 C linkable symbols
 **************************************/
// For C18, these are split into seperate arrays because it speeds up compilation a lot.  
// For other compilers, the entire data array must be defined as a single variable to 
// ensure that the linker does not reorder the data chunks in Flash when compiler 
// optimizations are turned on.
#if defined(__18CXX)
	ROM BYTE MPFS_Start[] = {DATACHUNK000000};
	ROM BYTE MPFS_000001[] = {DATACHUNK000001};
	ROM BYTE MPFS_000002[] = {DATACHUNK000002};
	ROM BYTE MPFS_000003[] = {DATACHUNK000003};
	ROM BYTE MPFS_000004[] = {DATACHUNK000004};
	ROM BYTE MPFS_000005[] = {DATACHUNK000005};
	ROM BYTE MPFS_000006[] = {DATACHUNK000006};
	ROM BYTE MPFS_000007[] = {DATACHUNK000007};
	ROM BYTE MPFS_000008[] = {DATACHUNK000008};
	ROM BYTE MPFS_000009[] = {DATACHUNK000009};
	ROM BYTE MPFS_00000a[] = {DATACHUNK00000a};
	ROM BYTE MPFS_00000b[] = {DATACHUNK00000b};
	ROM BYTE MPFS_00000c[] = {DATACHUNK00000c};
	ROM BYTE MPFS_00000d[] = {DATACHUNK00000d};
	ROM BYTE MPFS_00000e[] = {DATACHUNK00000e};
	ROM BYTE MPFS_00000f[] = {DATACHUNK00000f};
	ROM BYTE MPFS_000010[] = {DATACHUNK000010};
	ROM BYTE MPFS_000011[] = {DATACHUNK000011};
	ROM BYTE MPFS_000012[] = {DATACHUNK000012};
	ROM BYTE MPFS_000013[] = {DATACHUNK000013};
	ROM BYTE MPFS_000014[] = {DATACHUNK000014};
	ROM BYTE MPFS_000015[] = {DATACHUNK000015};
	ROM BYTE MPFS_000016[] = {DATACHUNK000016};
	ROM BYTE MPFS_000017[] = {DATACHUNK000017};
	ROM BYTE MPFS_000018[] = {DATACHUNK000018};
	ROM BYTE MPFS_000019[] = {DATACHUNK000019};
	ROM BYTE MPFS_00001a[] = {DATACHUNK00001a};
	ROM BYTE MPFS_00001b[] = {DATACHUNK00001b};
	ROM BYTE MPFS_00001c[] = {DATACHUNK00001c};
	ROM BYTE MPFS_00001d[] = {DATACHUNK00001d};
	ROM BYTE MPFS_00001e[] = {DATACHUNK00001e};
	ROM BYTE MPFS_00001f[] = {DATACHUNK00001f};
#else
	ROM BYTE MPFS_Start[] = {DATACHUNK000000, DATACHUNK000001, DATACHUNK000002, DATACHUNK000003, DATACHUNK000004, DATACHUNK000005, DATACHUNK000006, DATACHUNK000007, DATACHUNK000008, DATACHUNK000009, DATACHUNK00000a, DATACHUNK00000b, DATACHUNK00000c, DATACHUNK00000d, DATACHUNK00000e, DATACHUNK00000f, DATACHUNK000010, DATACHUNK000011, DATACHUNK000012, DATACHUNK000013, DATACHUNK000014, DATACHUNK000015, DATACHUNK000016, DATACHUNK000017, DATACHUNK000018, DATACHUNK000019, DATACHUNK00001a, DATACHUNK00001b, DATACHUNK00001c, DATACHUNK00001d, DATACHUNK00001e, DATACHUNK00001f};
#endif


/**************************************************************
 * End of MPFS
 **************************************************************/
#endif // #if defined(STACK_USE_MPFS2)
#endif // #if !defined(MPFS_USE_EEPROM) && !defined(MPFS_USE_SPI_FLASH)
